/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.ILayoutServiceProvider;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Layouts;
import com.trs.components.common.publish.widget.MasterMgr;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

public class LayoutServiceProvider
implements ILayoutServiceProvider {
    private ILayoutMgr m_oLayoutMgr = (ILayoutMgr)DreamFactory.createObjectById("ILayoutMgr");
    private ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");

    public void delete(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        String string = methodContext.getObjectIds();
        Layouts layouts = Layouts.findByIds(user, string);
        Layouts layouts2 = Layouts.createNewInstance(user);
        for (int i = layouts.size() - 1; i >= 0; --i) {
            Layout layout = (Layout)layouts.getAt(i);
            if (layout == null || SpecialAuthServer.hasRight(user, layout, 23)) continue;
            layouts2.addElement(layout);
            layouts.remove(layout, false);
        }
        this.m_oLayoutMgr.delete(user, layouts);
        if (layouts2.size() > 0) {
            throw new WCMException("\u4f60\u6ca1\u6709\u6743\u9650\u5220\u9664ID\u4e3a[" + layouts2.getIdListAsString() + "]\u7684 \u5e03\u5c40\uff01");
        }
    }

    public Object query(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        WCMFilter wCMFilter = methodContext.getExtraWCMFilter();
        Layouts layouts = this.m_oLayoutMgr.query(user, wCMFilter);
        for (int i = layouts.size() - 1; i >= 0; --i) {
            Layout layout = (Layout)layouts.getAt(i);
            if (layout == null || SpecialAuthServer.hasRight(user, layout, 24)) continue;
            layouts.remove(layout, false);
        }
        return layouts;
    }

    public int save(MethodContext methodContext) throws WCMException {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getObjectId();
        Layout layout = null;
        if (n > 0) {
            layout = Layout.findById(n);
            if (layout == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(MasterMgr.class, "LayoutMgr.label9", "\u6ca1\u6709\u627e\u5230ID\u4e3a[{0}]\u7684\u5e03\u5c40\uff01"), new String[]{String.valueOf(n)}));
            }
        } else {
            layout = Layout.createNewInstance();
        }
        if (!SpecialAuthServer.hasRight(user, layout, 21)) {
            throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u4fee\u6539\u548c\u4fdd\u5b58\u5e03\u5c40\u7684\u6743\u9650\uff01");
        }
        String[] stringArray = new String[]{"ObjectId"};
        layout = (Layout)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, layout, stringArray);
        this.m_oLayoutMgr.save(user, layout);
        return layout.getId();
    }

    public String getLayoutHtml(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("RatioType", Layout.RATIO_TYPE_FIXED);
        String string = methodContext.getValue("Ratio");
        int n2 = string.split(Layout.RATIO_SEPERATE).length;
        Layout layout = Layout.createNewInstance();
        layout.setColumns(n2);
        layout.setRatio(string);
        layout.setRatioType(n);
        this.m_oLayoutMgr.validate(layout);
        return this.m_oLayoutGenerator.generateHtml(layout, true);
    }

    public Object findById(MethodContext methodContext) throws WCMException {
        return null;
    }

    public Object findByIds(MethodContext methodContext) throws WCMException {
        return null;
    }
}

