/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleExporter;
import com.trs.components.common.publish.widget.ContentStyleImporter;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IContentStyleServiceProvider;
import com.trs.components.common.publish.widget.IStyleCenterMgr;
import com.trs.components.common.publish.widget.IStyleItemMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyleServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ContentStyleServiceProvider
implements IContentStyleServiceProvider {
    private static transient Logger mLogger = Logger.getLogger(PageStyleServiceProvider.class);
    private IContentStyleMgr m_oContentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
    private IStyleItemMgr m_oStyleItemMgr = (IStyleItemMgr)DreamFactory.createObjectById("IStyleItemMgr");
    private IStyleCenterMgr m_oStyleCenterMgr = (IStyleCenterMgr)DreamFactory.createObjectById("IStyleCenterMgr");
    private Reports m_copyReports;
    public static final int SYSTEMPAGESTYLEID = 0;
    public static final int PAGESTYLECOUNTONLY = 2;

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        ContentStyles contentStyles = ContentStyles.findByIds(user, string);
        for (int i = 0; i < contentStyles.size(); ++i) {
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null) continue;
            boolean bl = SpecialAuthServer.hasRight(user, contentStyle, 13);
            if (!bl) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
            }
            if (contentStyle.getPageStyleId() == 0) {
                this.m_oStyleCenterMgr.setResoruceStylePrivate(contentStyle);
            }
            String string2 = contentStyle.getStyleName();
            WCMFilter wCMFilter = new WCMFilter("", "StyleName=?", " PageStyleId desc");
            wCMFilter.addSearchValues(string2);
            ContentStyles contentStyles2 = ContentStyles.openWCMObjs(user, wCMFilter);
            if (contentStyles2.size() == 2 && ((ContentStyle)contentStyles2.getAt(1)).getPageStyleId() == 0) {
                this.m_oContentStyleMgr.delete(user, (ContentStyle)contentStyles2.getAt(1));
            }
            this.m_oContentStyleMgr.delete(user, contentStyle);
        }
    }

    public Object query(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, wCMFilter);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bl = SpecialAuthServer.hasRight(user, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        return contentStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save(MethodContext methodContext) throws Throwable {
        String string;
        PageStyle pageStyle;
        int n;
        boolean bl;
        User user = this.getLoginUser();
        int n2 = methodContext.getObjectId();
        int n3 = methodContext.getValue("PageStyleId", -1);
        ContentStyle contentStyle = null;
        if (n2 > 0) {
            contentStyle = ContentStyle.findById(n2);
            if (contentStyle == null) {
                throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyleId=[" + n2 + "]");
            }
        } else {
            contentStyle = new ContentStyle();
        }
        if (!(bl = SpecialAuthServer.hasRight(user, contentStyle, n = n2 > 0 ? 12 : 11))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (n2 > 0 ? "\u4fee\u6539\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01" : "\u65b0\u5efa\u98ce\u683c\uff01"));
        }
        String[] stringArray = new String[]{"ObjectId", "StyleItemXML"};
        contentStyle = (ContentStyle)WCMAJAXServiceHelper.setWCMObjectProperties(user, methodContext, contentStyle, stringArray);
        if (n2 == 0) {
            if (n3 == 0) {
                contentStyle.setIsPrivate(0);
            } else {
                contentStyle.setIsPrivate(1);
            }
        }
        if (!this.m_oContentStyleMgr.checkCssFlag(pageStyle = PageStyle.findById(n3), contentStyle, string = contentStyle.getPropertyAsString("CssFlag"))) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u6807\u8bc6\u4e3a[" + string + "]\u7684\u5185\u5bb9\u98ce\u683c.");
        }
        String string2 = contentStyle.getPropertyAsString("StyleName");
        if (!this.m_oContentStyleMgr.checkStyleName(pageStyle, contentStyle, string2)) {
            throw new WCMException(1008, "\u5728\u5f53\u524d\u9875\u9762\u98ce\u683c\u4e0b\u5df2\u7ecf\u5b58\u5728\u98ce\u683c\u540d\u79f0\u4e3a[" + string2 + "]\u7684\u5185\u5bb9\u98ce\u683c.");
        }
        this.m_oContentStyleMgr.save(user, contentStyle);
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new StyleItem());
        xMLToCMSObj.parse(methodContext.getValue("StyleItemXML"));
        this.m_oStyleItemMgr.deleteUnuseStyleItems(contentStyle, xMLToCMSObj.getObjectIds());
        boolean bl2 = true;
        try {
            int n4 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n4; ++i) {
                StyleItem styleItem = (StyleItem)xMLToCMSObj.getCMSObjs()[i];
                if (styleItem == null) continue;
                this.m_oStyleItemMgr.save(user, contentStyle, styleItem);
            }
            bl2 = false;
            Object var18_18 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (bl2) {
                xMLToCMSObj.cancelUpdate();
            }
            throw throwable;
        }
        if (n2 == 0 && n3 != 0) {
            this.m_oContentStyleMgr.copy(this.getLoginUser(), null, contentStyle);
        }
        if (n3 == 0 && n2 == 0) {
            this.m_oStyleCenterMgr.copyToAllPageSylte(contentStyle);
        }
        try {
            if (n3 != 0) {
                this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), PageStyle.findById(n3));
            }
        }
        catch (WCMException wCMException) {
            mLogger.error((Object)("\u81ea\u52a8\u751f\u6210\u6837\u5f0f\u6587\u4ef6\u51fa\u9519\uff1a" + wCMException));
        }
        return contentStyle.getId();
    }

    public int saveStyleThumb(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("StyleThumb");
        ContentStyle contentStyle = ContentStyle.findById(n);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyle=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, contentStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        contentStyle.setStyleThumb(string);
        this.m_oContentStyleMgr.save(this.getLoginUser(), contentStyle);
        this.m_oStyleCenterMgr.saveStyleThumb(string);
        WCMFilter wCMFilter = new WCMFilter("", "PAGESTYLEID=0 AND CSSFLAG=?", "");
        wCMFilter.addSearchValues(contentStyle.getCssFlag());
        ContentStyles contentStyles = ContentStyles.openWCMObjs(user, wCMFilter);
        if (contentStyles.size() > 0) {
            ContentStyle contentStyle2 = (ContentStyle)contentStyles.getAt(0);
            contentStyle2.setStyleThumb(string);
            contentStyle2.save(this.getLoginUser());
        }
        return contentStyle.getId();
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        return ContentStyle.findById(methodContext.getObjectId());
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return ContentStyles.findByIds(this.getLoginUser(), methodContext.getObjectIds());
    }

    public String copy(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("SourceContentStyleId", -1);
        String string = methodContext.getValue("TargetPageStyleIds");
        int n2 = methodContext.getValue("CopyMode", 1);
        ContentStyle contentStyle = ContentStyle.findById(n);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01SourceContentStyleId=[" + n + "]");
        }
        this.m_copyReports = new Reports("");
        int[] nArray = CMyString.splitToInt(string, ",");
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            int n4 = nArray[i];
            PageStyle pageStyle = PageStyle.findById(n4);
            if (n4 > 0 && pageStyle == null || !(bl = SpecialAuthServer.hasRight(user, contentStyle, 11))) continue;
            ContentStyle contentStyle2 = this.m_oContentStyleMgr.copy(this.getLoginUser(), pageStyle, contentStyle, n2, this.m_copyReports);
            try {
                if (n4 > 0 && pageStyle != null) {
                    this.m_oStyleCenterMgr.createStyleFile(this.getLoginUser(), pageStyle);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            nArray2[i] = contentStyle2 == null ? 0 : contentStyle2.getId();
        }
        this.setReportsTitle();
        return this.m_copyReports.toJSONXML();
    }

    public boolean checkCssFlag(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("PageStyleId", -1);
        String string = methodContext.getValue("CssFlag");
        int n2 = methodContext.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(n2);
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        return this.m_oContentStyleMgr.checkCssFlag(pageStyle, contentStyle, string);
    }

    public String makePreviewCssContent(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        ContentStyle contentStyle = ContentStyle.findById(n);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u53ef\u7528\u98ce\u683c\u5931\u8d25\uff01ContentStyleId=[" + n + "]");
        }
        boolean bl = SpecialAuthServer.hasRight(user, contentStyle, 14);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        return this.m_oStyleCenterMgr.makePreviewCssContent(contentStyle);
    }

    public ContentStyles queryContentStyles(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        WCMFilter wCMFilter = new WCMFilter(methodContext.getQueryFilter());
        ContentStyles contentStyles = this.m_oContentStyleMgr.query(pageStyle, wCMFilter);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bl = SpecialAuthServer.hasRight(user, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        return contentStyles;
    }

    public String previewStyle(MethodContext methodContext) throws Throwable {
        boolean bl;
        User user = this.getLoginUser();
        int n = methodContext.getObjectId();
        String string = methodContext.getValue("CssFlag");
        String string2 = methodContext.getValue("Template");
        int n2 = methodContext.getValue("PageStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n2);
        ContentStyle contentStyle = ContentStyle.findById(n);
        if (contentStyle != null && !(bl = SpecialAuthServer.hasRight(user, contentStyle, 14))) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u9884\u89c8\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        String string3 = methodContext.getValue("CustomStyle");
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new StyleItem());
        xMLToCMSObj.parse(methodContext.getValue("StyleItemXML"));
        StyleItems styleItems = StyleItems.createNewInstance(user);
        int n3 = xMLToCMSObj.getCMSObjs().length;
        for (int i = 0; i < n3; ++i) {
            StyleItem styleItem = (StyleItem)xMLToCMSObj.getCMSObjs()[i];
            if (styleItem == null) continue;
            styleItem.setId(i + 1);
            styleItem.setAddMode(false);
            styleItem.setStyleObjId(n);
            styleItem.setStyleObjType(1791765043);
            styleItems.addElement(styleItem);
        }
        return this.m_oStyleCenterMgr.previewStyle(pageStyle, string, string2, styleItems, string3);
    }

    public HashMap findCssFlagUsedInfo(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("PageStyleId", -1);
        String string = methodContext.getValue("CssFlag");
        int n2 = methodContext.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(n2);
        if (n2 > 0 && contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u5185\u5bb9\u5931\u8d25\uff01ContentStyleId=[" + n2 + "]");
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        HashMap hashMap = this.m_oStyleCenterMgr.findCssFlagUsedStyles(pageStyle, contentStyle, string);
        return hashMap;
    }

    public HashMap findStyleNameUsedInfo(MethodContext methodContext) throws Throwable {
        int n = methodContext.getValue("PageStyleId", -1);
        String string = methodContext.getValue("StyleName");
        int n2 = methodContext.getValue("CurrContentStyleId", -1);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        ContentStyle contentStyle = ContentStyle.findById(n2);
        if (n2 > 0 && contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u98ce\u683c\u5931\u8d25\uff01ResourceStyleId=[" + n2 + "]");
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        HashMap hashMap = this.m_oStyleCenterMgr.findStyleNameUsedStyles(pageStyle, contentStyle, string);
        return hashMap;
    }

    public boolean checkCssFlagOrNameCanUse(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("PageStyleId", 0);
        PageStyle pageStyle = PageStyle.findById(n);
        if (n > 0 && pageStyle == null) {
            throw new WCMException("\u83b7\u53d6\u9875\u9762\u98ce\u683c\u5931\u8d25\uff01PageStyleId=[" + n + "]");
        }
        String string = methodContext.getValue("CssFlag");
        String string2 = methodContext.getValue("StyleName");
        if (CMyString.isEmpty(string) && CMyString.isEmpty(string2)) {
            throw new WCMException("\u98ce\u683c\u6807\u8bc6\u3010CssFlag\u3011\u548c\u98ce\u683c\u540d\u79f0\u3010StyleName\u3011\u5fc5\u987b\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\uff01");
        }
        HashMap hashMap = this.m_oStyleCenterMgr.findCssFlagUsedStyles(pageStyle, null, string);
        ContentStyles contentStyles = (ContentStyles)hashMap.get("ContentStyles");
        if (contentStyles.size() > 0) {
            return false;
        }
        HashMap hashMap2 = this.m_oStyleCenterMgr.findStyleNameUsedStyles(pageStyle, null, string2);
        contentStyles = (ContentStyles)hashMap2.get("ContentStyles");
        return contentStyles.size() <= 0;
    }

    public void resetContentStyle(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("ContentStyleId", 0);
        if (n <= 0) {
            throw new WCMException("\u4f20\u5165\u7684ContentStyleId[" + n + "]\u5e94\u8be5\u5927\u4e8e0\uff01");
        }
        ContentStyle contentStyle = ContentStyle.findById(n);
        if (contentStyle == null) {
            throw new WCMException("\u83b7\u53d6\u5185\u5bb9\u98ce\u683c[id\uff1a" + n + "]\u5931\u8d25\uff01");
        }
        boolean bl = SpecialAuthServer.hasRight(user, contentStyle, 12);
        if (!bl) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u98ce\u683c\u3010" + contentStyle.getStyleDesc() + "\u3011\uff01");
        }
        this.m_oStyleCenterMgr.resetStyle(contentStyle);
    }

    public String exportContentStyleZip(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getObjectIds();
        int n = methodContext.getValue("PageStyleId", 0);
        ContentStyles contentStyles = ContentStyles.findByIds(user, string);
        for (int i = contentStyles.size() - 1; i >= 0; --i) {
            boolean bl;
            ContentStyle contentStyle = (ContentStyle)contentStyles.getAt(i);
            if (contentStyle == null || (bl = SpecialAuthServer.hasRight(user, contentStyle, 4))) continue;
            contentStyles.removeAt(i, false);
        }
        ContentStyleExporter contentStyleExporter = (ContentStyleExporter)DreamFactory.createObjectById("ContentStyleExporter");
        return contentStyleExporter.export(contentStyles, n);
    }

    public Reports importContentStyleZip(MethodContext methodContext) throws Throwable {
        String string = methodContext.getValue("ContentStyleZipFile");
        if (string == null) {
            throw new WCMException("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e3anull!");
        }
        int n = methodContext.getValue("ImportMode", 1);
        int n2 = methodContext.getValue("PageStyleId", 0);
        ContentStyleImporter contentStyleImporter = (ContentStyleImporter)DreamFactory.createObjectById("ContentStyleImporter");
        Reports reports = contentStyleImporter.importFromFile(string, n, n2);
        return reports;
    }

    private void setReportsTitle() {
        int n = this.m_copyReports.getSucessedReporter().size();
        this.m_copyReports.setTitle(CMyString.format("\u5171\u5904\u7406{0}\u4e2a\u98ce\u683c.", new int[]{n}));
    }
}

