/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.taskdispatch;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.Hashtable;

public class PublishErrorLog
extends CMSObj {
    public static final int OBJ_TYPE = 826020995;
    public static final String DB_TABLE_NAME = "WCMPUBLISHERRORLOG";
    public static final String DB_ID_NAME = "PUBLISHERRORLOGID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 826020995;
    }

    public int getPublishTaskId() {
        return this.getPropertyAsInt("PUBLISHTASKID", 0);
    }

    public boolean setPublishTask(int n) throws WCMException {
        return this.setProperty("PUBLISHTASKID", n);
    }

    public boolean setPublishTask(PublishTask publishTask) throws WCMException {
        if (publishTask == null || !publishTask.isValidInstance()) {
            throw new WCMException(10, "PublishTask must be valid instance!");
        }
        return this.setPublishTask(publishTask.getId());
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int n, int n2) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2);
    }

    public boolean setFolder(IPublishFolder iPublishFolder) throws WCMException {
        CMSObj cMSObj = null;
        if (iPublishFolder != null) {
            cMSObj = iPublishFolder.getSubstance();
        }
        if (cMSObj == null) {
            return this.setFolder(0, 0);
        }
        return this.setFolder(cMSObj.getWCMType(), cMSObj.getId());
    }

    public int getContentType() {
        return this.getPropertyAsInt("CONTENTTYPE", 0);
    }

    public int getContentId() {
        return this.getPropertyAsInt("CONTENTID", 0);
    }

    public boolean setContent(int n, int n2) throws WCMException {
        return this.setProperty("CONTENTTYPE", n) && this.setProperty("CONTENTID", n2);
    }

    public boolean setContent(IPublishContent iPublishContent) throws WCMException {
        CMSObj cMSObj = null;
        if (iPublishContent != null) {
            cMSObj = iPublishContent.getSubstance();
        }
        if (cMSObj == null) {
            return this.setContent(0, 0);
        }
        return this.setContent(cMSObj.getWCMType(), cMSObj.getId());
    }

    public int getResult() {
        return this.getPropertyAsInt("EXERESULT", 0);
    }

    public boolean setResult(int n) throws WCMException {
        return this.setProperty("EXERESULT", n);
    }

    public String getDesc() {
        return this.getPropertyAsString("PAGETASKDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("PAGETASKDESC", string);
    }

    public String getErrorDetail() {
        return this.getPropertyAsString("ERRORDETAIL");
    }

    public boolean setErrorDetail(String string) throws WCMException {
        if (string != null && string.length() > 2000) {
            string = string.substring(0, 2000);
        }
        return this.setProperty("ERRORDETAIL", string);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("PUBLISHTASKID") == null) {
                throw new WCMException(1106, "Property of PublishTaskId required!");
            }
            if (this.getAllProperty().get("FOLDERTYPE") == null) {
                throw new WCMException(1106, "Property of FolderTypeConfig required!");
            }
            if (this.getAllProperty().get("FOLDERID") == null) {
                throw new WCMException(1106, "Property of FolderId required!");
            }
            if (this.getAllProperty().get("EXERESULT") == null) {
                throw new WCMException(1106, "Property of Result required!");
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishErrorLog.class, "PublishErrorLog.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            Hashtable hashtable = this.getAllProperty();
            if (hashtable.get("CONTENTTYPE") == null || hashtable.get("CONTENTID") == null) {
                this.setContent(null);
            }
            if (hashtable.get("CRUSER") == null) {
                this.setCrUser(user);
            }
            if (hashtable.get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(user);
        }
    }

    public static final PublishErrorLog findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (PublishErrorLog)BaseObj.findById(PublishErrorLog.class, n);
    }

    public static final PublishErrorLog createNewInstance() throws WCMException {
        return (PublishErrorLog)BaseObj.createNewInstance(PublishErrorLog.class);
    }

    public static final PublishErrorLog findByKey(Object object) throws WCMException {
        return (PublishErrorLog)BaseObj.findByKey(PublishErrorLog.class, object);
    }
}

