/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.element;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishElementType;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.infra.common.WCMException;
import java.util.StringTokenizer;

public class PublishElementFactory {
    public static boolean isFolderType(int n) throws WCMException {
        PublishElementType publishElementType = PublishServerConfigMapper.getElementType(n);
        return publishElementType != null && publishElementType.isFolder();
    }

    public static boolean isContentType(int n) throws WCMException {
        PublishElementType publishElementType = PublishServerConfigMapper.getElementType(n);
        return publishElementType != null && !publishElementType.isFolder();
    }

    public static IPublishElement createElementOfType(int n) throws WCMException {
        PublishElementType publishElementType = PublishServerConfigMapper.getElementType(n);
        if (publishElementType == null) {
            throw new WCMException(226, "unknown publish element type: " + n);
        }
        return publishElementType.createBean();
    }

    public static IPublishElement lookupElement(int n, int n2) throws WCMException {
        IPublishElement iPublishElement = PublishElementFactory.createElementOfType(n);
        if (iPublishElement.loadById(n2)) {
            return iPublishElement;
        }
        return null;
    }

    public static IPublishContent lookupContent(int n, int n2, IPublishFolder iPublishFolder) throws WCMException {
        IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.createElementOfType(n);
        if (iPublishContent.loadById(n2)) {
            if (iPublishFolder != null) {
                iPublishContent.setFolder(iPublishFolder);
            } else {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            }
            return iPublishContent;
        }
        return null;
    }

    public static IPublishElements lookupElements(int n, String string) throws WCMException {
        PublishElementsListImpl publishElementsListImpl = new PublishElementsListImpl();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2);
                IPublishElement iPublishElement = PublishElementFactory.lookupElement(n, n2);
                if (iPublishElement == null) continue;
                if (iPublishElement instanceof IPublishContent) {
                    IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                    iPublishContent.setFolder(iPublishContent.getOriginalHome());
                    publishElementsListImpl.add(iPublishContent);
                    continue;
                }
                publishElementsListImpl.add(iPublishElement);
            }
            return publishElementsListImpl;
        }
        catch (Exception exception) {
            if (!publishElementsListImpl.isEmpty()) {
                publishElementsListImpl.clear();
            }
            throw new WCMException(1100, "Failed to lookup and fetch the contents: Type=" + n + ", Ids=" + string, exception);
        }
    }

    public static IPublishElement makeElementFrom(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, "Valid CMS object required!");
        }
        try {
            IPublishElement iPublishElement = PublishElementFactory.createElementOfType(cMSObj.getWCMType());
            iPublishElement.makeFrom(cMSObj);
            return iPublishElement;
        }
        catch (Exception exception) {
            throw new WCMException(2, "Failed to make publish element from CMS object!", exception);
        }
    }

    public static IPublishContent makeContentFrom(CMSObj cMSObj, IPublishFolder iPublishFolder) throws WCMException {
        if (cMSObj == null) {
            throw new WCMException(10, "Valid CMS object required!");
        }
        try {
            IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.createElementOfType(cMSObj.getWCMType());
            iPublishContent.makeFrom(cMSObj);
            if (iPublishFolder != null) {
                iPublishContent.setFolder(iPublishFolder);
            } else {
                iPublishContent.setFolder(iPublishContent.getOriginalHome());
            }
            return iPublishContent;
        }
        catch (Exception exception) {
            throw new WCMException(2, "Failed to make publish element from CMS object!", exception);
        }
    }

    public static IPublishElements makeElementsFrom(CMSBaseObjs cMSBaseObjs) {
        if (cMSBaseObjs == null) {
            return null;
        }
        return new PublishElementsCMSObjsImpl(cMSBaseObjs);
    }
}

