/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.distribute;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class PublishDistribution
extends CMSObj {
    public static final int OBJ_TYPE = 955;
    public static final String DB_TABLE_NAME = "WCMPUBLISHDISTRIBUTION";
    public static final String DB_ID_NAME = "PUBLISHDISTRIBUTIONID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 955;
    }

    public IPublishFolder getFolder() throws WCMException {
        return (IPublishFolder)PublishElementFactory.lookupElement(this.getFolderType(), this.getFolderId());
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int n, int n2) throws WCMException {
        return this.setProperty("FOLDERTYPE", n) && this.setProperty("FOLDERID", n2);
    }

    public boolean setFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.setFolder(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public String getTargetType() {
        return this.getPropertyAsString("TARGETTYPE");
    }

    public boolean setTargetType(String string) throws WCMException {
        return this.setProperty("TARGETTYPE", string);
    }

    public String getTargetServer() {
        return this.getPropertyAsString("TARGETSERVER");
    }

    public boolean setTargetServer(String string) throws WCMException {
        return this.setProperty("TARGETSERVER", string);
    }

    public int getTargetPort() {
        return this.getPropertyAsInt("TARGETPORT", 0);
    }

    public boolean setTargetPort(int n) throws WCMException {
        return this.setProperty("TARGETPORT", n);
    }

    public String getLoginUser() {
        return this.getPropertyAsString("LOGINUSER");
    }

    public boolean setLoginUser(String string) throws WCMException {
        return this.setProperty("LOGINUSER", string);
    }

    public String getLoginPassword() {
        return this.getPropertyAsString("LOGINPASSWORD");
    }

    public boolean setLoginPassword(String string) throws WCMException {
        return this.setProperty("LOGINPASSWORD", string);
    }

    public String getDataPath() {
        return this.getPropertyAsString("DATAPATH");
    }

    public boolean setDataPath(String string) throws WCMException {
        return this.setProperty("DATAPATH", string);
    }

    public boolean isAnonymous() {
        return this.getPropertyAsBoolean("ANONYMFTP", false);
    }

    public boolean setAnonymous(boolean bl) throws WCMException {
        return this.setProperty("ANONYMFTP", bl);
    }

    public boolean getPassiveMode() {
        return this.getPropertyAsBoolean("PASSIVEMODE", true);
    }

    public boolean setPassiveMode(boolean bl) throws WCMException {
        return this.setProperty("PASSIVEMODE", bl);
    }

    public boolean isEnabled() {
        return this.getPropertyAsBoolean("ENABLED", true);
    }

    public boolean setEnabled(boolean bl) throws WCMException {
        return this.setProperty("ENABLED", bl);
    }

    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TARGETTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label3", "\u5c5e\u6027TargetType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATAPATH") == null) {
                throw new WCMException(1106, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label4", "\u5c5e\u6027DataPath\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(PublishDistribution.class, "PublishDistribution.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ENABLED") == null) {
                this.setEnabled(true);
            }
            super.insert(user);
        }
    }

    public static final PublishDistribution findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (PublishDistribution)BaseObj.findById(PublishDistribution.class, n);
    }

    public static final PublishDistribution createNewInstance() throws WCMException {
        return (PublishDistribution)BaseObj.createNewInstance(PublishDistribution.class);
    }

    public static final PublishDistribution findByKey(Object object) throws WCMException {
        return (PublishDistribution)BaseObj.findByKey(PublishDistribution.class, object);
    }

    public String toString() {
        String string = I18NMessage.get(PublishDistribution.class, "PublishDistribution.label6", "\u5206\u53d1\u4fe1\u606f[Type=") + this.getTargetType() + "  Server=" + this.getTargetServer() + " FolderTypeConfig=" + this.getFolderType() + " FolderId=" + this.getFolderId() + "]";
        return string;
    }
}

