/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.parser;

import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.metadata.publish.WCMTagParserViewData;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class HTMLContentParseHelper {
    private static Logger logger = Logger.getLogger(HTMLContentParseHelper.class);
    private HTMLContent m_oHTMLContent;

    public String makeHTMLContentParsed(PublishTagContext publishTagContext, String string) throws WCMException {
        IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
        String string2 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishContent.getRealHome());
        String string3 = PublishPathCompass.calSubDirectory(iPublishContent, false);
        String string4 = string2 + string3;
        boolean bl = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"));
        String string5 = null;
        if (bl && !publishTagContext.isPreview()) {
            string5 = this.getHtmlContentWithImgSitesPre(string, PublishPathCompass.calFullDataPath(iPublishContent, false));
        } else {
            if (!publishTagContext.getAttribute("UrlIsABS", false)) {
                string4 = HtmlUtil.calRelativePath(string4, publishTagContext.getPageHttpPath());
            } else if (publishTagContext.isPreview()) {
                string4 = publishTagContext.getPathCompass().getPreviewHttpPath(iPublishContent.getRealHome()) + string3;
            }
            this.m_oHTMLContent = new HTMLContent(string);
            string5 = this.m_oHTMLContent.parseHTMLContent(string4);
        }
        if (!CMyString.isEmpty(string5)) {
            HTMLContentParseHelper.distributionHTMLContentFiles(this.m_oHTMLContent.getWCMFiles(), iPublishContent, publishTagContext);
        }
        return string5;
    }

    private String getHtmlContentWithImgSitesPre(String string, String string2) throws WCMException {
        String string3 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
        int n = Integer.parseInt(string3);
        String[] stringArray = HTMLContentParseHelper.convertURL2ImageURL(string2, n);
        this.m_oHTMLContent = new HTMLContent(string);
        return this.m_oHTMLContent.parseHTMLContentWihtMultImgPre(stringArray);
    }

    private static String[] convertURL2ImageURL(String string, int n) throws WCMException {
        String string2 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String string3 = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String[] stringArray = new String[n];
        stringArray[0] = "http://" + string2 + "." + string3 + "/" + string;
        for (int i = 1; i < n; ++i) {
            stringArray[i] = "http://" + string2 + i + "." + string3 + "/" + string;
        }
        return stringArray;
    }

    private static void distributionHTMLContentFiles(List list, IPublishContent iPublishContent, PublishTagContext publishTagContext) {
        try {
            List list2 = list;
            int n = list2.size();
            if (n <= 0) {
                return;
            }
            boolean bl = publishTagContext.isPreview();
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            IPublishFolder iPublishFolder = iPublishContent.getFolder();
            iPublishContent.setFolder(iPublishContent.getRealHome());
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)list2.get(i);
                if (string2 == null || !CMyFile.fileExists(string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2)) continue;
                String string3 = publishPathCompass.getLocalPath(iPublishContent, bl);
                PublishSyncGlobalTuner.insureLocalPathExists(string3);
                CMyFile.copyFile(string, string3 + string2);
                if (bl) continue;
                publishTagContext.getFileDistributeShip().distributeFile(string, iPublishContent, null, true);
            }
            iPublishContent.setFolder(iPublishFolder);
        }
        catch (Exception exception) {
            String string = I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label13", "\u53d1\u5e03") + iPublishContent + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label14", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01");
            logger.error((Object)string, (Throwable)exception);
            publishTagContext.getPageContext().addErrorLog(0, string, exception);
        }
    }
}

