/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IWidgetInstParameterMgr;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstParameters;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.common.publish.widget.WidgetInstances;
import com.trs.components.wcm.content.service.portervisitors.IPorterVisitor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class VisualTemplatePorterVistor
implements IPorterVisitor {
    private static Logger logger = Logger.getLogger(VisualTemplatePorterVistor.class);
    private IWidgetInstanceMgr m_oWidgetInstanceMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
    private IWidgetInstParameterMgr m_oWidgetInstParameterMgr = (IWidgetInstParameterMgr)DreamFactory.createObjectById("IWidgetInstParameterMgr");
    private Map m_oInstanceIdMapping;
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)(<trs_widget[^>]+)id=[\"'](\\d+)[\"']([^>]*>)");

    public void doExport(BaseObj baseObj, Object object) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u5904\u7406\u6a21\u677f\u7684Porter");
        if (!(baseObj instanceof Template)) {
            return;
        }
        Template template = (Template)baseObj;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5df2\u7ecf\u8bc6\u522b\u4e3a\u53ef\u89c6\u5316\u6a21\u677f" + template));
        }
        ObjToXmlConverter objToXmlConverter = new ObjToXmlConverter();
        Object[] objectArray = (Object[])object;
        BaseObjToXmlConverter baseObjToXmlConverter = (BaseObjToXmlConverter)objectArray[0];
        Element element = (Element)objectArray[1];
        WidgetInstances widgetInstances = this.m_oWidgetInstanceMgr.getWidgetInstances(template);
        element = element.addElement("XWCMWIDGETINSTANCES");
        int n = widgetInstances.size();
        for (int i = 0; i < n; ++i) {
            WidgetInstance widgetInstance = (WidgetInstance)widgetInstances.getAt(i);
            if (widgetInstance == null) continue;
            Element element2 = objToXmlConverter.toXmlElement(widgetInstance);
            element.add(element2);
            WidgetInstParameters widgetInstParameters = this.m_oWidgetInstParameterMgr.getWidgetInstParameters(widgetInstance, null);
            baseObjToXmlConverter.addChildElements(element2, new Element[]{baseObjToXmlConverter.toXmlElement(widgetInstParameters, null)});
        }
    }

    public void doImport(BaseObj baseObj, XmlObject xmlObject, Object object) throws Exception {
        logger.debug((Object)"into template doimport...");
        Template template = (Template)baseObj;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        boolean bl = false;
        XmlObject xmlObject2 = null;
        XmlObject[] xmlObjectArray = (XmlObject[])object;
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            xmlObject2 = xmlObjectArray[i];
            Template template2 = (Template)xmlObject2.getCurrentObj();
            if (!this.isEquals(template, template2)) continue;
            bl = true;
            break;
        }
        if (!bl || xmlObject2 == null) {
            return;
        }
        XmlObject[] xmlObjectArray2 = xmlObject2.getChild("XWCMWIDGETINSTANCES");
        if (xmlObjectArray2.length <= 0) {
            return;
        }
        if (template.getId() == 0) {
            template.setNextId();
        }
        logger.debug((Object)"\u5f00\u59cb\u53ef\u89c6\u5316\u6a21\u677f\u7684\u5bfc\u5165\u5904\u7406...");
        this.m_oInstanceIdMapping = new HashMap();
        for (int i = 0; i < xmlObjectArray2.length; ++i) {
            WidgetInstance widgetInstance = (WidgetInstance)xmlObjectArray2[i].getCurrentObj();
            String string = String.valueOf(widgetInstance.getId());
            widgetInstance = this.saveNewWidgetInstance(template, widgetInstance);
            this.m_oInstanceIdMapping.put(string, String.valueOf(widgetInstance.getId()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u8bb0\u5f55\u7684\u8d44\u6e90\u5b9e\u4f8bid\u6620\u5c04\u5173\u7cfb\u4e3a:");
            logger.debug((Object)this.m_oInstanceIdMapping);
        }
        String string = this.replaceWidgetInstId(template.getText(), this.m_oInstanceIdMapping);
        template.setText(string);
    }

    private boolean isEquals(Template template, Template template2) {
        if (template == template2) {
            return true;
        }
        if (template.getId() == template2.getId()) {
            return true;
        }
        return template.getName().equals(template2.getName()) && template.getFolderId() == template2.getFolderId() && template.getFolderType() == template2.getFolderType();
    }

    private WidgetInstance saveNewWidgetInstance(Template template, WidgetInstance widgetInstance) throws WCMException {
        WidgetInstance widgetInstance2 = this.m_oWidgetInstanceMgr.clone(widgetInstance);
        widgetInstance2.setTemplateId(template.getId());
        widgetInstance2.save(ContextHelper.getLoginUser());
        return widgetInstance2;
    }

    private WidgetInstParameter saveWidgetInstParameters(WidgetInstance widgetInstance, WidgetInstParameter widgetInstParameter) throws WCMException {
        widgetInstParameter.setWidgetInstId(widgetInstance.getId());
        widgetInstParameter.save(ContextHelper.getLoginUser());
        return widgetInstParameter;
    }

    private String replaceWidgetInstId(String string, Map map) {
        if (CMyString.isEmpty(string)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Matcher matcher = m_oInstancePattern.matcher(string);
        int n = 0;
        int n2 = 0;
        while (matcher.find()) {
            n = matcher.start();
            stringBuffer.append(string.substring(n2, n));
            n2 = matcher.end();
            stringBuffer.append(matcher.group(1));
            String string2 = matcher.group(2);
            stringBuffer.append("id=\"").append((String)map.get(string2)).append("\"");
            stringBuffer.append(matcher.group(3));
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public String[] registerTargetClassName() {
        return new String[]{Template.class.getName()};
    }
}

