/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateQuoteMgr0310 {
    private static final Logger logger = Logger.getLogger((String)TemplateQuoteMgr0310.class.getName());
    private static final long MAX_USE_TIME = 400L;

    public void save(TemplateQuote templateQuote) throws WCMException {
        if (templateQuote == null) {
            throw new WCMException(10, "Valid quote required!");
        }
        templateQuote.save(ContextHelper.getLoginUser());
    }

    public void save(List list) throws WCMException {
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            User user = ContextHelper.getLoginUser();
            for (int i = 0; i < list.size(); ++i) {
                TemplateQuote templateQuote = (TemplateQuote)list.get(i);
                if (templateQuote == null) continue;
                templateQuote.save(user);
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to save the template quotes list!", exception);
        }
    }

    int clearQuotesOfTemplate(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(1100, "Valid template required!");
        }
        return this.clearQuotesOfTemplate(template.getId());
    }

    /*
     * Loose catch block
     */
    int clearQuotesOfTemplate(int n) throws WCMException {
        int n2;
        DBManager dBManager;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            connection = null;
            preparedStatement = null;
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?");
            preparedStatement.setInt(1, n);
            n2 = preparedStatement.executeUpdate();
            Object var8_7 = null;
            if (preparedStatement == null) break block9;
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return n2;
        catch (Exception exception) {
            try {
                throw new WCMException(1100, "Failed to clear template quotes record!", exception);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_8 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2) {
                            logger.error((Object)"Failed to close prepared statement", (Throwable)exception2);
                        }
                    }
                    if (connection == null) break block10;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public int clearQuotesOfFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.clearQuotesOfFolder(iPublishFolder.getType(), iPublishFolder.getId());
    }

    /*
     * Loose catch block
     */
    public int clearQuotesOfFolder(int n, int n2) throws WCMException {
        int n3;
        DBManager dBManager;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            connection = null;
            preparedStatement = null;
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?");
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            n3 = preparedStatement.executeUpdate();
            Object var9_8 = null;
            if (preparedStatement == null) break block9;
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return n3;
        catch (Exception exception) {
            try {
                throw new WCMException(1100, "Failed to clear template quotes record!", exception);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var9_9 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2) {
                            logger.error((Object)"Failed to close prepared statement", (Throwable)exception2);
                        }
                    }
                    if (connection == null) break block10;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List getFoldersWhoseOutlineQuotesContentsOf(IPublishFolder iPublishFolder) throws WCMException {
        Exception exception222;
        ArrayList<IPublishFolder> arrayList;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        DBManager dBManager;
        block27: {
            IPublishElements iPublishElements;
            IPublishFolder iPublishFolder2;
            if (iPublishFolder == null) {
                throw new WCMException(10, "Quoted folder required!");
            }
            if (iPublishFolder.isRoot()) {
                return null;
            }
            DebugTimer debugTimer = new DebugTimer();
            dBManager = null;
            connection = null;
            statement = null;
            resultSet = null;
            int n = iPublishFolder.getSiblingIndex();
            IPublishFolder iPublishFolder3 = iPublishFolder.getParent();
            if (iPublishFolder3 == null) {
                throw new Exception("Parent of quoted folder (" + iPublishFolder.getInfo() + ") not found!");
            }
            dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection();
            statement = connection.prepareStatement("SELECT DISTINCT EMPLOYERTYPE, EMPLOYERID FROM V_TEMPLATEEMPLOY employ, WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND employ.TEMPLATETYPE=? AND QUOTETYPE=? AND ((QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?) OR (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
            statement.setInt(1, 1);
            statement.setInt(2, 1);
            statement.setInt(3, iPublishFolder.getId());
            statement.setInt(4, -1);
            statement.setInt(5, iPublishFolder.getType());
            statement.setInt(6, iPublishFolder3.getId());
            statement.setInt(7, n);
            statement.setInt(8, iPublishFolder3.getType());
            debugTimer.start();
            resultSet = statement.executeQuery();
            debugTimer.stop();
            if (logger.isDebugEnabled() && debugTimer.getTime() > 400L) {
                logger.debug((Object)("execute[SELECT DISTINCT EMPLOYERTYPE, EMPLOYERID FROM V_TEMPLATEEMPLOY employ, WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND employ.TEMPLATETYPE=? AND QUOTETYPE=? AND ((QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?) OR (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + debugTimer.getTime() + "]ms"));
                logger.debug((Object)("parameters:[1] [1] [" + iPublishFolder.getId() + "] [" + -1 + "] [" + iPublishFolder.getType() + "] [" + iPublishFolder3.getId() + "] [" + n + "]" + "[" + iPublishFolder3.getType() + "]"));
            }
            ArrayList<IPublishFolder> arrayList2 = new ArrayList<IPublishFolder>();
            while (resultSet.next()) {
                int n2;
                int n3 = resultSet.getInt(1);
                iPublishFolder2 = (IPublishFolder)PublishElementFactory.lookupElement(n3, n2 = resultSet.getInt(2));
                if (iPublishFolder2 == null) continue;
                arrayList2.add(iPublishFolder2);
            }
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            if (arrayList2.indexOf(iPublishFolder3) < 0) {
                statement = connection.prepareStatement("SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
                statement.setMaxRows(1);
                statement.setInt(1, iPublishFolder3.getType());
                statement.setInt(2, iPublishFolder3.getId());
                statement.setInt(3, 1);
                statement.setInt(4, 0);
                statement.setInt(5, 0);
                statement.setInt(6, n);
                debugTimer.start();
                resultSet = statement.executeQuery();
                debugTimer.stop();
                if (logger.isDebugEnabled() && debugTimer.getTime() > 400L) {
                    logger.debug((Object)("execute[SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + debugTimer.getTime() + "]ms"));
                    logger.debug((Object)("parameters:[" + iPublishFolder3.getType() + "] [" + iPublishFolder3.getId() + "] [" + 1 + "] [0] [0] [" + n + "]"));
                }
                if (resultSet.next()) {
                    arrayList2.add(iPublishFolder3);
                }
                resultSet.close();
            }
            if ((iPublishElements = iPublishFolder.getChildren()) != null && !iPublishElements.isEmpty()) {
                for (int i = 0; i < iPublishElements.size(); ++i) {
                    iPublishFolder2 = (IPublishFolder)iPublishElements.get(i);
                    if (iPublishFolder2 == null || arrayList2.indexOf(iPublishFolder2) >= 0) continue;
                    if (statement == null) {
                        statement = connection.prepareStatement("SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
                        statement.setMaxRows(1);
                        statement.setInt(3, 1);
                        statement.setInt(4, 0);
                        statement.setInt(5, 0);
                        statement.setInt(6, -2);
                    }
                    statement.setInt(1, iPublishFolder2.getId());
                    statement.setInt(2, iPublishFolder2.getType());
                    debugTimer.start();
                    resultSet = statement.executeQuery();
                    debugTimer.stop();
                    if (logger.isDebugEnabled() && debugTimer.getTime() > 400L) {
                        logger.debug((Object)("execute[SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + debugTimer.getTime() + "]ms"));
                        logger.debug((Object)("parameters:[" + iPublishFolder2.getId() + "] [" + iPublishFolder2.getType() + "] [" + 1 + "] [0] [0] [" + -2 + "]"));
                    }
                    if (resultSet.next()) {
                        arrayList2.add(iPublishFolder2);
                    }
                    resultSet.close();
                }
            }
            arrayList = arrayList2;
            Object var19_17 = null;
            if (resultSet == null) break block27;
            try {
                resultSet.close();
            }
            catch (Exception exception222) {
                logger.error((Object)"Failed to close result!", (Throwable)exception222);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception222) {
                logger.error((Object)"Failed to close prepared statement!", (Throwable)exception222);
            }
        }
        if (connection != null) {
            dBManager.freeConnection(connection);
        }
        return arrayList;
        catch (Exception exception3) {
            try {
                throw new WCMException(1100, "Failed to query and fetch the folders quoting the specified folder!", exception3);
            }
            catch (Throwable throwable) {
                block29: {
                    Exception exception4222;
                    Object var19_18 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception4222) {
                            logger.error((Object)"Failed to close result!", (Throwable)exception4222);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception4222) {
                            logger.error((Object)"Failed to close prepared statement!", (Throwable)exception4222);
                        }
                    }
                    if (connection == null) break block29;
                    dBManager.freeConnection(connection);
                }
                throw throwable;
            }
        }
    }
}

