/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateQuoteMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateQuoteMgr.class.getName());

    public void save(TemplateQuote templateQuote) throws WCMException {
        if (templateQuote == null) {
            throw new WCMException(10, "Valid quote required!");
        }
        templateQuote.save(ContextHelper.getLoginUser());
    }

    public void save(List list) throws WCMException {
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            User user = ContextHelper.getLoginUser();
            for (int i = 0; i < list.size(); ++i) {
                TemplateQuote templateQuote = (TemplateQuote)list.get(i);
                if (templateQuote == null) continue;
                templateQuote.save(user);
            }
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to save the template quotes list!", exception);
        }
    }

    int clearQuotesOfTemplate(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(1100, "Valid template required!");
        }
        return this.clearQuotesOfTemplate(template.getId());
    }

    int clearQuotesOfTemplate(int n) throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?");
            preparedStatement.setInt(1, n);
            int n2 = preparedStatement.executeUpdate();
            return n2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to clear template quotes record!", exception);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public int clearQuotesOfFolder(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.clearQuotesOfFolder(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public int clearQuotesOfFolder(int n, int n2) throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?");
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            int n3 = preparedStatement.executeUpdate();
            return n3;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to clear template quotes record!", exception);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    private boolean isExcludeFolder(List list, IPublishFolder iPublishFolder, IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement == null) {
            return true;
        }
        if (list != null && list.contains(iPublishElement)) {
            return true;
        }
        if (iPublishElement == null || !iPublishElement.isFolder() || !((IPublishFolder)iPublishElement).canDoOutlinePageTask()) {
            return true;
        }
        if (iPublishElement.getType() == iPublishFolder.getType() && iPublishElement.getId() == iPublishFolder.getId()) {
            return true;
        }
        IPublishFolder iPublishFolder2 = (IPublishFolder)iPublishElement;
        return iPublishFolder2.isDeleted();
    }

    public List getFoldersWhoseOutlineQuotesContentsOf(IPublishFolder iPublishFolder) throws WCMException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        ArrayList<IPublishElement> arrayList = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            IPublishElement iPublishElement;
            int n;
            int n2;
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and exists(   select TemplateId from WCMTemplateQuote     where QuotedFolderId=? and QuotedFolderType=? and QuoteType=1 and FamilyIndex=-1     and WCMTemplateEmploy.TemplateId=WCMTemplateQuote.TemplateId  )");
            preparedStatement.setInt(1, iPublishFolder.getId());
            preparedStatement.setInt(2, iPublishFolder.getType());
            resultSet = preparedStatement.executeQuery();
            arrayList = new ArrayList<IPublishElement>();
            while (resultSet.next()) {
                n2 = resultSet.getInt(1);
                iPublishElement = PublishElementFactory.lookupElement(n2, n = resultSet.getInt(2));
                if (this.isExcludeFolder(null, iPublishFolder, iPublishElement)) continue;
                arrayList.add(iPublishElement);
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("select distinct EmployerType, EmployerId from WCMTemplateEmploy where TemplateType=1 and  exists( select WCMTemplateNest.TemplateId from WCMTemplateNest       where WCMTemplateEmploy.TemplateId=WCMTemplateNest.TemplateId        and exists(        select TemplateId from WCMTemplateQuote              where QuotedFolderId=? and QuotedFolderType=?  and QuoteType=1 and FamilyIndex=-1             and WCMTemplateNest.NestedTemplateId=WCMTemplateQuote.TemplateId        )     )");
            preparedStatement.setInt(1, iPublishFolder.getId());
            preparedStatement.setInt(2, iPublishFolder.getType());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = resultSet.getInt(1);
                iPublishElement = PublishElementFactory.lookupElement(n2, n = resultSet.getInt(2));
                if (this.isExcludeFolder(arrayList, iPublishFolder, iPublishElement)) continue;
                arrayList.add(iPublishElement);
            }
            if (!iPublishFolder.isRoot()) {
                resultSet.close();
                preparedStatement.close();
                preparedStatement = connection.prepareStatement("select distinct FolderType, FolderId from WCMChannelChildIndexQuote where QuoteChannelId=?");
                preparedStatement.setInt(1, iPublishFolder.getId());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    iPublishElement = PublishElementFactory.lookupElement(n2, n = resultSet.getInt(2));
                    if (this.isExcludeFolder(arrayList, iPublishFolder, iPublishElement)) continue;
                    arrayList.add(iPublishElement);
                }
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to Desc!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close result", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
        debugTimer.stop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get[" + iPublishFolder.getInfo() + "] quote use [" + debugTimer.getTime() + "]ms"));
        }
        return arrayList;
    }
}

