/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseAngel;
import com.trs.components.common.publish.domain.template.TemplateQuoteMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class TemplateParseMgr
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private Logger logger = Logger.getLogger((String)TemplateParseMgr.class.getName());
    private static final List DATEREL_ATTRS = Arrays.asList("LOCALE", "TIMEZONE", "INMILLIS", "ONLYTEMPLATENAME");
    private LRUCacheContainer m_cache;
    private TemplateNestMgr m_templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
    private TemplateQuoteMgr m_templateQuoteMgr = (TemplateQuoteMgr)DreamFactory.createObjectById("TemplateQuoteMgr");

    public TemplateParseMgr() {
        this.m_cache = new LRUCacheContainer();
        try {
            TemplateParseConfig templateParseConfig = PublishServerConfigMapper.getTemplateParseConfig();
            this.m_cache.setMaxSize(templateParseConfig.getDomCacheMaxSize());
            this.logger.info((Object)("Template name cache maximum size: " + this.m_cache.getMaxSize()));
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to load configuration from publish server config!", (Throwable)exception);
        }
        TemplateParseAngel.scanAll();
    }

    public void setCacheMaxSize(int n) {
        this.m_cache.setMaxSize(n);
    }

    public int getCacheMaxSize() {
        return this.m_cache.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagDocument parse(Template template) throws Exception {
        if (template == null) {
            throw new WCMException(10, "Template required!");
        }
        Integer n = new Integer(template.getId());
        TagDocument tagDocument = (TagDocument)this.m_cache.get((Object)n);
        if (tagDocument != null) {
            return tagDocument;
        }
        Template template2 = template;
        synchronized (template2) {
            tagDocument = (TagDocument)this.m_cache.get((Object)n);
            if (tagDocument != null) {
                return tagDocument;
            }
            String string = template.getPubText();
            try {
                tagDocument = TagDocumentReader.read(string);
            }
            catch (Exception exception) {
                this.logger.error((Object)("Failed to read DOM of the template [" + template.getId() + "]"), (Throwable)exception);
                throw new WCMException(220, "Failed to read DOM of the template [" + template.getId() + "](" + template.getName() + ")", exception);
            }
            if (!template.isParsed()) {
                this.logger.debug((Object)("to analyze semantic rules in template [" + template.getId() + "] "));
                this.clearSemanticRules(template);
                this.buildSemanticRules(template, tagDocument);
                this.updateTemplateParsedFlag(template);
                this.uploadAppendixes(template, false);
            }
            this.uploadParameters(template, tagDocument);
            this.m_cache.put((Object)n, (Object)tagDocument);
        }
        return tagDocument;
    }

    public void notifyTemplateAdded(Template template) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateAdded: " + template.getInfo()));
        }
        TemplateParseAngel.scan(template);
    }

    public void notifyTemplateModified(Template template) throws WCMException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateModified: " + template.getInfo()));
        }
        this.clearSemanticRules(template);
        this.removeCache(template);
        TemplateParseAngel.scan(template);
    }

    public void notifyTemplateDeleted(Template template) throws WCMException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("notifyTemplateDeleted: " + template.getInfo()));
        }
        this.clearSemanticRules(template);
        this.removeCache(template);
    }

    private void removeCache(Template template) {
        Integer n = new Integer(template.getId());
        TagDocument tagDocument = (TagDocument)this.m_cache.remove((Object)n);
        if (tagDocument != null) {
            tagDocument.clear();
        }
    }

    private void clearSemanticRules(Template template) throws WCMException {
        try {
            this.m_templateNestMgr.clearNestRecordsOf(template);
            this.m_templateQuoteMgr.clearQuotesOfTemplate(template);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to clear the old result before analyzing template semantic rules!", exception);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSemanticRules(Template template, TagDocument tagDocument) throws WCMException {
        List<Object> list = null;
        try {
            IPublishFolder iPublishFolder = template.getRoot();
            if (iPublishFolder == null) {
                throw new WCMException("Root of " + template.getInfo() + " not exist: type=" + template.getRootType() + ",id=" + template.getRootId());
            }
            int n = template.getType();
            int n2 = template.getId();
            for (int i = 0; i < tagDocument.getItemCount(); ++i) {
                Object object;
                Object object2 = tagDocument.getItemAt(i);
                if (object2 instanceof String) continue;
                TagItem tagItem = (TagItem)object2;
                String string = tagItem.getName();
                if (TagParserFactory.isNestedTemplateTag(string)) {
                    object = tagItem.getAttribute("TEMPNAME");
                    if (TagItem.isVariableParameter((String)object)) continue;
                    Template template2 = null;
                    try {
                        template2 = TagParseHelper.findNestedTemplate((String)object, iPublishFolder);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (template2 == null) continue;
                    this.m_templateNestMgr.addNestRecord(n2, template2.getId());
                    if (template2.isParsed()) continue;
                    int n3 = 8;
                    list = (List)ContextParameters.get(n3, true);
                    if (list == null) {
                        list = new ArrayList<Object>(4);
                        ContextParameters.set(n3, list);
                    } else if (list.contains(object)) {
                        throw new WCMException(234, I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label1", "\u5d4c\u5957\u6a21\u677f\u5b58\u5728\u5d4c\u5957\u73af\u8def") + list + ":" + (String)object);
                    }
                    list.add(object);
                    this.parse(template2);
                    continue;
                }
                object = TagParserFactory.createParserByName(string);
                if (object == null) {
                    throw new WCMException(10, "Unsupported tag <" + string + ">");
                }
                try {
                    object.setTagItem(tagItem);
                    TemplateQuote[] templateQuoteArray = object.analyzeQuotes(iPublishFolder);
                    if (templateQuoteArray == null) continue;
                    for (int j = 0; j < templateQuoteArray.length; ++j) {
                        TemplateQuote templateQuote = templateQuoteArray[j];
                        if (templateQuote == null) continue;
                        templateQuote.setTemplate(n2, n);
                        this.m_templateQuoteMgr.save(templateQuote);
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new WCMException(234, "Failed to analyze the quoting relations in tag: " + tagItem.toString(), exception);
                }
            }
        }
        catch (WCMException wCMException) {
            try {
                throw wCMException;
                catch (Exception exception) {
                    throw new WCMException(233, "Failed to analyze the semantic rules for " + template.getInfo(), exception);
                }
            }
            catch (Throwable throwable) {
                list = (ArrayList<Object>)ContextParameters.get(8);
                if (list != null) {
                    list.clear();
                    list = null;
                }
                throw throwable;
            }
        }
        list = (List)ContextParameters.get(8);
        if (list != null) {
            list.clear();
            return;
        }
    }

    private void updateTemplateParsedFlag(Template template) throws WCMException {
        try {
            String string = "UPDATE WCMTEMPLATE SET IsParsed=1 WHERE TEMPID=" + template.getId();
            DBManager.getDBManager().sqlExecuteUpdate(string);
            template.refreshProperty("ISPARSED", true);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to update the template parsed flag!", exception);
        }
    }

    public void uploadAppendixes(Template template, boolean bl) throws WCMException {
        if (template == null || !bl && !template.isApdModified()) {
            return;
        }
        int[] nArray = null;
        if (!bl) {
            nArray = new int[]{0, 2};
        }
        TempAppendixes tempAppendixes = null;
        TempAppendix tempAppendix = null;
        IPublishFolder iPublishFolder = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer();
        FileDistributeShip fileDistributeShip = null;
        PublishPathCompass publishPathCompass = null;
        try {
            Object object;
            User user = ContextHelper.getLoginUser();
            tempAppendixes = template.getAppendixes(user, nArray);
            for (int i = 0; i < tempAppendixes.size(); ++i) {
                tempAppendix = (TempAppendix)tempAppendixes.getAt(i);
                if (tempAppendix == null) continue;
                if (iPublishFolder == null) {
                    iPublishFolder = template.getRoot();
                    string = FilesMan.getFilesMan().getTemplateAppendixPath(iPublishFolder.getType(), iPublishFolder.getId(), 0, true);
                    publishPathCompass = new PublishPathCompass();
                    string2 = publishPathCompass.getLocalPath(iPublishFolder, false) + "images/";
                    string3 = publishPathCompass.getLocalPath(iPublishFolder, true) + "images/";
                    PublishSyncGlobalTuner.insureLocalPathExists(string2);
                    PublishSyncGlobalTuner.insureLocalPathExists(string3);
                }
                string4 = CMyFile.extractFileName(tempAppendix.getFile());
                string5 = string + string4;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("to copy template appendix file [" + string5 + "] to [" + string2 + "] and [" + string3 + "]"));
                }
                if (CMyFile.fileExists(string5)) {
                    CMyFile.copyFile(string5, string2 + string4);
                    CMyFile.copyFile(string5, string3 + string4);
                    if (fileDistributeShip == null) {
                        fileDistributeShip = new FileDistributeShip(publishPathCompass);
                        fileDistributeShip.setBatchMode(true);
                    }
                    fileDistributeShip.distributeFile(string5, iPublishFolder, "images/");
                } else {
                    object = "Appendix file of " + template.getInfo() + " missing: " + string5;
                    this.logger.error(object);
                    stringBuffer.append("\n").append((String)object);
                }
                if (tempAppendix.getFlag() == 3) continue;
                tempAppendix.canEdit(user);
                try {
                    tempAppendix.setFlag(3);
                    tempAppendix.update(user);
                    continue;
                }
                catch (Exception exception) {
                    tempAppendix.cancelUpdate(user);
                    throw exception;
                }
            }
            if (template.isApdModified()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"to update template ApdModified = false ...");
                }
                template.canEdit(user);
                try {
                    template.setApdModified(false);
                    template.update(user);
                }
                catch (Exception exception) {
                    template.cancelUpdate(user);
                    throw exception;
                }
            }
            if (stringBuffer.length() > 0 && NotificationServer.getInstance().needNotifyForEvent("Publish.WhenTemplateAppendixNotFound")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"to send notification on event Publish.WhenTemplateAppendixNotFound");
                }
                object = new Notifier();
                ((Notifier)object).setParameter("TemplateInfo", template.getInfo());
                ((Notifier)object).setParameter("Message", stringBuffer.toString());
                ((Notifier)object).executeOnEvent("Publish.WhenTemplateAppendixNotFound");
            }
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to upload the appendixes of " + template.getInfo(), exception);
        }
        finally {
            stringBuffer.setLength(0);
            if (tempAppendixes != null) {
                tempAppendixes.clear();
            }
            if (publishPathCompass != null) {
                publishPathCompass.clear();
            }
            if (fileDistributeShip != null) {
                fileDistributeShip.clear();
            }
        }
    }

    private void uploadParameters(Template template, TagDocument tagDocument) throws WCMException {
        Object object;
        Object object2;
        Object object3;
        TemplateParameterList templateParameterList = new TemplateParameterList();
        TemplateParameterList templateParameterList2 = template.getTemplateParameters();
        HashMap hashMap = templateParameterList2 != null ? templateParameterList2.getNameMaps() : null;
        Iterator iterator = tagDocument.findItems(null);
        while (iterator.hasNext() && (object3 = (TagItem)iterator.next()) != null) {
            Iterator iterator2;
            object2 = ((TagItem)object3).getVariableParameters();
            if (object2 == null || (iterator2 = ((HashMap)object2).values().iterator()) == null) continue;
            while (iterator2.hasNext()) {
                object = (TemplateParameter)iterator2.next();
                ((TemplateParameter)object).setTemplateId(template.getId());
                ((TemplateParameter)object).setTemplateName(template.getName());
                templateParameterList.addParameter((TemplateParameter)object);
                if (hashMap == null) continue;
                hashMap.remove(((TemplateParameter)object).getParameterName());
            }
        }
        template.setTemplateParameters(templateParameterList);
        if (hashMap != null && hashMap.size() > 0) {
            object3 = new WCMFilter("", "TEMPLATEID=" + template.getId(), "");
            object2 = TemplateArguments.createNewInstance(User.getSystem());
            ((BaseObjs)object2).open((WCMFilter)object3);
            for (int i = ((BaseObjs)object2).size() - 1; i >= 0; --i) {
                object = (TemplateArgument)((BaseObjs)object2).getAt(i);
                if (object == null || hashMap.get(((TemplateArgument)object).getArgumentName()) == null) continue;
                ((CMSObj)object).delete();
            }
            ((BaseObjs)object2).clear();
        }
    }

    public Report checkTemplate(Template template) {
        return this.checkTemplate(template, true);
    }

    public Report checkTemplate(Template template, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (template.getId() > 0) {
            stringBuffer.append(template.getInfo());
        }
        String string = template.getName() + CMyString.showNull(template.getAttributeValue("tempId"));
        String string2 = "";
        String string3 = "";
        try {
            object2 = template.getFolder();
            if (object2 == null) {
                string2 = I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label3", "\u4e0d\u5b58\u5728");
            } else {
                object = WCMTypes.getLowerObjName(object2.getSubstance().getWCMType());
                string2 = I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label2", " \u5b58\u653e\u4f4d\u7f6e:") + (String)object;
                string3 = object2.getInfo();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = string2 + I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label4", " \u5b58\u653e\u4f4d\u7f6e\u83b7\u53d6\u5931\u8d25!");
        }
        if (template.getId() > 0 && bl) {
            string2 = string2 + "~Edit-" + template.getId() + "~";
        }
        object2 = new Report("");
        ((Report)object2).setRelateObject(template);
        object = this.checkLexical(template, (Report)object2);
        if (object == null) {
            ((Report)object2).setType(5);
            ((Report)object2).setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label5", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u6587\u6cd5\u9519\u8bef\uff01"), new Object[]{string, string2, string3}));
            return object2;
        }
        if (!this.checkGrammar((TagDocument)object, (Report)object2)) {
            ((Report)object2).setType(5);
            ((Report)object2).setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label6", "{0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01"), new Object[]{string, string2, string3}));
            return object2;
        }
        if (!this.checkSemantic(template, (TagDocument)object, (Report)object2)) {
            ((Report)object2).setType(5);
            ((Report)object2).setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label7", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u5b58\u5728\u8bed\u4e49\u9519\u8bef\uff01"), new Object[]{string, string2, string3}));
            return object2;
        }
        ((Report)object2).setRportTitle(CMyString.format(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label8", " {0}{1}, \u5f53\u524d\u7f16\u8f91\u7684\u6a21\u677f\u8bed\u6cd5\u6b63\u786e\uff01"), new Object[]{string, string2, string3}));
        return object2;
    }

    public TagDocument checkLexical(Template template, Report report) {
        try {
            return TagDocumentReader.read(template.getPubText());
        }
        catch (Throwable throwable) {
            report.setType(5);
            report.setRportDetail(throwable.getMessage());
            return null;
        }
    }

    public boolean checkGrammar(TagDocument tagDocument, Report report) {
        TagItem tagItem;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = tagDocument.findItems(null);
        while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
            this.checkTagItem(tagItem, stringBuffer);
        }
        if (stringBuffer.length() > 0) {
            report.setRportDetail(stringBuffer.toString());
            return false;
        }
        return true;
    }

    private void checkTagItem(TagItem tagItem, StringBuffer stringBuffer) {
        TagBeanInfo.BodyType bodyType;
        Object object;
        Object object2;
        Object object3;
        ITagParser iTagParser = null;
        if ("TRS_RECORD".equals(tagItem.getName())) {
            return;
        }
        try {
            iTagParser = TagParserFactory.createParserByName(tagItem.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iTagParser == null) {
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
            stringBuffer.append(tagItem.getDescWithPos());
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label10", "\u4e0d\u53ef\u8bc6\u522b\u7684"));
            stringBuffer.append("\n");
            return;
        }
        TagBeanInfo tagBeanInfo = null;
        try {
            tagBeanInfo = iTagParser.getBeanInfo();
        }
        catch (Throwable throwable) {
            this.logger.error((Object)(tagItem.getDescWithPos() + iTagParser.getClass().toString()), throwable);
        }
        if (tagBeanInfo == null) {
            return;
        }
        HashMap hashMap = tagItem.getAttributes();
        if (hashMap != null && (object3 = hashMap.keySet().iterator()) != null) {
            while (object3.hasNext()) {
                String string = (String)object3.next();
                if (DATEREL_ATTRS.contains(string.toUpperCase())) continue;
                object2 = tagItem.getAttribute(string);
                object = tagBeanInfo.getAttrInfo(string);
                if (object == null) {
                    stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                    stringBuffer.append(tagItem.getDescWithPos());
                    stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                    stringBuffer.append(string);
                    stringBuffer.append("=");
                    stringBuffer.append((String)object2);
                    stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label12", "]\u65e0\u6548\n"));
                    continue;
                }
                this.checkTagAttr(tagItem, (TagBeanAttrInfo)object, (String)object2, stringBuffer);
            }
        }
        if ((object3 = tagBeanInfo.getRequiredAttr()) != null && ((TagBeanAttrInfo[])object3).length > 0) {
            for (int i = ((Object)object3).length - 1; i >= 0; --i) {
                object2 = object3[i];
                object = tagItem.getAttribute(((TagBeanAttrInfo)object2).getName());
                if (object != null && ((String)object).length() != 0) continue;
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                stringBuffer.append(tagItem.getDescWithPos());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                stringBuffer.append(((TagBeanAttrInfo)object2).getDesc());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label13", "]\u662f\u5fc5\u987b\u7684\n"));
            }
        }
        if ((bodyType = tagBeanInfo.getType()) == TagBeanInfo.BodyType.ARGUMENT && tagItem.getText() == null) {
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
            stringBuffer.append(tagItem.getDescWithPos());
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label14", "\u7684\u53c2\u6570\u662f\u5fc5\u987b\u7684\n"));
        }
    }

    private void checkTagAttr(TagItem tagItem, TagBeanAttrInfo tagBeanAttrInfo, String string, StringBuffer stringBuffer) {
        String[] stringArray;
        TagBeanAttrInfo.Type type = tagBeanAttrInfo.getType();
        if (TagItem.isVariableParameter(string)) {
            if (!tagBeanAttrInfo.getVariable()) {
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                stringBuffer.append(tagItem.getDescWithPos());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                stringBuffer.append(tagBeanAttrInfo.getName());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label15", "]\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u53d8\u91cf:"));
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            return;
        }
        if (type == TagBeanAttrInfo.Type.INTEGER) {
            // empty if block
        }
        if ((stringArray = tagBeanAttrInfo.getEnumValue()) != null && stringArray.length > 0) {
            boolean bl = false;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label9", "\u7f6e\u6807"));
                stringBuffer.append(tagItem.getDescWithPos());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label11", "\u7684\u5c5e\u6027["));
                stringBuffer.append(tagBeanAttrInfo.getName());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label16", "]\u7684\u503c<"));
                stringBuffer.append(string);
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label17", ">\u5fc5\u987b\u5728\u5217\u8868"));
                stringBuffer.append(tagBeanAttrInfo.getEnumValueString());
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label18", "\u4e2d\n"));
            }
        }
    }

    private boolean checkSemantic(Template template, TagDocument tagDocument, Report report) {
        StringBuffer stringBuffer = new StringBuffer();
        IPublishFolder iPublishFolder = null;
        try {
            iPublishFolder = template.getRoot();
            if (iPublishFolder == null) {
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label19", "\u83b7\u53d6\u6a21\u677f["));
                stringBuffer.append(template);
                stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label20", "]\u7684\u6839\u76ee\u5f55\u5931\u8d25\n"));
            }
        }
        catch (Exception exception) {
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label19", "\u83b7\u53d6\u6a21\u677f["));
            stringBuffer.append(template);
            stringBuffer.append(I18NMessage.get(TemplateParseMgr.class, "TemplateParseMgr.label21", "]\u7684\u6839\u76ee\u5f55\u51fa\u9519:"));
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\n");
        }
        if (iPublishFolder != null) {
            TagItem tagItem;
            Iterator iterator = tagDocument.findItems(null);
            while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
                TagBeanInfo tagBeanInfo = this.getTagBeanInfo(tagItem);
                if (tagBeanInfo == null) continue;
                tagBeanInfo.checkSemantic(iPublishFolder, tagItem, stringBuffer, template.getName());
            }
        }
        if (stringBuffer.length() > 0) {
            report.setRportDetail(stringBuffer.toString());
            return false;
        }
        return true;
    }

    private TagBeanInfo getTagBeanInfo(TagItem tagItem) {
        ITagParser iTagParser = null;
        if ("TRS_RECORD".equals(tagItem.getName())) {
            return null;
        }
        try {
            iTagParser = TagParserFactory.createParserByName(tagItem.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iTagParser == null) {
            return null;
        }
        try {
            return iTagParser.getBeanInfo();
        }
        catch (Throwable throwable) {
            this.logger.error((Object)(tagItem.getDescWithPos() + iTagParser.getClass().toString()), throwable);
            return null;
        }
    }

    private boolean isListening(BaseObj baseObj) {
        return baseObj != null && baseObj.getWCMType() == 102;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (this.isListening(baseObj)) {
            this.parseForCluster((Template)baseObj);
        }
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj)) {
            this.removeCache((Template)baseObj);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (this.isListening(baseObj)) {
            this.removeCache((Template)baseObj);
            Hashtable hashtable = baseObj.getProperties();
            Hashtable hashtable2 = new Hashtable(hashtable.size());
            hashtable2.putAll(hashtable);
            hashtable.putAll(baseObj.getNewProperties());
            this.parseForCluster((Template)baseObj);
            hashtable.clear();
            hashtable.putAll(hashtable2);
            hashtable2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForCluster(Template template) throws WCMException {
        try {
            Integer n = new Integer(template.getId());
            TagDocument tagDocument = (TagDocument)this.m_cache.get((Object)n);
            if (tagDocument != null) {
                return;
            }
            Template template2 = template;
            synchronized (template2) {
                TagItem tagItem;
                tagDocument = (TagDocument)this.m_cache.get((Object)n);
                if (tagDocument != null) {
                    return;
                }
                String string = template.getPubText();
                try {
                    tagDocument = TagDocumentReader.read(string);
                }
                catch (Exception exception) {
                    this.logger.error((Object)("Failed to read DOM of the template [" + template.getId() + "]"), (Throwable)exception);
                    throw new WCMException(220, "Failed to read DOM of the template [" + template.getId() + "](" + template.getName() + ")", exception);
                }
                TemplateParameterList templateParameterList = new TemplateParameterList();
                Iterator iterator = tagDocument.findItems(null);
                while (iterator.hasNext() && (tagItem = (TagItem)iterator.next()) != null) {
                    Iterator iterator2;
                    HashMap hashMap = tagItem.getVariableParameters();
                    if (hashMap == null || (iterator2 = hashMap.values().iterator()) == null) continue;
                    while (iterator2.hasNext()) {
                        TemplateParameter templateParameter = (TemplateParameter)iterator2.next();
                        templateParameter.setTemplateId(template.getId());
                        templateParameter.setTemplateName(template.getName());
                        templateParameterList.addParameter(templateParameter);
                    }
                }
                template.setTemplateParameters(templateParameterList);
                this.m_cache.put((Object)n, (Object)tagDocument);
            }
        }
        catch (Exception exception) {
            WCMException wCMException = null;
            wCMException = exception instanceof WCMException ? (WCMException)exception : new WCMException(1100, "\u89e3\u91ca\u6a21\u677f\u5931\u8d25", exception);
            throw wCMException;
        }
    }
}

