/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import org.apache.log4j.Logger;

public class TemplateParseAngel
extends Thread {
    private static final Logger logger = Logger.getLogger((String)TemplateParseAngel.class.getName());
    private Object m_host;

    private TemplateParseAngel(Object object) {
        this.m_host = object;
    }

    public static void scanAll() {
        TemplateParseAngel templateParseAngel = new TemplateParseAngel((Object)null);
        templateParseAngel.start();
    }

    public static void scanIn(IPublishFolder iPublishFolder) {
        TemplateParseAngel templateParseAngel = new TemplateParseAngel(iPublishFolder);
        templateParseAngel.start();
    }

    public static void scan(Template template) {
        if (template == null || template.isParsed()) {
            return;
        }
        TemplateParseAngel templateParseAngel = new TemplateParseAngel(template);
        templateParseAngel.start();
    }

    public void run() {
        ContextHelper.initContext(User.getSystem());
        if (this.m_host == null) {
            this.parseAllUnparsedTemplates();
        } else if (this.m_host instanceof Template) {
            this.parseTemplate((Template)this.m_host, null);
        } else {
            this.parseUnparsedTemplatesIn((IPublishFolder)this.m_host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseAllUnparsedTemplates() {
        BaseObjs baseObjs = null;
        try {
            block4: {
                try {
                    WCMFilter wCMFilter = new WCMFilter("", "ISPARSED=0", "");
                    baseObjs = new Templates(ContextHelper.getLoginUser());
                    baseObjs.open(wCMFilter);
                    if (baseObjs == null || baseObjs.isEmpty()) break block4;
                    this.parseTemplates((Templates)baseObjs);
                }
                catch (Exception exception) {
                    logger.error((Object)I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label1", "\u89e3\u6790\u5c1a\u672a\u89e3\u6790\u7684\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)exception);
                    Object var4_5 = null;
                    if (baseObjs == null) return;
                    baseObjs.clear();
                    return;
                }
            }
            Object var4_4 = null;
            if (baseObjs == null) return;
            baseObjs.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (baseObjs == null) throw throwable;
            baseObjs.clear();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseUnparsedTemplatesIn(IPublishFolder iPublishFolder) {
        BaseObjs baseObjs = null;
        try {
            block4: {
                try {
                    TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
                    WCMFilter wCMFilter = new WCMFilter("", "ISPARSED=0", "");
                    baseObjs = templateMgr.getManagedTemplates(iPublishFolder, -1, wCMFilter, true);
                    if (baseObjs == null || baseObjs.isEmpty()) break block4;
                    this.parseTemplates((Templates)baseObjs);
                }
                catch (Exception exception) {
                    logger.error((Object)(I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label2", "\u89e3\u6790") + iPublishFolder.getInfo() + I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label3", "\u5c1a\u672a\u89e3\u6790\u7684\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)exception);
                    Object var6_7 = null;
                    if (baseObjs == null) return;
                    baseObjs.clear();
                    return;
                }
            }
            Object var6_6 = null;
            if (baseObjs == null) return;
            baseObjs.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (baseObjs == null) throw throwable;
            baseObjs.clear();
            throw throwable;
        }
    }

    private void parseTemplates(Templates templates) {
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) continue;
            this.parseTemplate(template, templateParseMgr);
        }
    }

    private void parseTemplate(Template template, TemplateParseMgr templateParseMgr) {
        try {
            if (template.isParsed()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("to parse " + template.getInfo()));
            }
            if (templateParseMgr == null) {
                templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            }
            templateParseMgr.parse(template);
        }
        catch (Exception exception) {
            logger.error((Object)(I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label2", "\u89e3\u6790") + template.getInfo() + I18NMessage.get(TemplateParseAngel.class, "TemplateParseAngel.label4", "\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)exception);
            String string = CMyException.getStackTraceText(exception);
            this.notifyWhenFailed(template, string);
        }
    }

    private void notifyWhenFailed(Template template, String string) {
        try {
            if (NotificationServer.getInstance().needNotifyForEvent("Publish.WhenTempateParseAngelFailed")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"to send notification on event Publish.WhenTempateParseAngelFailed");
                }
                Notifier notifier = new Notifier();
                notifier.setParameter("TemplateInfo", template.getInfo());
                notifier.setParameter("Message", string);
                notifier.executeOnEvent("Publish.WhenTempateParseAngelFailed");
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to notify when parsing " + template.getInfo() + " failed!"), (Throwable)exception);
        }
    }
}

