/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TemplateNestMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateNestMgr.class.getName());

    public boolean addNestRecord(int n, IPublishFolder iPublishFolder, String string) throws WCMException {
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(iPublishFolder, string);
        if (template == null) {
            throw new WCMException(10, "Template [" + string + "] is not found!");
        }
        return this.addNestRecord(n, template.getId());
    }

    public boolean addNestRecord(int n, int n2) throws WCMException {
        if (this.isExistsNestRecord(n, n2)) {
            return true;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO WCMTEMPLATENEST(TEMPLATEID, NESTEDTEMPLATEID) values(?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            boolean bl = preparedStatement.executeUpdate() > 0;
            return bl;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to add template nest record!", exception);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    private boolean isExistsNestRecord(int n, int n2) throws WCMException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("select NESTEDTEMPLATEID from WCMTEMPLATENEST where TEMPLATEID=? and NESTEDTEMPLATEID=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to add template nest record!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close resultSet", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public int clearNestRecordsOf(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Connection connection = null;
        Statement statement = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            String string = "DELETE FROM WCMTEMPLATENEST WHERE TEMPLATEID=?";
            connection = dBManager.getConnection();
            statement = connection.prepareStatement(string);
            statement.setInt(1, template.getId());
            int n = statement.executeUpdate();
            return n;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to clear template nest record!", exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public Templates getNestedTemplates(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Templates templates = null;
        try {
            String string = "TEMPLATEID=?";
            WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATENEST", string, "", "NESTEDTEMPLATEID AS TEMPID");
            wCMFilter.addSearchValues(0, template.getId());
            templates = new Templates(ContextHelper.getLoginUser());
            templates.open(wCMFilter);
            return templates;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to lookup the nested template!", exception);
        }
    }

    public Templates getTemplatesNested(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Templates templates = null;
        try {
            String string = "NESTEDTEMPLATEID=?";
            WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATENEST", string, "", "TEMPLATEID AS TEMPID");
            wCMFilter.addSearchValues(0, template.getId());
            templates = new Templates(ContextHelper.getLoginUser());
            templates.open(wCMFilter);
            return templates;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to lookup the template nested!", exception);
        }
    }
}

