/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.domain.template.UnZipFile4Template;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.WidgetInstParameter;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.components.wcm.content.service.portervisitors.PorterUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateImporter {
    private static final Logger m_oLogger = Logger.getLogger((String)TemplateImporter.class.getName());
    private Reports m_importReports;
    private static XmlToObjConverter m_converter = new XmlToObjConverter(2);
    private XmlObject[] m_XmlObjTemplates;

    public String[] extractTemplateNamesFromZip(String string) throws WCMException {
        String[] stringArray;
        if (string.indexOf(".") < 0) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label1", "\u4e0d\u662fzip\u6587\u4ef6\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        if (!string.substring(string.lastIndexOf(".") + 1).toUpperCase().equals("ZIP")) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label1", "\u4e0d\u662fzip\u6587\u4ef6\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        String string2 = this.getFullName(string);
        String string3 = CMyFile.extractFilePath(string2);
        string3 = string3 + "unziptemplate" + System.currentTimeMillis();
        CMyUnzip cMyUnzip = new CMyUnzip();
        try {
            cMyUnzip.setZipFile(string2);
            cMyUnzip.unzip(string3, true);
        }
        catch (Exception exception) {
            throw new WCMException(54, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label2", "\u65e0\u6cd5\u6b63\u786e\u89e3\u538b\u7f29\u6587\u4ef6\uff01"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = null;
        try {
            enumeration = cMyUnzip.getItems();
        }
        catch (Exception exception) {
            throw new WCMException(54, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label3", "\u65e0\u6cd5\u6b63\u786e\u8bfb\u53d6\u89e3\u538b\u7f29\u540e\u7684\u6587\u4ef6\uff01"));
        }
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (stringArray == null) continue;
            String string4 = stringArray.getName();
            if (File.separator != "/") {
                string4 = CMyString.replaceStr(string4, "/", File.separator);
            }
            String string5 = string3 + string4;
            String string6 = CMyFile.extractFileExt(string5);
            String string7 = CMyFile.extractFileName(string5);
            if (!this.isSupportedTemplateExt(string6)) continue;
            arrayList.add(string7.substring(0, string7.lastIndexOf(".")));
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public Reports importFromZip(IPublishFolder iPublishFolder, String string, int n, int n2, String[] stringArray) throws WCMException {
        return this.importFromZipFile(iPublishFolder, string, n, n2, stringArray, null);
    }

    public Reports importFromZip(IPublishFolder iPublishFolder, String string, int n, int n2, String[] stringArray, Templates templates) throws WCMException {
        return this.importFromZipFile(iPublishFolder, string, n, n2, stringArray, templates);
    }

    private Reports importFromZipFile(IPublishFolder iPublishFolder, String string, int n, int n2, String[] stringArray, Templates templates) throws WCMException {
        Object object;
        Object object22;
        this.assertNotNullParam(iPublishFolder, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label4", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u7684\u5bfc\u5165!"));
        this.assertNotNullParam(string, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label5", "\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u7684\u6e90zip\u6587\u4ef6,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u5bfc\u5165!"));
        this.assertZipFile(string);
        String string2 = this.getFullName(string);
        String string3 = CMyFile.extractFilePath(string2) + "unzip" + CMyFile.extractFileName(string) + File.separator;
        HashMap hashMap = new HashMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Hashtable hashtable = this.unzip(string2, string3);
        Map map = this.getExportInfo(hashtable);
        for (Object object22 : hashtable.keySet()) {
            if ("Thumbs.db".equals(CMyFile.extractFileName((String)object22, null))) continue;
            object = CMyFile.extractFileExt((String)object22);
            if (this.isSupportedTemplateExt((String)object)) {
                arrayList.add(object22);
                continue;
            }
            if (this.isSupportedAppendixExt((String)object)) {
                hashMap.put(CMyFile.extractFileName((String)object22).toLowerCase(), hashtable.get(object22));
                continue;
            }
            if (this.isTempFileSelected(CMyFile.extractFileName((String)object22), stringArray)) {
                arrayList.add(object22);
                continue;
            }
            m_oLogger.warn((Object)("unsupport file for template[" + CMyFile.extractFileName((String)object22) + "]!"));
        }
        this.m_importReports = new Reports("");
        object22 = new ArrayList(5);
        object = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string4 = (String)arrayList.get(i);
            if (string4 == null) continue;
            String string5 = CMyFile.extractFileName(string4);
            String string6 = "";
            if (string5.indexOf(".") != -1) {
                string6 = string5.substring(string5.lastIndexOf(".") + 1, string5.length());
                string5 = string5.substring(0, string5.lastIndexOf("."));
            }
            Template template = null;
            try {
                string4 = (String)hashtable.get(string4);
                template = this.createTemplateWithFile(iPublishFolder, string4, n, string5);
                if (template == null) continue;
                if (templates != null && templates.indexOf(template) > -1) {
                    this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label8", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Template[]{template}), new WCMException(1002, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label39", "\u6ca1\u6709\u8986\u76d6\u8be5\u6a21\u677f\u7684\u6743\u9650")));
                    continue;
                }
                if (map != null) {
                    Template template2 = (Template)map.get(string5);
                    if (template2 == null) {
                        throw new WCMException("\u5728\u6e90zip\u6587\u4ef6\u4e2d\u7684\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\u3010TemplateTypeInfos.xml\u3011\u4e2d\u6ca1\u6709\u627e\u5230\u6a21\u677f\u540d\u79f0\u4e3a\u3010" + string5 + "\u3011\u7684\u914d\u7f6e\u4fe1\u606f\uff01\u8bf7\u786e\u4fddzip\u6587\u4ef6\u4e2d\u7684\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\u91cc\u5305\u542b\u5bf9\u5e94\u7684\u6a21\u677f\u540d\u79f0\u914d\u7f6e\u540e\u91cd\u65b0\u6267\u884c\u5bfc\u5165\uff01");
                    }
                    template.setProperty("TempType", template2.getType());
                    template.setProperty("Visual", template2.getPropertyAsBoolean("Visual", false));
                    if (!CMyString.isEmpty(template2.getOutputFileName())) {
                        template.setOutputFileName(template2.getOutputFileName());
                    }
                    template.setDesc(CMyString.showEmpty(template2.getDesc()));
                }
                template.setProperty("TempExt", string6);
                PorterUtil.doImports(template, null, this.m_XmlObjTemplates);
                this.getTemplateMgr().save(template, hashMap, true, n2, false);
                object.add(template);
                this.m_importReports.addSucessedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label7", "\u5bfc\u5165[{0}]\u6210\u529f!"), new Template[]{template}));
                ((ArrayList)object22).add(new Integer(template.getId()));
                continue;
            }
            catch (Throwable throwable) {
                this.m_importReports.addFailedReport(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label8", "\u5bfc\u5165[{0}]\u5931\u8d25!"), new Template[]{template}), throwable);
            }
        }
        if (object.size() > 0) {
            TemplateParseMgr templateParseMgr = this.getTemplateParseMgr();
            for (int i = 0; i < object.size(); ++i) {
                try {
                    templateParseMgr.notifyTemplateModified((Template)object.get(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.m_importReports.setTitle(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label10", "\u6210\u529f\u5bfc\u5165{0}\u4e2a,\u5bfc\u5165\u5931\u8d25{1}\u4e2a!"), new int[]{this.m_importReports.getSucessedReporter().size(), this.m_importReports.getFailedReporter().size()}));
        this.m_importReports.setExtraData((ArrayList)object22);
        CMyFile.deleteFile(string);
        CMyFile.deleteDir(string3);
        return this.m_importReports;
    }

    private void assertZipFile(String string) throws WCMException {
        String string2 = "zip";
        String string3 = CMyFile.extractFileExt(string);
        if (!string2.equalsIgnoreCase(string3)) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label12", "\u4e0d\u662f\u4e00\u4e2aZip\u6587\u4ef6,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u5165!"));
        }
    }

    private Hashtable unzip(String string, String string2) throws WCMException {
        UnZipFile4Template unZipFile4Template = new UnZipFile4Template(string, string2);
        try {
            unZipFile4Template.setFileNameEncoding("GBK");
            ((CMyUnZipFile)unZipFile4Template).doUnZipAnd();
        }
        catch (CMyException cMyException) {
            m_oLogger.debug((Object)"failed to unzip the file", (Throwable)cMyException);
            throw new WCMException(200, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label13", "\u89e3\u538b\u6587\u4ef6\u5931\u8d25\uff01"), cMyException);
        }
        return ((CMyUnZipFile)unZipFile4Template).getAllFileNameIndex();
    }

    private String getFullName(String string) throws WCMException {
        String string2 = string;
        if (!CMyFile.fileExists(string)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            string2 = filesMan.mapFilePath(string, 0) + string;
        }
        return string2;
    }

    private Map getExportInfo(Hashtable hashtable) throws WCMException {
        String string = (String)hashtable.remove("TemplateTypeInfos.xml");
        if (string == null) {
            return null;
        }
        XmlObject[] xmlObjectArray = this.m_XmlObjTemplates = m_converter.convertXml(string, null, null);
        HashMap<String, Template> hashMap = new HashMap<String, Template>(xmlObjectArray.length);
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            Template template = (Template)xmlObjectArray[i].getCurrentObj();
            hashMap.put(template.getName(), template);
        }
        return hashMap;
    }

    public Reports importFromHTML(IPublishFolder iPublishFolder, String string, int n, String string2) throws WCMException {
        this.assertNotNullParam(iPublishFolder, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label14", "\u65e0\u6548\u7684\u7ad9\u70b9/\u9891\u9053\u5bf9\u8c61,\u65e0\u6cd5\u5b8c\u6210\u6a21\u677f\u5bfc\u5165!"));
        this.assertNotNullParam(string, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label15", "\u6ca1\u6709\u6307\u5b9a\u8981\u5bfc\u5165\u7684\u6a21\u677f\u6587\u4ef6,\u65e0\u6cd5\u5bfc\u5165!"));
        this.assertNotNullParam(string2, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label16", "\u65e0\u6548\u7684\u6a21\u677f\u6587\u4ef6\u540d!"));
        this.assertUnSuppportTemplateExt(string);
        String string3 = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label17", "\u5bfc\u5165\u6a21\u677f [") + string2 + "] ";
        this.m_importReports = new Reports(string3);
        try {
            String string4 = string2.substring(0, string2.lastIndexOf("."));
            String string5 = this.getFullName(string);
            Template template = this.createTemplateWithFile(iPublishFolder, string5, n, string4);
            if (template == null) {
                return this.m_importReports;
            }
            int n2 = string.lastIndexOf(".");
            template.setProperty("TempExt", string.substring(n2 + 1));
            this.getTemplateMgr().save(template, "", true, 2);
            this.m_importReports.addSucessedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label18", "\u5bfc\u5165\u6210\u529f!"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(template.getId()));
            this.m_importReports.setExtraData(arrayList);
        }
        catch (Throwable throwable) {
            m_oLogger.debug((Object)"failed to import template from html file:", throwable);
            this.m_importReports.addFailedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label19", "\u5bfc\u5165\u5931\u8d25!"), throwable);
        }
        return this.m_importReports;
    }

    private TemplateMgr getTemplateMgr() {
        TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        return templateMgr;
    }

    private TemplateParseMgr getTemplateParseMgr() {
        TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
        return templateParseMgr;
    }

    private void assertUnSuppportTemplateExt(String string) throws WCMException {
        String string2 = CMyFile.extractFileExt(string);
        if (!this.isSupportedTemplateExt(string2)) {
            throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label20", "\u5728\u652f\u6301\u7684\u6a21\u677f\u6587\u4ef6") + string);
        }
    }

    private Template createTemplateWithFile(IPublishFolder iPublishFolder, String string, int n, String string2) throws WCMException {
        Object object;
        String string3 = this.getFileContent(string);
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        Template template = this.getTemplateCacheMgr().lookupByName(iPublishFolder2, string2);
        if (template != null) {
            object = template.getFolder();
            if (object == null) {
                template.delete(ContextHelper.getLoginUser());
                template = null;
            } else if (object.isDeleted()) {
                throw new WCMException(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label21", "\u540c\u540d\u6a21\u677f[TempName=") + string2 + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label22", "]\u6240\u5c5e\u680f\u76ee[") + object + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label23", "]\u88ab\u5220\u9664\u5230\u56de\u6536\u7ad9\u4e2d\uff0c\u6b64\u6a21\u677f\u4e0d\u80fd\u88ab\u5bfc\u5165\uff01"));
            }
        }
        if (template != null) {
            object = this.processTemplateName(string2, iPublishFolder, n);
            if (object == null) {
                return null;
            }
            template = ((String)object).equals(template.getName()) ? this.updateTemplate(template, string3) : this.createTemplate(iPublishFolder, (String)object, string3, iPublishFolder2);
        } else {
            template = this.createTemplate(iPublishFolder, string2, string3, iPublishFolder2);
        }
        return template;
    }

    private TemplateCacheMgr getTemplateCacheMgr() {
        return (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
    }

    private Template updateTemplate(Template template, String string) throws WCMException {
        template.canEdit(ContextHelper.getLoginUser());
        template.setText(string);
        return template;
    }

    private Template createTemplate(IPublishFolder iPublishFolder, String string, String string2, IPublishFolder iPublishFolder2) throws WCMException {
        Template template = Template.createNewInstance();
        template.setText(string2);
        template.setFolder(iPublishFolder, iPublishFolder2);
        template.setName(string);
        template.setType(Template.guessTypeByName(string));
        return template;
    }

    private String getFileContent(String string) throws WCMException {
        String string2 = "";
        if (CMyFile.fileExists(string)) {
            try {
                String string3 = CharsetDetector.detect(string);
                string2 = CMyFile.readFile(string, string3);
            }
            catch (CMyException cMyException) {
                throw new WCMException(cMyException.getErrNo(), cMyException.getMyMessage(), cMyException.getRootCause());
            }
        }
        return string2;
    }

    private String processTemplateName(String string, IPublishFolder iPublishFolder, int n) throws WCMException {
        switch (n) {
            case 1: {
                return string;
            }
            case 3: {
                return this.getNewName(string, iPublishFolder.getRoot());
            }
            case 2: {
                return null;
            }
            case 4: {
                String string2 = null;
                if (iPublishFolder.getType() == 103) {
                    string2 = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label37", "\u7ad9\u70b9");
                } else if (iPublishFolder.getType() == 101) {
                    string2 = I18NMessage.get(TemplateImporter.class, "TemplateImporter.label38", "\u680f\u76ee");
                }
                WCMException wCMException = new WCMException(CMyString.format(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label24", "\u5728{0}["), new String[]{string2}) + iPublishFolder.getInfo() + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label25", "]\u4e2d\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + string + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label26", "]\u7684\u6a21\u677f!"));
                this.m_importReports.addFailedReport(I18NMessage.get(TemplateImporter.class, "TemplateImporter.label27", "\u6a21\u677f[") + string + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label28", "]\u5df2\u5b58\u5728!"), wCMException);
                return null;
            }
        }
        throw new WCMException(10, I18NMessage.get(TemplateImporter.class, "TemplateImporter.label29", "\u65e0\u6548\u7684\u540c\u540d\u5904\u7406\u6a21\u5f0f[") + n + I18NMessage.get(TemplateImporter.class, "TemplateImporter.label30", "],\u6709\u6548\u503c\u4e3a(1,2,3,4)!"));
    }

    private String getNewName(String string, IPublishFolder iPublishFolder) throws WCMException {
        String string2 = string;
        int n = 1;
        TemplateCacheMgr templateCacheMgr = this.getTemplateCacheMgr();
        while (templateCacheMgr.lookupByName(iPublishFolder, string2) != null) {
            string2 = string + "_" + n;
            ++n;
        }
        return string2;
    }

    private boolean isSupportedTemplateExt(String string) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(TemplateImporter.class, "TemplateImporter.label31", "\u5f00\u59cb\u8bc6\u522b\u6a21\u677f\u540e\u7f00"));
        String[] stringArray = PublishServerConfigMapper.getTemplateSupportedExts();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedAppendixExt(String string) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(TemplateImporter.class, "TemplateImporter.label32", "\u5f00\u59cb\u8bc6\u522b\u6a21\u677f\u9644\u4ef6\u540e\u7f00"));
        String[] stringArray = PublishServerConfigMapper.getTemplateSupportedApdExts();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isTempFileSelected(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void assertNotNullParam(Object object, String string) throws WCMException {
        if (object == null) {
            throw new WCMException(10, string);
        }
    }

    public static final String[] getSupportedTemplateFileExt() throws WCMException {
        String[] stringArray = PublishServerConfigMapper.getTemplateSupportedExts();
        if (stringArray != null) {
            return stringArray;
        }
        return new String[0];
    }

    static {
        m_converter.registPersistentObj("WCMTEMPLATE", Template.class);
        m_converter.registPersistentObj("XWCMWIDGETINSTANCE", WidgetInstance.class);
        m_converter.registPersistentObj("XWCMWIDGETINSTPARAMETER", WidgetInstParameter.class);
    }
}

