/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.TempAppendixes;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateXmlConverter;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.PinyinHelper;
import java.io.File;

public class TemplateExporter {
    private String m_sTempApdName = "";
    private static ObjToXmlConverter m_converter = new ObjToXmlConverter();
    public static final String TEMPLATETYPEINFOS_XMLFILE = "TemplateTypeInfos.xml";

    public String exportToXMLFile(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label1", "\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        TemplateXmlConverter templateXmlConverter = new TemplateXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "xml", null, true);
        templateXmlConverter.toXMLFile(template, string);
        return CMyFile.extractFileName(string);
    }

    public String exportToXMLFile(Templates templates) throws WCMException {
        if (templates == null) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label2", "\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff01"));
        }
        TemplateXmlConverter templateXmlConverter = new TemplateXmlConverter();
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFileName("ST", "xml", null, true);
        templateXmlConverter.toXMLFile(templates, string);
        return CMyFile.extractFileName(string);
    }

    public String export(Templates templates) throws WCMException {
        if (templates == null || templates.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label3", "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u51fa!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFilePathName("ST", "zip");
        CMyZip cMyZip = new CMyZip();
        try {
            cMyZip.setEncoding("GBK");
            cMyZip.setZipFileName(string);
            Template template = null;
            for (int i = 0; i < templates.size(); ++i) {
                template = (Template)templates.getAt(i);
                this.export(template, cMyZip);
            }
            this.exportTypeInfos(templates, cMyZip);
            cMyZip.done();
            this.m_sTempApdName = "";
        }
        catch (CMyException cMyException) {
            try {
                filesMan.deleteFile(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WCMException(1100, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label4", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u538b\u7f29\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), cMyException);
        }
        return CMyFile.extractFileName(string);
    }

    private void export(Template template, CMyZip cMyZip) throws WCMException, CMyException {
        String string = template.getTextWithImgFilter("../site" + template.getRootId() + "/", true, false);
        String string2 = template.getOutputFileExt();
        string2 = string2 != null && string2.length() > 0 ? "." + string2 : "";
        String string3 = "temp" + File.separator + PinyinHelper.convert(template.getName()) + string2;
        try {
            CMyFile.writeFile(string3, string, template.getCharSet());
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(TemplateExporter.class, "TemplateExporter.label5", "\u6839\u636e\u6a21\u677f\u7684\u5185\u5bb9\u521b\u5efa\u76f8\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), cMyException);
        }
        cMyZip.addToZip(string3, template.getName());
        CMyFile.deleteFile(string3);
        TempAppendixes tempAppendixes = template.getAppendixes(ContextHelper.getLoginUser());
        String string4 = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
        String string5 = "";
        for (int i = 0; i < tempAppendixes.size(); ++i) {
            TempAppendix tempAppendix = (TempAppendix)tempAppendixes.getAt(i);
            if (tempAppendix == null || this.m_sTempApdName.indexOf((string5 = tempAppendix.getFile()) + "*") != -1 || !CMyFile.fileExists(string3 = string4 + string5)) continue;
            cMyZip.addToZip(string3);
            this.m_sTempApdName = this.m_sTempApdName + string5 + "*";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTypeInfos(Templates templates, CMyZip cMyZip) throws CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFilePathName("ST", ".xml");
        String string2 = CMyFile.extractFilePath(string) + "temp" + System.currentTimeMillis() + File.separator + TEMPLATETYPEINFOS_XMLFILE;
        try {
            m_converter.toXMLFile(templates, string, null, "TempName,TempType,TempExt,OutputFileName,Visual,TempDesc");
            CMyFile.copyFile(string, string2, true);
            cMyZip.addToZip(string2, false);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            CMyFile.deleteFile(string);
            CMyFile.deleteDir(CMyFile.extractFilePath(string2));
            throw throwable;
        }
        CMyFile.deleteFile(string);
        CMyFile.deleteDir(CMyFile.extractFilePath(string2));
    }
}

