/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.TemplateEmploys;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateEmployMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateEmployMgr.class.getName());
    private ITemplateEmployCacheMgr m_oCacheMgr = (ITemplateEmployCacheMgr)DreamFactory.createObjectById("ITemplateEmployCacheMgr");

    public TemplateEmploys getEmploysOf(IPublishElement iPublishElement, int n) throws WCMException {
        if (iPublishElement == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getEmploysOfEmployer(iPublishElement.getType(), iPublishElement.getId(), n);
    }

    public TemplateEmploys getEmploysOf(IPublishElement iPublishElement) throws WCMException {
        return this.getEmploysOf(iPublishElement, -1);
    }

    public TemplateEmploys getEmploysOfEmployer(int n, int n2, int n3) throws WCMException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EMPLOYERID=").append(n2);
            stringBuffer.append(" AND EMPLOYERTYPE=").append(n);
            if (n3 != -1) {
                stringBuffer.append(" AND TEMPLATETYPE=").append(n3);
            }
            WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "ISDEFAULT DESC");
            stringBuffer.setLength(0);
            TemplateEmploys templateEmploys = new TemplateEmploys(ContextHelper.getLoginUser());
            templateEmploys.open(wCMFilter);
            return templateEmploys;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", exception);
        }
    }

    private TemplateEmploy getDefaultEmployOfEmployer(int n, int n2, int n3) throws WCMException {
        try {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("EMPLOYERID=?");
            stringBuffer.append(" AND EMPLOYERTYPE=?");
            stringBuffer.append(" AND TEMPLATETYPE=?");
            stringBuffer.append(" AND ISDEFAULT=1");
            WCMFilter wCMFilter = new WCMFilter("", stringBuffer.toString(), "");
            wCMFilter.addSearchValues(n2);
            wCMFilter.addSearchValues(n);
            wCMFilter.addSearchValues(n3);
            wCMFilter.setMaxRowNumber(1);
            stringBuffer.setLength(0);
            TemplateEmploys templateEmploys = new TemplateEmploys(ContextHelper.getLoginUser());
            templateEmploys.open(wCMFilter);
            if (templateEmploys.isEmpty()) {
                return null;
            }
            return (TemplateEmploy)templateEmploys.getAt(0);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", exception);
        }
    }

    public TemplateEmploys getEmploysOfEmployer(int n, int n2) throws WCMException {
        return this.getEmploysOfEmployer(n, n2, -1);
    }

    private Templates getTemplates(IPublishElement iPublishElement, int n) throws WCMException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EMPLOYERID=").append(iPublishElement.getId());
            stringBuffer.append(" AND EMPLOYERTYPE=").append(iPublishElement.getType());
            if (n != -1) {
                stringBuffer.append(" AND TEMPLATETYPE=" + n);
            }
            WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATEEMPLOY", stringBuffer.toString(), "ISDEFAULT DESC", "TEMPLATEID AS TEMPID");
            stringBuffer.setLength(0);
            Templates templates = new Templates(ContextHelper.getLoginUser());
            templates.open(wCMFilter);
            return templates;
        }
        catch (Exception exception) {
            String string = "Failed to fetch the employed templates of the specified employer.";
            logger.fatal((Object)string, (Throwable)exception);
            throw new WCMException(1100, string, exception);
        }
    }

    public Templates getOutlineTemplates(IPublishFolder iPublishFolder) throws WCMException {
        return this.m_oCacheMgr.getOutlineTemplates(iPublishFolder);
    }

    public Templates getOtherOutlineTemplates(IPublishFolder iPublishFolder) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EMPLOYERID=").append(iPublishFolder.getId());
        stringBuffer.append(" AND EMPLOYERTYPE=").append(iPublishFolder.getType());
        stringBuffer.append(" AND TEMPLATETYPE=");
        stringBuffer.append(1).append(" AND ");
        stringBuffer.append("ISDEFAULT=").append(0);
        WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATEEMPLOY", stringBuffer.toString(), "", "TEMPLATEID AS TEMPID");
        stringBuffer.setLength(0);
        Templates templates = new Templates(ContextHelper.getLoginUser());
        templates.open(wCMFilter);
        return templates;
    }

    public Template getDefaultOutlineTemplate(IPublishFolder iPublishFolder) throws WCMException {
        return this.m_oCacheMgr.getDefaultOutlineTemplate(iPublishFolder);
    }

    public Template getDetailTemplate(IPublishElement iPublishElement) throws WCMException {
        return this.m_oCacheMgr.getDetailTemplate(iPublishElement);
    }

    public Template getDetailTemplate(int n, int n2) throws WCMException {
        return this.m_oCacheMgr.getDetailTemplate(n, n2);
    }

    public Template getDetailTemplate(IPublishElement iPublishElement, int n) throws WCMException {
        if (n == 2) {
            return this.m_oCacheMgr.getDetailTemplate(iPublishElement);
        }
        return this.getDefaultTemplate(iPublishElement, n);
    }

    private Template getDefaultTemplate(IPublishElement iPublishElement, int n) throws WCMException {
        BaseObjs baseObjs = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EMPLOYERID=").append(iPublishElement.getId());
            stringBuffer.append(" AND EMPLOYERTYPE=").append(iPublishElement.getType());
            stringBuffer.append(" AND TEMPLATETYPE=").append(n);
            stringBuffer.append(" AND ISDEFAULT=1");
            WCMFilter wCMFilter = new WCMFilter("WCMTEMPLATEEMPLOY", stringBuffer.toString(), null, "TEMPLATEID AS TEMPID");
            wCMFilter.setMaxRowNumber(1);
            stringBuffer.setLength(0);
            baseObjs = Templates.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
            if (baseObjs.isEmpty()) {
                Template template = null;
                return template;
            }
            Template template = (Template)baseObjs.getAt(0);
            return template;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the default employed template of the specified employer.", exception);
        }
        finally {
            if (baseObjs != null) {
                baseObjs.clear();
            }
        }
    }

    public void setOutlineTemplates(IPublishFolder iPublishFolder, String string, boolean bl) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, "Template id list required!");
        }
        User user = ContextHelper.getLoginUser();
        try {
            int[] nArray = CMyString.splitToInt(string, ",");
            if (nArray.length < 1) {
                throw new WCMDatainvalidException(I18NMessage.get(TemplateEmployMgr.class, "TemplateEmployMgr.label1", "\u4f20\u5165\u7684\u6982\u89c8\u6a21\u677f\u5e8f\u5217\u6709\u8bef!"));
            }
            this.setDefaultOutline(iPublishFolder, nArray[0]);
            this.deleteUnuseEmploys(user, iPublishFolder, nArray);
            this.dowthNewOtherOutlineEmploys(user, iPublishFolder, nArray);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to set the folder outline templates!", exception);
        }
        if (bl) {
            this.resetChildern(iPublishFolder, string, true);
        }
    }

    private void dowthNewOtherOutlineEmploys(User user, IPublishFolder iPublishFolder, int[] nArray) throws WCMException {
        if (nArray.length == 1) {
            return;
        }
        Template template = this.m_oCacheMgr.getDefaultOutlineTemplate(iPublishFolder);
        Templates templates = this.m_oCacheMgr.getOutlineTemplates(iPublishFolder);
        int n = 0;
        if (template != null && templates.getIdAt(0) == template.getId()) {
            n = 1;
        }
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (templates.indexOf(n2) >= n) continue;
            TemplateEmploy templateEmploy = new TemplateEmploy();
            templateEmploy.setEmployer(iPublishFolder);
            templateEmploy.setDefault(false);
            templateEmploy.setTemplate(1, n2);
            templateEmploy.save(user);
        }
    }

    private void deleteUnuseEmploys(User user, IPublishFolder iPublishFolder, int[] nArray) throws WCMException {
        Object object;
        String string = "ISDEFAULT=0 and EmployerType=? and EmployerId=?";
        if (nArray.length > 1) {
            object = String.valueOf(nArray[1]);
            for (int i = 2; i < nArray.length; ++i) {
                object = (String)object + "," + nArray[i];
            }
            string = string + " and TemplateId not in(" + (String)object + ")";
        }
        object = new WCMFilter("", string, "");
        ((WCMFilter)object).addSearchValues(0, iPublishFolder.getType());
        ((WCMFilter)object).addSearchValues(1, iPublishFolder.getId());
        TemplateEmploys.openWCMObjs(user, (WCMFilter)object).removeAll(true);
    }

    public void setDefaultOutline(IPublishFolder iPublishFolder, int n) throws WCMException {
        if (n == 0) {
            if (this.m_oCacheMgr.getDefaultOutlineTemplate(iPublishFolder) == null) {
                return;
            }
            TemplateEmploy templateEmploy = this.getDefaultEmployOfEmployer(iPublishFolder.getType(), iPublishFolder.getId(), 1);
            if (templateEmploy != null) {
                templateEmploy.delete(ContextHelper.getLoginUser());
            }
        } else {
            int n2;
            Template template = this.m_oCacheMgr.getDefaultOutlineTemplate(iPublishFolder);
            int n3 = n2 = template == null ? 0 : template.getId();
            if (n2 == n) {
                return;
            }
            TemplateEmploy templateEmploy = this.getDefaultEmployOfEmployer(iPublishFolder.getType(), iPublishFolder.getId(), 1);
            if (templateEmploy != null) {
                templateEmploy.canEdit(ContextHelper.getLoginUser());
            } else {
                templateEmploy = new TemplateEmploy();
                templateEmploy.setEmployer(iPublishFolder);
                templateEmploy.setDefault(true);
            }
            templateEmploy.setTemplate(1, n);
            templateEmploy.save(ContextHelper.getLoginUser());
        }
    }

    public void setOtherOutlines(User user, IPublishFolder iPublishFolder, String string) throws WCMException {
        String string2 = "ISDEFAULT=0 and EmployerType=? and EmployerId=?";
        if (string != null && string.length() > 0) {
            string2 = string2 + " and TemplateId not in(" + string + ")";
        }
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(0, iPublishFolder.getType());
        wCMFilter.addSearchValues(1, iPublishFolder.getId());
        TemplateEmploys.openWCMObjs(user, wCMFilter).removeAll(true);
        wCMFilter.setWhere("exists(select WCMTemplateEmploy.TemplateId from WCMTemplateEmploy where ISDEFAULT=0 and EmployerType=? and EmployerId=? and WCMTemplateEmploy.TemplateId=WCMTemplate.TempId)");
        Templates templates = Templates.openWCMObjs(user, wCMFilter);
        int[] nArray = CMyString.splitToInt(string, ",");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (templates.indexOf(n) >= 0) continue;
            TemplateEmploy templateEmploy = new TemplateEmploy();
            templateEmploy.setEmployer(iPublishFolder);
            templateEmploy.setDefault(false);
            templateEmploy.setTemplate(1, n);
            templateEmploy.save(user);
        }
    }

    public void setDetailTemplate(IPublishElement iPublishElement, int n, boolean bl, int n2) throws WCMException {
        Object object;
        String string = "EMPLOYERID=? and EMPLOYERTYPE=? and TEMPLATETYPE=?";
        WCMFilter wCMFilter = new WCMFilter("", string, null);
        wCMFilter.addSearchValues(iPublishElement.getId());
        wCMFilter.addSearchValues(iPublishElement.getType());
        wCMFilter.addSearchValues(n2);
        wCMFilter.setMaxRowNumber(1);
        User user = ContextHelper.getLoginUser();
        TemplateEmploys templateEmploys = new TemplateEmploys(user, 1, 1);
        templateEmploys.open(wCMFilter);
        if (n == 0) {
            templateEmploys.removeAll(true);
        } else {
            try {
                object = null;
                if (templateEmploys.isEmpty()) {
                    object = new TemplateEmploy();
                    ((TemplateEmploy)object).setEmployer(iPublishElement);
                    ((TemplateEmploy)object).setTemplate(n2, n);
                    ((TemplateEmploy)object).setDefault(true);
                    ((TemplateEmploy)object).insert(user);
                } else {
                    object = (TemplateEmploy)templateEmploys.getAt(0);
                    if (((CMSObj)object).canEdit(user)) {
                        ((TemplateEmploy)object).setTemplate(n2, n);
                        ((TemplateEmploy)object).setEmployer(iPublishElement);
                        ((TemplateEmploy)object).setTemplate(n2, n);
                        ((TemplateEmploy)object).setDefault(true);
                        ((CMSObj)object).update(user);
                    }
                }
            }
            catch (Exception exception) {
                throw new WCMException(1100, "Failed to set the employer detail template!", exception);
            }
            finally {
                if (templateEmploys != null) {
                    templateEmploys.clear();
                }
            }
        }
        if (bl && iPublishElement instanceof IPublishFolder) {
            object = n == 0 ? "" : String.valueOf(n);
            this.resetChildern((IPublishFolder)iPublishElement, (String)object, false);
        }
    }

    public void setDetailTemplate(IPublishElement iPublishElement, int n, boolean bl) throws WCMException {
        Object object;
        String string = "EMPLOYERID=? and EMPLOYERTYPE=? and TEMPLATETYPE=?";
        WCMFilter wCMFilter = new WCMFilter("", string, null);
        wCMFilter.addSearchValues(iPublishElement.getId());
        wCMFilter.addSearchValues(iPublishElement.getType());
        wCMFilter.addSearchValues(2);
        wCMFilter.setMaxRowNumber(1);
        User user = ContextHelper.getLoginUser();
        TemplateEmploys templateEmploys = new TemplateEmploys(user, 1, 1);
        templateEmploys.open(wCMFilter);
        if (n == 0) {
            templateEmploys.removeAll(true);
        } else {
            try {
                object = null;
                if (templateEmploys.isEmpty()) {
                    object = new TemplateEmploy();
                    ((TemplateEmploy)object).setEmployer(iPublishElement);
                    ((TemplateEmploy)object).setTemplate(2, n);
                    ((TemplateEmploy)object).setDefault(true);
                    ((TemplateEmploy)object).insert(user);
                } else {
                    object = (TemplateEmploy)templateEmploys.getAt(0);
                    if (((CMSObj)object).canEdit(user)) {
                        ((TemplateEmploy)object).setTemplate(2, n);
                        ((TemplateEmploy)object).setEmployer(iPublishElement);
                        ((TemplateEmploy)object).setDefault(true);
                        ((CMSObj)object).update(user);
                    }
                }
            }
            catch (Exception exception) {
                throw new WCMException(1100, "Failed to set the employer detail template!", exception);
            }
            finally {
                if (templateEmploys != null) {
                    templateEmploys.clear();
                }
            }
        }
        if (bl && iPublishElement instanceof IPublishFolder) {
            object = n == 0 ? "0" : String.valueOf(n);
            this.resetChildern((IPublishFolder)iPublishElement, (String)object, false);
        }
    }

    public List getEmployers(Template template, WCMFilter wCMFilter) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateEmploys templateEmploys = null;
        try {
            templateEmploys = this.getTemplateEmployers(template, wCMFilter);
            ArrayList<IPublishElement> arrayList = new ArrayList<IPublishElement>();
            for (int i = 0; i < templateEmploys.size(); ++i) {
                TemplateEmploy templateEmploy = (TemplateEmploy)templateEmploys.getAt(i);
                if (templateEmploy == null) continue;
                arrayList.add(templateEmploy.getEmployer());
            }
            ArrayList<IPublishElement> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the folders who use the specified template.", exception);
        }
        finally {
            if (templateEmploys != null) {
                templateEmploys.clear();
            }
        }
    }

    public TemplateEmploys getTemplateEmployers(Template template, WCMFilter wCMFilter) throws WCMException {
        WCMFilter wCMFilter2 = new WCMFilter("", "TEMPLATEID=?", "");
        wCMFilter2.addSearchValues(0, template.getId());
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        TemplateEmploys templateEmploys = new TemplateEmploys(ContextHelper.getLoginUser());
        templateEmploys.open(wCMFilter2);
        return templateEmploys;
    }

    public List getEmployers(Template template, int n) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "EMPLOYERTYPE=?", "");
        wCMFilter.addSearchValues(0, n);
        return this.getEmployers(template, wCMFilter);
    }

    public int clearEmploysOfEmployer(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement == null) {
            throw new WCMException(10, "Valid publish element required!");
        }
        return this.clearEmploysOfEmployer(iPublishElement.getType(), iPublishElement.getId());
    }

    public int clearEmploysOfEmployer(int n, int n2) throws WCMException {
        String string = "EMPLOYERID=? AND EMPLOYERTYPE=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, n2);
        wCMFilter.addSearchValues(1, n);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        int n3 = templateEmploys.size();
        templateEmploys.removeAll(true);
        return n3;
    }

    public int clearEmploysOfTemplate(Template template) throws WCMException {
        if (template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        return this.clearEmploysOfTemplate(template.getId());
    }

    public int clearEmploysOfTemplate(int n) throws WCMException {
        String string = "TEMPLATEID=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(0, n);
        TemplateEmploys templateEmploys = TemplateEmploys.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        int n2 = templateEmploys.size();
        templateEmploys.removeAll(true);
        return n2;
    }

    public void resetChildern(IPublishFolder iPublishFolder, String string, boolean bl) throws WCMException {
        IPublishElements iPublishElements = iPublishFolder.getChildren();
        if (iPublishElements == null) {
            return;
        }
        IPublishFolder iPublishFolder2 = null;
        for (int i = 0; i < iPublishElements.size(); ++i) {
            Channel channel;
            int n;
            try {
                iPublishFolder2 = (IPublishFolder)iPublishElements.get(i);
            }
            catch (Exception exception) {
                throw new WCMException(1100, I18NMessage.get(TemplateEmployMgr.class, "TemplateEmployMgr.label2", "\u83b7\u53d6\u5b50folder\u53d1\u751f\u5f02\u5e38!"), exception);
            }
            if (iPublishFolder2 == null) continue;
            CMSObj cMSObj = null;
            cMSObj = iPublishFolder2.getSubstance();
            if (cMSObj != null && cMSObj instanceof Channel && ((n = (channel = (Channel)cMSObj).getType()) == 2 || n == 1 || n == 11)) continue;
            if (bl) {
                this.setOutlineTemplates(iPublishFolder2, string, true);
                continue;
            }
            this.setDetailTemplate(iPublishFolder2, Integer.parseInt(string), true);
        }
    }

    public void resetChildern(IPublishFolder iPublishFolder) throws WCMException {
        Template template = this.getDetailTemplate(iPublishFolder);
        String string = "0";
        if (template != null) {
            string = String.valueOf(template.getId());
        }
        this.resetChildern(iPublishFolder, string, false);
        IPublishElements iPublishElements = iPublishFolder.getChildren();
        if (iPublishElements == null) {
            return;
        }
        Templates templates = this.getOutlineTemplates(iPublishFolder);
        string = "0";
        if (!templates.isEmpty()) {
            string = templates.getIdListAsString();
        }
        if (this.getDefaultOutlineTemplate(iPublishFolder) == null && !string.equals("0")) {
            string = "0," + string;
        }
        this.resetChildern(iPublishFolder, string, true);
    }
}

