/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployDetail;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateEmployCacheMgrImpl
implements ITemplateEmployCacheMgr {
    private static Logger logger = Logger.getLogger(TemplateEmployCacheMgrImpl.class);
    private Map m_hTemplateEmployCache = null;

    public Template getDetailTemplate(IPublishElement iPublishElement) throws WCMException {
        return this.getDetailTemplate(iPublishElement.getType(), iPublishElement.getId());
    }

    public Template getDefaultOutlineTemplate(IPublishFolder iPublishFolder) throws WCMException {
        TemplateEmployDetail templateEmployDetail = this.getTemplateEmployCache(iPublishFolder.getType(), iPublishFolder.getId());
        if (templateEmployDetail == null) {
            return null;
        }
        return templateEmployDetail.getDefaultOutlineTemplate();
    }

    public Templates getOutlineTemplates(IPublishFolder iPublishFolder) throws WCMException {
        TemplateEmployDetail templateEmployDetail = this.getTemplateEmployCache(iPublishFolder.getType(), iPublishFolder.getId());
        if (templateEmployDetail == null) {
            return new Templates(User.getSystem());
        }
        return templateEmployDetail.getOutlineTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean init() throws WCMException {
        block34: {
            if (this.m_hTemplateEmployCache != null) {
                return true;
            }
            TemplateEmployCacheMgrImpl templateEmployCacheMgrImpl = this;
            synchronized (templateEmployCacheMgrImpl) {
                PreparedStatement preparedStatement;
                Connection connection;
                DBManager dBManager;
                block32: {
                    Serializable serializable2222;
                    ArrayList<Integer> arrayList;
                    block33: {
                        block31: {
                            if (this.m_hTemplateEmployCache != null) {
                                return true;
                            }
                            arrayList = new ArrayList<Integer>(4);
                            dBManager = DBManager.getDBManager();
                            connection = null;
                            preparedStatement = null;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"get EMPLOYERTYPE...");
                            }
                            connection = dBManager.getConnection();
                            preparedStatement = connection.prepareStatement("select distinct EMPLOYERTYPE from WCMTEMPLATEEMPLOY");
                            ResultSet resultSet = preparedStatement.executeQuery();
                            while (resultSet.next()) {
                                arrayList.add(new Integer(resultSet.getInt(1)));
                            }
                            resultSet.close();
                            preparedStatement.close();
                            preparedStatement = null;
                            Object var9_8 = null;
                            if (preparedStatement == null) break block31;
                            try {
                                preparedStatement.close();
                            }
                            catch (Exception serializable2222) {
                                // empty catch block
                            }
                        }
                        if (connection != null) {
                            dBManager.freeConnection(connection);
                        }
                        break block33;
                        {
                            catch (Exception exception) {
                                throw new WCMException(I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label1", "\u8bfb\u53d6\u96c7\u4e3b\u7c7b\u578b\u6570\u636e\u5931\u8d25!"), exception);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (connection != null) {
                                dBManager.freeConnection(connection);
                            }
                            throw throwable;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"get EMPLOYERTYPE end!");
                    }
                    connection = dBManager.getConnection();
                    ICachedPOMgr iCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
                    int n = iCachedPOMgr.getCacheIndex(Template.class);
                    serializable2222 = iCachedPOMgr.getBuffer(n);
                    Hashtable hashtable = new Hashtable(4);
                    preparedStatement = connection.prepareStatement("select * from WCMTEMPLATEEMPLOY where EMPLOYERTYPE=?");
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Integer n2 = (Integer)arrayList.get(i);
                        Hashtable<Integer, TemplateEmployDetail> hashtable2 = new Hashtable<Integer, TemplateEmployDetail>(1000);
                        hashtable.put(n2, hashtable2);
                        preparedStatement.setInt(1, n2);
                        preparedStatement.setFetchSize(1000);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            Integer n3 = new Integer(resultSet.getInt("EMPLOYERID"));
                            TemplateEmployDetail templateEmployDetail = (TemplateEmployDetail)hashtable2.get(n3);
                            if (templateEmployDetail == null) {
                                templateEmployDetail = new TemplateEmployDetail();
                                hashtable2.put(n3, templateEmployDetail);
                            }
                            templateEmployDetail.putEmploy(resultSet.getInt("TEMPLATEEMPLOYID"), resultSet.getInt("TEMPLATETYPE"), (Template)((Hashtable)serializable2222).get(new Integer(resultSet.getInt("TEMPLATEID"))), resultSet.getInt("ISDEFAULT") == 1);
                        }
                        resultSet.close();
                    }
                    this.m_hTemplateEmployCache = hashtable;
                    preparedStatement.close();
                    preparedStatement = null;
                    Object var19_23 = null;
                    if (preparedStatement == null) break block32;
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    dBManager.freeConnection(connection);
                }
                break block34;
                {
                    catch (SQLException sQLException) {
                        throw new WCMException(I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label2", "\u8bfb\u53d6\u6570\u636e\u5931\u8d25!"), sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        dBManager.freeConnection(connection);
                    }
                    throw throwable;
                }
            }
        }
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.m_hTemplateEmployCache == null) {
            return;
        }
        Map map = this.m_hTemplateEmployCache;
        synchronized (map) {
            if (this.m_hTemplateEmployCache == null) {
                return;
            }
            this.m_hTemplateEmployCache.clear();
            this.m_hTemplateEmployCache = null;
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label4", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        this.putEmployInCache(templateEmploy);
    }

    private void putEmployInCache(TemplateEmploy templateEmploy) throws WCMException {
        Integer n = new Integer(templateEmploy.getEmployerType());
        Hashtable hashtable = (Hashtable)this.getTemplateEmployCache().get(n);
        if (hashtable == null) {
            hashtable = new Hashtable(1);
            this.getTemplateEmployCache().put(n, hashtable);
        }
        this.putEmployInCache(hashtable, templateEmploy);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label5", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        this.removeEmployFromCache(templateEmploy);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof TemplateEmploy)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label3", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(TemplateEmployCacheMgrImpl.class, "TemplateEmployCacheMgrImpl.label6", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!baseObj.isModified()) {
            return;
        }
        TemplateEmploy templateEmploy = (TemplateEmploy)baseObj;
        if (templateEmploy.isChangeProperty("TEMPLATEID") || templateEmploy.isChangeProperty("TEMPLATETYPE")) {
            this.removeEmployFromCache(templateEmploy);
        }
        TemplateEmploy templateEmploy2 = new TemplateEmploy();
        templateEmploy2.setProperties(templateEmploy.getProperties());
        templateEmploy2.setProperties(templateEmploy.getNewProperties());
        this.putEmployInCache(templateEmploy2);
    }

    private Map getTemplateEmployCache() throws WCMException {
        if (this.m_hTemplateEmployCache == null) {
            this.init();
        }
        return this.m_hTemplateEmployCache;
    }

    private TemplateEmployDetail getTemplateEmployCache(int n, int n2) throws WCMException {
        Map map = (Map)this.getTemplateEmployCache().get(new Integer(n));
        if (map == null) {
            return null;
        }
        return (TemplateEmployDetail)map.get(new Integer(n2));
    }

    private void putEmployInCache(Map map, TemplateEmploy templateEmploy) throws WCMException {
        Integer n = new Integer(templateEmploy.getEmployerId());
        TemplateEmployDetail templateEmployDetail = (TemplateEmployDetail)map.get(n);
        if (templateEmployDetail == null) {
            templateEmployDetail = new TemplateEmployDetail(templateEmploy);
            map.put(n, templateEmployDetail);
        } else {
            templateEmployDetail.putEmploy(templateEmploy);
        }
    }

    private void removeEmployFromCache(TemplateEmploy templateEmploy) throws WCMException {
        Integer n = new Integer(templateEmploy.getEmployerType());
        Map map = (Map)this.getTemplateEmployCache().get(n);
        if (map == null) {
            return;
        }
        Integer n2 = new Integer(templateEmploy.getEmployerId());
        TemplateEmployDetail templateEmployDetail = (TemplateEmployDetail)map.get(n2);
        if (templateEmployDetail == null) {
            return;
        }
        templateEmployDetail.removeEmploy(templateEmploy);
        if (templateEmployDetail.isEmpty()) {
            map.remove(n2);
        }
    }

    public Template getDetailTemplate(int n, int n2) throws WCMException {
        TemplateEmployDetail templateEmployDetail = this.getTemplateEmployCache(n, n2);
        if (templateEmployDetail == null) {
            return null;
        }
        return templateEmployDetail.getDefaultDetailTemplate();
    }
}

