/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.TemplateParseConfig;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class TemplateCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(TemplateCacheMgr.class);
    private LRUCacheContainer m_nameCache = new LRUCacheContainer();

    private Object makeKey(IPublishFolder iPublishFolder, String string) {
        return Integer.toHexString(iPublishFolder.getType()) + "/" + Integer.toHexString(iPublishFolder.getId()) + "/" + string;
    }

    public synchronized boolean init() {
        try {
            TemplateParseConfig templateParseConfig = PublishServerConfigMapper.getTemplateParseConfig();
            this.m_nameCache.setMaxSize(templateParseConfig.getNameCacheMaxSize());
            logger.info((Object)("Template name cache maximum size: " + this.m_nameCache.getMaxSize()));
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to load configuration from publish server config!", (Throwable)exception);
        }
        return true;
    }

    public boolean reinit() {
        this.clear();
        return this.init();
    }

    public synchronized void clear() {
        logger.debug((Object)"to clear template name cache ...");
        this.m_nameCache.clear();
        logger.debug((Object)"template name cache is cleared!");
    }

    public Template lookupByName(IPublishFolder iPublishFolder, String string) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid root folder required!");
        }
        Object object = this.makeKey(iPublishFolder, string);
        Template template = (Template)this.m_nameCache.get(object);
        if (template != null) {
            return template;
        }
        BaseObjs baseObjs = null;
        try {
            WCMFilter wCMFilter = new WCMFilter("", "RooTId=? AND TEMPNAME=? AND ROOTTYPE=?", "");
            baseObjs = new Templates(ContextHelper.getLoginUser(), 1, 1);
            baseObjs.setMaxSize(1);
            wCMFilter.addSearchValues(iPublishFolder.getId());
            wCMFilter.addSearchValues(string);
            wCMFilter.addSearchValues(iPublishFolder.getType());
            baseObjs.open(wCMFilter);
            if (!baseObjs.isEmpty()) {
                template = (Template)baseObjs.getAt(0);
            }
            if (template != null) {
                this.m_nameCache.put(object, (Object)template);
            }
            Template template2 = template;
            return template2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to lookup template [" + string + "]", exception);
        }
        finally {
            if (baseObjs != null) {
                baseObjs.clear();
            }
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) {
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        try {
            Template template = (Template)baseObj;
            IPublishFolder iPublishFolder = template.getRoot();
            if (iPublishFolder == null) {
                logger.error((Object)("Template[" + template.getId() + "] root is not found!"));
                return;
            }
            Object object = this.makeKey(iPublishFolder, template.getName());
            this.m_nameCache.remove(object);
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to remove the template from cache.", exception);
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (baseObj.isChangeProperty("TEMPNAME")) {
            try {
                Template template = (Template)baseObj;
                IPublishFolder iPublishFolder = template.getRoot();
                if (iPublishFolder == null) {
                    logger.error((Object)("Template[" + template.getId() + "] root is not found!"));
                    return;
                }
                Object object = this.makeKey(iPublishFolder, template.getName());
                if (this.m_nameCache.remove(object) != null) {
                    object = this.makeKey(iPublishFolder, template.getNewPropertyAsString("TEMPNAME"));
                    this.m_nameCache.put(object, (Object)template);
                }
            }
            catch (Exception exception) {
                throw new WCMException(1100, "Failed to update template cache after name is changed.", exception);
            }
        }
    }
}

