/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import org.apache.log4j.Logger;

public class ThreadPool {
    protected static Logger logger = Logger.getLogger(ThreadPool.class);
    private int m_iSequence = 0;
    private int m_iCurIndex = 0;
    private int m_iMaxLimit = 0;
    private int m_iCurCount = 0;
    private Worker[] m_allWorker = null;

    public int getTotalCount() {
        return this.m_iCurCount;
    }

    public int getIdleCount() {
        return this.m_iCurIndex;
    }

    public int getMaxLimit() {
        return this.m_iMaxLimit;
    }

    protected synchronized int getSequence() {
        return ++this.m_iSequence;
    }

    protected synchronized void workerDestroy(Worker worker) {
        Worker[] workerArray = this.m_allWorker;
        if (workerArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.m_iCurIndex; ++i) {
                Worker worker2 = workerArray[i];
                if (bl) {
                    workerArray[i - 1] = worker2;
                    continue;
                }
                if (worker2 != worker) continue;
                bl = true;
            }
            if (bl) {
                --this.m_iCurIndex;
            }
            --this.m_iCurCount;
        }
    }

    private void createWorker(int n) {
        if (n > this.m_iMaxLimit) {
            n = this.m_iMaxLimit;
        }
        for (int i = 0; i < n; ++i) {
            Worker worker = new Worker();
            worker.start();
            this.m_allWorker[this.m_iCurIndex] = worker;
            ++this.m_iCurIndex;
            ++this.m_iCurCount;
        }
    }

    private synchronized Worker assignWorker() {
        if (this.m_allWorker == null) {
            throw new IllegalStateException("ThreadPool stop");
        }
        while (this.m_iCurIndex == 0 && this.m_iCurCount < this.m_iMaxLimit) {
            this.createWorker(this.m_iMaxLimit - this.m_iCurCount);
        }
        if (this.m_iCurIndex > 0) {
            return this.m_allWorker[--this.m_iCurIndex];
        }
        return null;
    }

    protected synchronized void returnWorker(Worker worker) {
        this.m_allWorker[this.m_iCurIndex] = worker;
        ++this.m_iCurIndex;
        this.notify();
    }

    public synchronized void waitForWorker() {
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void startup(int n) {
        if (this.m_allWorker != null) {
            throw new IllegalStateException("ThreadPool init");
        }
        if (n <= 0) {
            n = 30;
        }
        this.m_iCurIndex = 0;
        this.m_iCurCount = 0;
        this.m_iMaxLimit = n;
        this.m_allWorker = new Worker[n];
        this.createWorker(n);
    }

    public synchronized void cleanup() {
        Worker[] workerArray = this.m_allWorker;
        if (workerArray != null) {
            this.m_allWorker = null;
            for (int i = 0; i < this.m_iCurIndex; ++i) {
                workerArray[i].terminate();
            }
            this.m_iCurIndex = 0;
            this.m_iCurCount = 0;
            this.m_iMaxLimit = 0;
        }
    }

    public boolean runIt(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("ThreadPool.runit(),aRunnable is null.");
        }
        Worker worker = this.assignWorker();
        if (worker != null) {
            worker.runIt(runnable);
            return true;
        }
        return false;
    }

    private class Worker
    extends Thread {
        private Runnable m_oRunnable = null;
        private boolean m_zTerminate = false;
        private boolean m_zHasNewTask = false;

        private Worker() {
            this.setDaemon(true);
            this.setName("ThreadPool$Worker$" + ThreadPool.this.getSequence());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                try {
                    block18: {
                        Object var4_4;
                        try {
                            while (true) {
                                try {
                                    do {
                                        Worker worker = this;
                                        // MONITORENTER : worker
                                        while (!this.m_zTerminate && !this.m_zHasNewTask) {
                                            this.wait(1000L);
                                        }
                                        // MONITOREXIT : worker
                                        if (this.m_zTerminate) {
                                            var4_4 = null;
                                            if (this.m_zHasNewTask) {
                                                this.m_oRunnable = null;
                                                this.m_zHasNewTask = false;
                                                ThreadPool.this.returnWorker(this);
                                            }
                                            break block18;
                                        }
                                        if (this.m_oRunnable != null) {
                                            this.m_oRunnable.run();
                                        }
                                        if (this.m_zTerminate) {
                                            var4_4 = null;
                                            if (this.m_zHasNewTask) {
                                                this.m_oRunnable = null;
                                                this.m_zHasNewTask = false;
                                                ThreadPool.this.returnWorker(this);
                                            }
                                            break block18;
                                        }
                                        var4_4 = null;
                                    } while (!this.m_zHasNewTask);
                                    this.m_oRunnable = null;
                                    this.m_zHasNewTask = false;
                                    ThreadPool.this.returnWorker(this);
                                }
                                catch (Throwable throwable) {
                                    logger.error((Object)"ThreadPool$Worker error", throwable);
                                    var4_4 = null;
                                    if (!this.m_zHasNewTask) continue;
                                    this.m_oRunnable = null;
                                    this.m_zHasNewTask = false;
                                    ThreadPool.this.returnWorker(this);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var4_4 = null;
                            if (!this.m_zHasNewTask) throw throwable;
                            this.m_oRunnable = null;
                            this.m_zHasNewTask = false;
                            ThreadPool.this.returnWorker(this);
                            throw throwable;
                        }
                    }
                    Object var6_6 = null;
                    if (this.m_zTerminate) return;
                    ThreadPool.this.workerDestroy(this);
                    return;
                }
                catch (Throwable throwable) {
                    logger.error((Object)"ThreadPool$Worker failed", throwable);
                    Object var6_7 = null;
                    if (this.m_zTerminate) return;
                    ThreadPool.this.workerDestroy(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (this.m_zTerminate) throw throwable;
                ThreadPool.this.workerDestroy(this);
                throw throwable;
            }
        }

        protected synchronized void runIt(Runnable runnable) {
            this.m_oRunnable = runnable;
            this.m_zHasNewTask = true;
            this.notify();
        }

        protected synchronized void terminate() {
            this.m_zTerminate = true;
            this.notify();
        }
    }
}

