/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class PublishTaskMgrImpl
implements IPublishTaskMgr {
    public PublishTask save(PublishTask publishTask) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (publishTask == null) {
            throw new WCMException(10, "The publish task must be a valid instance!");
        }
        if (publishTask.isValidInstance()) {
            publishTask.update(user);
        } else {
            publishTask.insert(user);
        }
        return publishTask;
    }

    public boolean delete(PublishTask publishTask) throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (publishTask == null) {
            throw new WCMException(10, "The publish task must be a valid instance!");
        }
        int n = publishTask.delete(user);
        return n == 1;
    }

    public PublishTasks getMyTasks(WCMFilter wCMFilter) throws WCMException {
        User user = ContextHelper.getLoginUser();
        String string = "CRUSER='" + CMyString.filterForSQL(user.getName()) + "'";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "CRTIME DESC");
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        PublishTasks publishTasks = new PublishTasks(user);
        publishTasks.open(wCMFilter2);
        return publishTasks;
    }

    public PublishTasks getTasks(WCMFilter wCMFilter) throws WCMException {
        User user = ContextHelper.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("", "", "CRTIME DESC");
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        PublishTasks publishTasks = new PublishTasks(user);
        publishTasks.open(wCMFilter2);
        return publishTasks;
    }

    public PublishTasks getUnfinishedTasks() throws WCMException {
        try {
            User user = ContextHelper.getLoginUser();
            PublishTasks publishTasks = new PublishTasks(user);
            publishTasks.open(new WCMFilter("", "TASKSTATUS<7", ""));
            return publishTasks;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to fetch the unfinished publish tasks!", exception);
        }
    }

    public PublishTask createFolderPublishTask(IPublishFolder iPublishFolder, int n) throws WCMException {
        if (!PublishConstants.isPublishTypeOfFolder(n)) {
            throw new WCMException(10, "Invalid folder publish type: " + n);
        }
        String string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]");
        String string2 = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{iPublishFolder.getInfo(), string});
        return this.createPublishTask(iPublishFolder, 0, null, n, string2, string2, 1, null);
    }

    public PublishTask createPublishTaskForFolderAndPubDocs(IPublishFolder iPublishFolder, int n, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (!PublishConstants.isPublishTypeOfFolder(n)) {
            throw new WCMException(10, "Invalid folder publish type: " + n);
        }
        String string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]");
        String string2 = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{iPublishFolder.getInfo(), string});
        return this.creatPublishTaskForFolderAndPublishedDocs(iPublishFolder, n, string2, string2, 1, cMyDateTime, cMyDateTime2);
    }

    public PublishTask createContentPublishTask(IPublishContent iPublishContent, int n) throws WCMException {
        if (!PublishConstants.isPublishTypeOfContent(n)) {
            throw new WCMException(10, "Invalid content publish type: " + n);
        }
        IPublishFolder iPublishFolder = iPublishContent.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig where the content lies required (plz call IPublishContent.setFolder())!");
        }
        String string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]", true);
        String string2 = string + ": " + iPublishContent.getInfo();
        String string3 = string2 + I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label2", "\n \u5728") + iPublishFolder.getInfo() + I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d");
        CMSObj cMSObj = iPublishContent.getSubstance();
        return this.createPublishTask(iPublishFolder, cMSObj.getWCMType(), String.valueOf(cMSObj.getId()), n, string2, string3, 9, null);
    }

    public PublishTask createContentPublishTask(IPublishElements iPublishElements, IPublishFolder iPublishFolder, int n) throws WCMException {
        IPublishContent iPublishContent;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        block8: {
            if (!PublishConstants.isPublishTypeOfContent(n)) {
                throw new WCMException(10, "Invalid content publish type: " + n);
            }
            if (iPublishElements == null || iPublishElements.isEmpty()) {
                return null;
            }
            stringBuffer2 = null;
            stringBuffer = null;
            stringBuffer = new StringBuffer();
            stringBuffer.append("\nIn FolderTypeConfig: ").append(iPublishFolder.getInfo());
            stringBuffer.append("\n");
            iPublishContent = null;
            stringBuffer2 = new StringBuffer(iPublishElements.size() * 7);
            for (int i = 0; i < iPublishElements.size(); ++i) {
                iPublishContent = (IPublishContent)iPublishElements.get(i);
                stringBuffer2.append(iPublishContent.getId());
                stringBuffer2.append(',');
                stringBuffer.append(iPublishContent.getInfo());
                stringBuffer.append("\n");
            }
            if (iPublishContent != null) break block8;
            PublishTask publishTask = null;
            Object var12_11 = null;
            return publishTask;
        }
        try {
            String string;
            stringBuffer2.setLength(stringBuffer2.length() - 1);
            stringBuffer.setLength(stringBuffer.length() - 1);
            String string2 = string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]", true);
            String string3 = string2 + stringBuffer.toString();
            PublishTask publishTask = this.createPublishTask(iPublishFolder, iPublishContent.getSubstance().getWCMType(), stringBuffer2.toString(), n, string2, string3, 9, null);
            Object var12_12 = null;
            return publishTask;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(224, "Failed to create contents publishing task!", exception);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                throw throwable;
            }
        }
    }

    private PublishTask createPublishTask(IPublishFolder iPublishFolder, int n, String string, int n2, String string2, String string3, int n3, String string4) throws WCMException {
        if (this.isExistsPublishTask(iPublishFolder, n, string, n2, string4)) {
            return null;
        }
        PublishTask publishTask = null;
        User user = ContextHelper.getLoginUser();
        try {
            publishTask = PublishTask.createNewInstance();
            Object object = ContextParameters.get(7);
            if (Boolean.TRUE == object) {
                publishTask.setSchedulePublishTask(true);
            } else {
                publishTask.setSchedulePublishTask(false);
            }
            publishTask.setPublishType(n2);
            publishTask.setFolder(iPublishFolder);
            if (string != null) {
                publishTask.setContent(n, string);
            }
            publishTask.setPriority(n3);
            publishTask.setStatus(1);
            publishTask.setTitle(string2);
            publishTask.setDesc(string3);
            publishTask.setCrUser(user);
            if (string4 != null) {
                publishTask.setFolders(string4);
            }
            publishTask.insert(user);
            return publishTask;
        }
        catch (Exception exception) {
            throw new WCMException(224, "Failed to create publishing task for [" + string2 + "].", exception);
        }
    }

    private PublishTask creatPublishTaskForFolderAndPublishedDocs(IPublishFolder iPublishFolder, int n, String string, String string2, int n2, CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) throws WCMException {
        if (this.isExistsPublishTask(iPublishFolder, 0, null, n, null)) {
            return null;
        }
        PublishTask publishTask = null;
        User user = ContextHelper.getLoginUser();
        try {
            publishTask = PublishTask.createNewInstance();
            Object object = ContextParameters.get(7);
            if (Boolean.TRUE == object) {
                publishTask.setSchedulePublishTask(true);
            } else {
                publishTask.setSchedulePublishTask(false);
            }
            publishTask.setPublishType(n);
            publishTask.setFolder(iPublishFolder);
            publishTask.setPriority(n2);
            publishTask.setStatus(1);
            publishTask.setTitle(string);
            publishTask.setDesc(string2);
            publishTask.setCrUser(user);
            publishTask.setAttribute("StartDocCrtime", cMyDateTime.toString());
            publishTask.setAttribute("EndDocCrtime", cMyDateTime2.toString());
            publishTask.insert(user);
            return publishTask;
        }
        catch (Exception exception) {
            throw new WCMException(224, "Failed to create publishing task for [" + string + "].", exception);
        }
    }

    private boolean isExistsPublishTask(IPublishFolder iPublishFolder, int n, String string, int n2, String string2) throws WCMException {
        int n3;
        int n4 = 3;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select PUBLISHTASKID from WCMPUBLISHTASK where PUBLISHTYPE=? and FOLDERTYPE=? and FOLDERID=? AND TASKSTATUS in(");
        stringBuffer.append(5);
        stringBuffer.append(",");
        stringBuffer.append(1);
        stringBuffer.append(")");
        if (string != null) {
            stringBuffer.append(" and CONTENTTYPE=? and CONTENTIDS=? ");
            n4 += 2;
        }
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            stringBuffer.append(" and FOLDERIDS=?");
            ++n4;
        }
        int n5 = 0;
        Object[] objectArray = new Object[n4];
        objectArray[n5++] = new Integer(n2);
        objectArray[n5++] = new Integer(iPublishFolder.getType());
        objectArray[n5++] = new Integer(iPublishFolder.getId());
        if (string != null) {
            objectArray[n5++] = new Integer(n);
            objectArray[n5++] = string;
        }
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            objectArray[n5++] = string2;
        }
        return (n3 = this.sqlExecuteIntQuery(stringBuffer.toString(), objectArray)) > 0;
    }

    public PublishTask createContentPublishTask(IPublishContent iPublishContent, IPublishFolder iPublishFolder, IPublishElements iPublishElements) throws WCMException {
        if (iPublishContent == null) {
            return null;
        }
        if (iPublishFolder == null) {
            return null;
        }
        try {
            Object object;
            String string = PublishConstants.getPublishTypeName(10, "[unknown publish type PUBLISH_CONTENT_DIRECT]", true);
            String string2 = string + ": " + iPublishContent.getInfo();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string2).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label4", " \u5728"));
            stringBuffer2.append(iPublishFolder.getInfo()).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d"));
            if (iPublishElements != null) {
                int n2 = iPublishElements.size();
                for (int i = 0; i < n2; ++i) {
                    object = iPublishElements.get(i);
                    if (object == null) continue;
                    if (n > 0) {
                        stringBuffer.append(',');
                    } else {
                        stringBuffer2.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label5", "\uff0c\u5e76\u89e6\u53d1\u4ee5\u4e0b\u9891\u9053\u7684\u6982\u89c8\u66f4\u65b0\uff1a"));
                    }
                    stringBuffer.append(object.getSubstance().getId());
                    stringBuffer2.append("\n").append(object.getInfo());
                    ++n;
                }
            }
            String string3 = stringBuffer2.toString();
            PublishTask publishTask = this.createPublishTask(iPublishFolder, iPublishContent.getSubstance().getWCMType(), String.valueOf(iPublishContent.getSubstance().getId()), 10, string2, string3, 9, stringBuffer.toString());
            object = publishTask;
            Object var13_15 = null;
            return object;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(224, "Failed to create contents publish task!", exception);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                throw throwable;
            }
        }
    }

    public PublishTask createDestroyPublishTask(IPublishElements iPublishElements, IPublishFolder iPublishFolder, IPublishElements iPublishElements2) throws WCMException {
        if (iPublishElements == null || iPublishElements.isEmpty()) {
            return null;
        }
        if (iPublishFolder == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string = PublishConstants.getPublishTypeName(7, "[unknown publish type PUBLISH_RECALL]");
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string).append(": ");
            for (int i = 0; i < iPublishElements.size(); ++i) {
                object2 = iPublishElements.get(i);
                if (object2 == null) continue;
                if (i > 0) {
                    stringBuffer.append(',');
                    stringBuffer2.append(',');
                } else {
                    n = object2.getSubstance().getWCMType();
                }
                stringBuffer.append(object2.getSubstance().getId());
                stringBuffer2.append(object2.getInfo());
            }
            stringBuffer2.append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label4", " \u5728")).append(iPublishFolder.getInfo()).append(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label3", "\u4e2d"));
            String string2 = stringBuffer.toString();
            object2 = stringBuffer2.toString();
            String string3 = stringBuffer2.toString();
            StringBuffer stringBuffer3 = new StringBuffer();
            if (iPublishElements2 != null && !iPublishElements2.isEmpty()) {
                for (int i = 0; i < iPublishElements2.size(); ++i) {
                    object = iPublishElements2.get(i);
                    if (object == null) continue;
                    if (i > 0) {
                        stringBuffer3.append(',');
                    }
                    stringBuffer3.append(object.getSubstance().getId());
                }
            }
            String string4 = stringBuffer3.toString();
            Object object3 = object = this.createPublishTask(iPublishFolder, n, string2, 7, (String)object2, string3, 9, string4);
            Object var16_18 = null;
            return object3;
        }
        catch (Exception exception) {
            try {
                throw new WCMException(224, "Failed to create contents publish task!", exception);
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int sqlExecuteIntQuery(String string, Object[] objectArray) throws WCMException {
        Connection connection;
        DBManager dBManager;
        int n;
        block16: {
            Exception exception2222;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block15: {
                n = -999;
                dBManager = DBManager.getDBManager();
                connection = dBManager.getConnection();
                preparedStatement = null;
                resultSet = null;
                preparedStatement = connection.prepareStatement(string);
                for (int i = 0; i < objectArray.length; ++i) {
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
                preparedStatement.setMaxRows(1);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                Object var10_10 = null;
                if (resultSet == null) break block15;
                try {
                    resultSet.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                    break block16;
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
                {
                }
            }
            break block16;
            {
                catch (Exception exception3) {
                    throw new WCMException(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label6", "\u66f4\u65b0DocStatus\u5931\u8d25\uff01"), exception3);
                }
            }
            catch (Throwable throwable) {
                Exception exception42222;
                Object var10_11 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception42222) {
                        // empty catch block
                    }
                }
                dBManager.freeConnection(connection);
                throw throwable;
            }
        }
        dBManager.freeConnection(connection);
        return n;
    }

    public PublishTask createDeleteContentsSynPublishTask(IPublishFolder iPublishFolder, IPublishElements iPublishElements) throws WCMException {
        int n = 12;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(iPublishElements.size() * 7);
        for (int i = 0; i < iPublishElements.size(); ++i) {
            IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
            n2 = iPublishContent.getType();
            stringBuffer.append(iPublishContent.getId());
            stringBuffer.append(",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        String string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]");
        String string2 = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{iPublishFolder.getInfo(), string});
        return this.createPublishTask(iPublishFolder, n2, stringBuffer.toString(), n, string2, string2, 9, null);
    }

    public PublishTask createDeleteContentsSynPublishTask(IPublishFolder iPublishFolder, IPublishContent iPublishContent) throws WCMException {
        int n = 12;
        String string = PublishConstants.getPublishTypeName(n, "[unknown publish type " + n + "]");
        String string2 = CMyString.format(I18NMessage.get(PublishTaskMgrImpl.class, "PublishTaskMgrImpl.label7", "{0}\u7684{1}"), new String[]{iPublishFolder.getInfo(), string});
        return this.createPublishTask(iPublishFolder, iPublishContent.getType(), String.valueOf(iPublishContent.getId()).toString(), n, string2, string2, 9, null);
    }
}

