/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.taskdispatch.BatchDetailPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.PageDestoryTask;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.SinglePageTask;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;
import org.aton.container.IQueue;
import org.aton.container.QueueLinkImpl;

public class PublishTaskAnalyzer
implements IClearable {
    private boolean m_bTaskElementIsRoot = false;
    private static final Logger logger = Logger.getLogger((String)PublishTaskAnalyzer.class.getName());
    public static int RUN_INTERVAL = 100;
    private boolean m_bNewPublishRootModal = false;
    private IPublishFolder m_folder = null;
    private IQueue m_detailPageTaskQueue;
    private BatchDetailPageTask m_currBatchDetailPageTask = null;
    private IQueue m_outlinePageTaskQueue;
    private int m_nPageTaskCount = 0;
    private int m_nDetailPageTaskCount = 0;
    private boolean m_bCanceled = false;
    private Map m_hmExistsOutlineTask = null;
    private String m_sErrors = null;
    private PublishTaskWorker m_oTaskWorker;
    private boolean m_bIsDebugEnabled = logger.isDebugEnabled();

    public PublishTaskAnalyzer() {
        this.m_detailPageTaskQueue = new QueueLinkImpl();
        this.m_outlinePageTaskQueue = new QueueLinkImpl();
        this.m_hmExistsOutlineTask = new HashMap();
    }

    public IPublishFolder getFolder() {
        return this.m_folder;
    }

    public int getPageTaskCount() {
        return this.m_nPageTaskCount;
    }

    public int getWaitingPageTaskCount() {
        return this.m_outlinePageTaskQueue.size() + this.m_detailPageTaskQueue.size();
    }

    void setTaskWorker(PublishTaskWorker publishTaskWorker) {
        this.m_oTaskWorker = publishTaskWorker;
    }

    public boolean isCanceld() {
        return this.m_bCanceled;
    }

    public String getErrors() {
        return this.m_sErrors;
    }

    public void clear() {
        if (this.m_folder != null) {
            this.m_folder = null;
        }
        if (this.m_nPageTaskCount > 0) {
            this.m_detailPageTaskQueue.clear();
            if (this.m_currBatchDetailPageTask != null) {
                this.m_currBatchDetailPageTask.clear();
                this.m_currBatchDetailPageTask = null;
            }
            this.m_outlinePageTaskQueue.clear();
            this.m_nPageTaskCount = 0;
            this.m_nDetailPageTaskCount = 0;
        }
        if (this.m_bCanceled) {
            this.m_bCanceled = false;
        }
        if (this.m_sErrors != null) {
            this.m_sErrors = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        logger.info((Object)"cancle the analyzer...");
        PublishTaskAnalyzer publishTaskAnalyzer = this;
        synchronized (publishTaskAnalyzer) {
            this.m_bCanceled = true;
            this.notifyAll();
        }
        publishTaskAnalyzer = this.m_detailPageTaskQueue;
        synchronized (publishTaskAnalyzer) {
            this.m_detailPageTaskQueue.notifyAll();
        }
        publishTaskAnalyzer = this.m_outlinePageTaskQueue;
        synchronized (publishTaskAnalyzer) {
            this.m_outlinePageTaskQueue.notifyAll();
        }
    }

    public void start(PublishTask publishTask) throws Exception {
        this.clear();
        int n = publishTask.getFolderType();
        int n2 = publishTask.getFolderId();
        this.m_folder = (IPublishFolder)PublishElementFactory.lookupElement(n, n2);
        if (this.m_folder == null) {
            throw new WCMException(200006, "Publish folder is not found: Type=" + n + ", Id=" + n2);
        }
        this.m_bTaskElementIsRoot = this.m_folder.isRoot();
        logger.debug((Object)("to analyze publish task [" + publishTask.getId() + "]: " + publishTask.getTitle()));
        switch (publishTask.getPublishType()) {
            case 1: {
                this.analyzeFolderIncreasingPublishTask();
                if (!this.m_folder.isRoot()) break;
                logger.info((Object)(this.m_folder.getInfo() + " Anallyze End!"));
                break;
            }
            case 2: {
                if (this.m_folder.isRoot()) {
                    this.analyzeRootFullyPublishTask();
                    break;
                }
                this.analyzeFolderFullyPublishTask();
                break;
            }
            case 5: 
            case 12: {
                this.analyzeFolderRefreshPublishTask();
                break;
            }
            case 3: {
                this.analyzeContentPublishTask(publishTask);
                break;
            }
            case 8: {
                if (publishTask.isPublishContent()) {
                    this.analyzeContentSelfPublishTask(publishTask);
                    break;
                }
                this.analyzeFolderSelfPublishTask();
                break;
            }
            case 7: {
                if (publishTask.isPublishContent()) {
                    this.addDetoryPagesTask(publishTask);
                    break;
                }
                this.addDetoryFolderTask(publishTask.getFolder());
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.analyzeContentDirectTask(publishTask);
                break;
            }
            case 13: {
                this.analyzePublishedContentPublishTask(publishTask);
                break;
            }
            default: {
                throw new WCMException(228, "Unknonw publish type: " + publishTask.getPublishType());
            }
        }
        if (this.m_bIsDebugEnabled) {
            logger.debug((Object)("Finish analyzing:" + this.m_nPageTaskCount + " page tasks have been created for publish task[" + publishTask.getId() + "]: " + publishTask.getTitle()));
        }
    }

    private synchronized IPageTask nextDetailTask() {
        if (this.m_bCanceled) {
            return null;
        }
        IPageTask iPageTask = null;
        if (this.m_currBatchDetailPageTask != null) {
            try {
                iPageTask = this.m_currBatchDetailPageTask.getNext();
            }
            catch (Exception exception) {
                this.m_bCanceled = true;
                if (this.m_oTaskWorker != null) {
                    this.m_oTaskWorker.analyzerCanceled();
                }
                this.m_sErrors = CMyException.getStackTraceText(exception);
                this.m_currBatchDetailPageTask.clear();
                this.m_currBatchDetailPageTask = null;
                return null;
            }
            if (iPageTask == null) {
                this.m_currBatchDetailPageTask.clear();
                this.m_currBatchDetailPageTask = null;
                --this.m_nDetailPageTaskCount;
            } else {
                ++this.m_nDetailPageTaskCount;
                return iPageTask;
            }
        }
        if (this.m_bCanceled) {
            return null;
        }
        iPageTask = (IPageTask)this.m_detailPageTaskQueue.pop();
        if (iPageTask != null) {
            if (iPageTask.isBatch()) {
                this.m_currBatchDetailPageTask = (BatchDetailPageTask)iPageTask;
                return this.nextDetailTask();
            }
            return this.m_bCanceled ? null : iPageTask;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPageTask getNextPageTask() {
        IPageTask iPageTask = this.nextDetailTask();
        if (iPageTask != null) {
            return iPageTask;
        }
        if (this.m_bCanceled) {
            return null;
        }
        while (this.m_nDetailPageTaskCount > 0 && !this.m_bCanceled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("to wait for all detail pages to be generated: left=" + this.m_nDetailPageTaskCount));
            }
            PublishTaskAnalyzer publishTaskAnalyzer = this;
            synchronized (publishTaskAnalyzer) {
                if (this.m_nDetailPageTaskCount > 0 && !this.m_bCanceled) {
                    try {
                        this.wait(400L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.m_bCanceled ? null : (IPageTask)this.m_outlinePageTaskQueue.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPageTaskFinished(IPageTask iPageTask) {
        if (!iPageTask.getPublishElement().isFolder()) {
            PublishTaskAnalyzer publishTaskAnalyzer = this;
            synchronized (publishTaskAnalyzer) {
                --this.m_nDetailPageTaskCount;
                if (this.m_nDetailPageTaskCount <= 0) {
                    logger.debug((Object)"all detail page tasks have finished; to notify all...");
                    this.notifyAll();
                }
            }
            logger.debug((Object)("DetailPageTask left: " + this.m_nDetailPageTaskCount));
        }
    }

    private void analyzeFolderIncreasingPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label2", "]\u7684\u589e\u91cf\u53d1\u5e03..."));
        IPublishElements iPublishElements = null;
        try {
            this.addBatchDetailPageTask(this.m_folder, false);
            IPublishElements iPublishElements2 = this.m_folder.getChildren();
            for (int i = 0; i < iPublishElements2.size(); ++i) {
                IPublishFolder iPublishFolder = this.m_folder;
                this.m_folder = (IPublishFolder)iPublishElements2.get(i);
                this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label3", "\u5f00\u59cb\u5206\u89e3\u5b50\u8282\u70b9[") + this.m_folder.getInfo() + "]");
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzeFolderIncreasingPublishTask();
                }
                this.m_folder = iPublishFolder;
            }
        }
        catch (Exception exception) {
            throw new WCMException(229, "Failed to anaylze the increased contents and children publish tasks!", exception);
        }
        finally {
            if (iPublishElements != null) {
                iPublishElements.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label4", "]\u7684\u589e\u91cf\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private void analyzeRootFullyPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label5", "]\u7684\u5b8c\u5168\u53d1\u5e03"));
        if (this.m_bNewPublishRootModal && this.m_folder.canDoBatchDetailPageTask()) {
            BatchDetailPageTask batchDetailPageTask = new BatchDetailPageTask(this.m_folder, true, 2);
            this.m_detailPageTaskQueue.push((Object)batchDetailPageTask);
            ++this.m_nDetailPageTaskCount;
            ++this.m_nPageTaskCount;
        }
        this.putChildrenToOutlinePageTask(this.m_folder);
    }

    private void putChildrenToOutlinePageTask(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            return;
        }
        if (!this.m_bNewPublishRootModal) {
            this.addBatchDetailPageTask(iPublishFolder, true);
        }
        if (!this.isStorageFolder(iPublishFolder)) {
            return;
        }
        IPublishElements iPublishElements = iPublishFolder.getChildren();
        if (iPublishElements == null) {
            return;
        }
        for (int i = 0; i < iPublishElements.size(); ++i) {
            IPublishFolder iPublishFolder2 = (IPublishFolder)iPublishElements.get(i);
            if (iPublishFolder2 == null) continue;
            this.putChildrenToOutlinePageTask(iPublishFolder2);
        }
        if (iPublishFolder.isValidElement()) {
            this.addOutlinePageTask(iPublishFolder);
        }
    }

    private void analyzeFolderFullyPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label5", "]\u7684\u5b8c\u5168\u53d1\u5e03"));
        IPublishElements iPublishElements = null;
        try {
            this.addBatchDetailPageTask(this.m_folder, true);
            IPublishElements iPublishElements2 = this.m_folder.getChildren();
            int n = iPublishElements2 == null ? 0 : iPublishElements2.size();
            for (int i = 0; i < n; ++i) {
                IPublishFolder iPublishFolder = this.m_folder;
                this.m_folder = (IPublishFolder)iPublishElements2.get(i);
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzeFolderFullyPublishTask();
                }
                this.m_folder = iPublishFolder;
            }
        }
        catch (Exception exception) {
            throw new WCMException(229, "Failed to anaylze the contents and children publish task for all the contents.", exception);
        }
        finally {
            if (iPublishElements != null) {
                iPublishElements.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
    }

    private void analyzeFolderRefreshPublishTask() throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label6", "]\u7684\u66f4\u65b0\u53d1\u5e03..."));
        if (!this.m_folder.isValidElement()) {
            this.log2Monitor("[" + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label7", "]\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u53d1\u5e03\uff01"));
            return;
        }
        this.addOutlinePageTask(this.m_folder);
        if (this.m_bTaskElementIsRoot) {
            this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label8", "\u5206\u89e3R[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label9", "]\u7684\u66f4\u65b0\u53d1\u5e03\u7ed3\u675f\uff01"));
            return;
        }
        Collection collection = null;
        try {
            collection = this.m_folder.getFoldersQuotingMe();
            if (collection != null && !collection.isEmpty()) {
                for (IPublishFolder iPublishFolder : collection) {
                    if (iPublishFolder == null || !iPublishFolder.isValidElement()) continue;
                    this.addOutlinePageTask(iPublishFolder);
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(222, "Failed to analyze the outline page taks for the quoting folders.", exception);
        }
        finally {
            if (collection != null) {
                collection.clear();
            }
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label9", "]\u7684\u66f4\u65b0\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private void analyzeFolderSelfPublishTask() throws Exception {
        this.addOutlinePageTask(this.m_folder);
    }

    private void analyzeContentPublishTask(PublishTask publishTask) throws Exception {
        this.analyzeContentSelfPublishTask(publishTask);
        this.analyzeFolderRefreshPublishTask();
    }

    private void analyzeContentSelfPublishTask(PublishTask publishTask) throws Exception {
        IPublishElements iPublishElements = PublishElementFactory.lookupElements(publishTask.getContentType(), publishTask.getContentIds());
        if (this.m_folder != null) {
            int n = iPublishElements.size();
            for (int i = 0; i < n; ++i) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
                if (iPublishContent == null) continue;
                iPublishContent.setFolder(this.m_folder);
            }
        }
        this.addDetailPageTasks(iPublishElements);
    }

    private SinglePageTask addDetailPageTask(IPublishContent iPublishContent) {
        if (iPublishContent.getFolder() == null) {
            iPublishContent.setFolder(this.m_folder);
        }
        SinglePageTask singlePageTask = new SinglePageTask(iPublishContent);
        this.m_detailPageTaskQueue.push((Object)singlePageTask);
        ++this.m_nDetailPageTaskCount;
        ++this.m_nPageTaskCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("A page task is created: " + singlePageTask.getInfo()));
        }
        return singlePageTask;
    }

    private BatchDetailPageTask addBatchDetailPageTask(IPublishFolder iPublishFolder, boolean bl) {
        if (!iPublishFolder.canDoBatchDetailPageTask()) {
            return null;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + iPublishFolder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label11", "]\u7684\u6279\u91cf\u7ec6\u89c8\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\uff0c\u5b8c\u5168=") + bl);
        BatchDetailPageTask batchDetailPageTask = new BatchDetailPageTask(iPublishFolder, bl);
        this.m_detailPageTaskQueue.push((Object)batchDetailPageTask);
        ++this.m_nDetailPageTaskCount;
        ++this.m_nPageTaskCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("A page task is created: " + batchDetailPageTask.getInfo()));
        }
        return batchDetailPageTask;
    }

    private void addBatchDetailPageForPublishedContentsTask(IPublishFolder iPublishFolder, boolean bl, PublishTask publishTask) throws Exception {
        Object object;
        if (!iPublishFolder.canDoBatchDetailPageTask()) {
            return;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + iPublishFolder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label11", "]\u7684\u6279\u91cf\u7ec6\u89c8\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\uff0c\u5b8c\u5168=") + bl + ",\u53ea\u53d1\u5e03\u5df2\u53d1\u7684\u6587\u6863");
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        String string = publishTask.getAttributeValue("StartDocCrtime");
        String string2 = publishTask.getAttributeValue("EndDocCrtime");
        String string3 = "";
        if (!CMyString.isEmpty(string)) {
            object = new CMyDateTime();
            ((CMyDateTime)object).setDateTimeWithString(string);
            string3 = string3 + "WCMCHNLDOC.CRTIME >= ?";
            wCMFilter.addSearchValues((CMyDateTime)object);
        }
        if (!CMyString.isEmpty(string2)) {
            object = new CMyDateTime();
            ((CMyDateTime)object).setDateTimeWithString(string2);
            string3 = CMyString.isEmpty(string3) ? string3 + "WCMCHNLDOC.CRTIME <= ?" : string3 + " AND WCMCHNLDOC.CRTIME <= ?";
            wCMFilter.addSearchValues((CMyDateTime)object);
        }
        wCMFilter.setWhere(string3);
        object = iPublishFolder.getPublishedContents(wCMFilter);
        if (object == null) {
            return;
        }
        if (this.m_folder != null) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                IPublishContent iPublishContent = (IPublishContent)object.get(i);
                if (iPublishContent == null) continue;
                iPublishContent.setFolder(this.m_folder);
            }
        }
        this.addDetailPageTasks((IPublishElements)object);
    }

    private SinglePageTask addOutlinePageTask(IPublishFolder iPublishFolder) {
        if (this.isExistsOutlinePageTask(iPublishFolder)) {
            return null;
        }
        if (!iPublishFolder.canDoOutlinePageTask()) {
            return null;
        }
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + iPublishFolder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label12", "]\u7684\u6982\u89c8\u9875\u9762\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217..."));
        SinglePageTask singlePageTask = new SinglePageTask(iPublishFolder);
        this.m_outlinePageTaskQueue.push((Object)singlePageTask);
        ++this.m_nPageTaskCount;
        this.m_hmExistsOutlineTask.put(this.makeFolderKey(iPublishFolder), "");
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label10", "\u6dfb\u52a0[") + iPublishFolder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label13", "]\u7684\u6982\u89c8\u9875\u9762\u53d1\u5e03\u4efb\u52a1\u5230\u961f\u5217\u7ed3\u675f!"));
        logger.debug((Object)("A page task is created: " + singlePageTask.getInfo()));
        return singlePageTask;
    }

    private void addDetoryFolderTask(IPublishFolder iPublishFolder) {
        if (iPublishFolder == null) {
            return;
        }
        PageDestoryTask pageDestoryTask = new PageDestoryTask(iPublishFolder);
        this.m_outlinePageTaskQueue.push((Object)pageDestoryTask);
        ++this.m_nPageTaskCount;
    }

    private void addDetoryPagesTask(PublishTask publishTask) throws Exception {
        this.analyzeFolderRefreshPublishTask();
        IPublishElements iPublishElements = publishTask.getFolders();
        if (iPublishElements != null) {
            IPublishFolder iPublishFolder = this.m_folder;
            for (int i = iPublishElements.size() - 1; i >= 0; --i) {
                IPublishElement iPublishElement = iPublishElements.get(i);
                if (iPublishElement == null) continue;
                this.m_folder = (IPublishFolder)iPublishElement;
                this.analyzeFolderRefreshPublishTask();
            }
            this.m_folder = iPublishFolder;
        }
    }

    private void addDetailPageTasks(IPublishElements iPublishElements) throws Exception {
        if (iPublishElements == null || iPublishElements.isEmpty()) {
            return;
        }
        for (int i = 0; i < iPublishElements.size(); ++i) {
            IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
            this.addDetailPageTask(iPublishContent);
        }
    }

    private boolean isExistsOutlinePageTask(IPublishFolder iPublishFolder) {
        return this.m_hmExistsOutlineTask.containsKey(this.makeFolderKey(iPublishFolder));
    }

    private Object makeFolderKey(IPublishElement iPublishElement) {
        return iPublishElement.getType() + "_" + iPublishElement.getId();
    }

    private boolean isStorageFolder(IPublishFolder iPublishFolder) {
        try {
            String string;
            FolderPublishConfig folderPublishConfig = FolderPublishConfig.findOf(iPublishFolder);
            if (folderPublishConfig != null && (string = folderPublishConfig.getDataPath()) != null && string.length() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void log2Monitor(String string) {
        if (this.m_oTaskWorker != null) {
            this.m_oTaskWorker.log2Monitor(string);
        }
    }

    private void analyzeContentDirectTask(PublishTask publishTask) throws Exception {
        int n;
        Object object;
        IPublishElements iPublishElements = publishTask.getContents();
        if (iPublishElements.isEmpty()) {
            return;
        }
        IPublishElements iPublishElements2 = null;
        IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(0);
        if (iPublishContent.getType() == 605) {
            object = new HashMap();
            int n2 = iPublishElements.size();
            for (n = 0; n < n2; ++n) {
                Object object2;
                IPublishFolder iPublishFolder;
                int n3;
                iPublishContent = (IPublishContent)iPublishElements.get(n);
                IPublishElements iPublishElements3 = this.makeFoldersUseContent(iPublishContent);
                if (iPublishElements2 == null) {
                    iPublishElements2 = iPublishElements3;
                } else {
                    for (n3 = iPublishElements3.size() - 1; n3 >= 0; --n3) {
                        iPublishFolder = (IPublishFolder)iPublishElements3.get(n3);
                        object2 = iPublishFolder.getSubstance().getKey();
                        if (((HashMap)object).containsKey(object2)) continue;
                        ((HashMap)object).put(object2, "");
                        iPublishElements2.add(iPublishFolder);
                    }
                }
                for (n3 = iPublishElements2.size() - 1; n3 >= 0; --n3) {
                    iPublishFolder = (IPublishFolder)iPublishElements2.get(n3);
                    object2 = PublishElementFactory.makeContentFrom(iPublishContent.getSubstance(), iPublishFolder);
                    if (object2.getModal() != 3) continue;
                    iPublishElements.add(object2);
                }
            }
        } else {
            iPublishElements2 = new PublishElementsListImpl();
            iPublishElements2.add(iPublishContent.getOriginalHome());
        }
        this.addDetailPageTasks(iPublishElements);
        object = this.m_folder;
        for (n = iPublishElements2.size() - 1; n >= 0; --n) {
            IPublishElement iPublishElement = iPublishElements2.get(n);
            if (iPublishElement == null) continue;
            this.m_folder = (IPublishFolder)iPublishElement;
            this.analyzeFolderRefreshPublishTask();
        }
        this.m_folder = object;
    }

    private void analyzePublishedContentPublishTask(PublishTask publishTask) throws Exception {
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label2", "]\u7684\u589e\u91cf\u53d1\u5e03..."));
        IPublishElements iPublishElements = null;
        try {
            this.addBatchDetailPageForPublishedContentsTask(this.m_folder, false, publishTask);
            IPublishElements iPublishElements2 = this.m_folder.getChildren();
            for (int i = 0; i < iPublishElements2.size(); ++i) {
                IPublishFolder iPublishFolder = this.m_folder;
                this.m_folder = (IPublishFolder)iPublishElements2.get(i);
                this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label3", "\u5f00\u59cb\u5206\u89e3\u5b50\u8282\u70b9[") + this.m_folder.getInfo() + "]");
                if (this.m_folder != null && this.m_folder.getDataPath() != null && this.m_folder.getDataPath().length() > 0) {
                    this.analyzePublishedContentPublishTask(publishTask);
                }
                this.m_folder = iPublishFolder;
            }
        }
        catch (Exception exception) {
            throw new WCMException(229, "Failed to anaylze the increased contents and children publish tasks!", exception);
        }
        finally {
            if (iPublishElements != null) {
                iPublishElements.clear();
            }
        }
        this.analyzeFolderRefreshPublishTask();
        this.log2Monitor(I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label1", "\u5206\u89e3[") + this.m_folder.getInfo() + I18NMessage.get(PublishTaskAnalyzer.class, "PublishTaskAnalyzer.label4", "]\u7684\u589e\u91cf\u53d1\u5e03\u7ed3\u675f\uff01"));
    }

    private IPublishElements makeFoldersUseContent(IPublishContent iPublishContent) throws WCMException, Exception {
        PublishElementsListImpl publishElementsListImpl = new PublishElementsListImpl();
        Document document = (Document)iPublishContent.getSubstance();
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Channels channels = documentMgr.getChannels(document, 0, null);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            IPublishFolder iPublishFolder;
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !(iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel)).canDoOutlinePageTask()) continue;
            publishElementsListImpl.add(iPublishFolder);
        }
        return publishElementsListImpl;
    }
}

