/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.IConfigElement;
import org.apache.log4j.Logger;

public class LaborResourceMgrImpl
implements ILaborResourceMgr {
    private static Logger logger = Logger.getLogger((String)LaborResourceMgrImpl.class.getName());
    private int m_nHighPriorityLaborsMax = 10;
    private int m_nLowPriorityLaborsMax = 10;
    private int m_nEachTaskLaborsMax = 10;
    private int m_nHighPriorityLaborsUsed = 0;
    private int m_nLowPriorityLaborsUsed = 0;

    public synchronized void clear() {
        this.m_nHighPriorityLaborsUsed = 0;
        this.m_nLowPriorityLaborsUsed = 0;
        this.notifyAll();
    }

    public void configure(IConfigElement iConfigElement) throws Exception {
        if (iConfigElement == null) {
            return;
        }
        LaborResourceConfig laborResourceConfig = (LaborResourceConfig)iConfigElement;
        try {
            logger.debug((Object)"to configure labor resource ...");
            this.m_nHighPriorityLaborsMax = laborResourceConfig.getHighPriorityLaborsMax();
            this.m_nLowPriorityLaborsMax = laborResourceConfig.getLowPriorityLaborsMax();
            this.m_nEachTaskLaborsMax = laborResourceConfig.getEachTaskLaborsMax();
        }
        catch (Exception exception) {
            throw new WCMException(12, "Failed to configure the labor resource manager!", exception);
        }
    }

    public int calMaxLaborNeeded(int n, int n2) {
        if (n <= this.m_nEachTaskLaborsMax) {
            return n / 2 + 1;
        }
        return n / (n / this.m_nEachTaskLaborsMax + 1);
    }

    public synchronized boolean hasFreeLabor(int n) {
        return this.inventoryLeft(n) > 0;
    }

    private int inventoryLeft(int n) {
        if (n < 5 && this.m_nHighPriorityLaborsUsed < this.m_nHighPriorityLaborsMax) {
            return this.m_nLowPriorityLaborsMax - this.m_nLowPriorityLaborsUsed;
        }
        return this.m_nLowPriorityLaborsMax + this.m_nHighPriorityLaborsMax - this.m_nHighPriorityLaborsUsed - this.m_nLowPriorityLaborsUsed;
    }

    public synchronized int applyForLabor(int n, int n2) {
        int n3;
        int n4 = this.inventoryLeft(n2);
        if (n4 <= 0) {
            return 0;
        }
        int n5 = n3 = n4 >= n ? n : n4;
        if (n2 < 5) {
            this.m_nLowPriorityLaborsUsed += n3;
        } else {
            this.m_nHighPriorityLaborsUsed += n3;
        }
        logger.debug((Object)("MaxNeed=" + n + "; Priority=" + n2 + "; Applied=" + n3));
        return n3;
    }

    public synchronized void releaseLabor(int n, int n2) {
        if (n2 < 5) {
            this.m_nLowPriorityLaborsUsed -= n;
            if (this.m_nLowPriorityLaborsUsed < 0) {
                this.m_nLowPriorityLaborsUsed = 0;
            }
        } else {
            this.m_nHighPriorityLaborsUsed -= n;
            if (this.m_nHighPriorityLaborsUsed < 0) {
                this.m_nHighPriorityLaborsUsed = 0;
            }
        }
        this.notifyAll();
        logger.debug((Object)("Priority=" + n2 + "; Count=" + n));
    }
}

