/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.domain.taskdispatch.SinglePageTask;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class BatchDetailPageTask
implements IPageTask,
IClearable {
    private static Logger logger = Logger.getLogger(BatchDetailPageTask.class);
    private IPublishFolder m_folder;
    private boolean m_bPublishAll;
    private int m_nPublishType = 0;
    private IPublishElementsIterator m_itContents = null;
    private IPublishElements m_contents = null;
    private int m_nCurrPos = -1;
    private int m_nLoadBatchContentsModal = 1;
    private int m_nLoadBatchContentsPageSize = 100;

    public BatchDetailPageTask(IPublishFolder iPublishFolder, boolean bl) {
        try {
            this.m_nLoadBatchContentsModal = PublishServerConfigMapper.getLoadBatchContentsModal();
            this.m_nLoadBatchContentsPageSize = PublishServerConfigMapper.getLoadBatchContentsPageSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_folder = iPublishFolder;
        this.m_bPublishAll = bl;
    }

    public BatchDetailPageTask(IPublishFolder iPublishFolder, boolean bl, int n) {
        try {
            this.m_nLoadBatchContentsModal = n;
            this.m_nLoadBatchContentsPageSize = PublishServerConfigMapper.getLoadBatchContentsPageSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_folder = iPublishFolder;
        this.m_bPublishAll = bl;
    }

    public String getInfo() {
        return "batch detail page task to publish " + (this.m_bPublishAll ? "full" : "increasing") + " contents in " + this.m_folder.getInfo();
    }

    public boolean isBatch() {
        return true;
    }

    public void clear() {
        if (this.m_itContents != null) {
            this.m_itContents.clear();
            this.m_itContents = null;
        }
        if (this.m_contents != null) {
            this.m_contents.clear();
            this.m_contents = null;
        }
        if (this.m_nCurrPos < 0) {
            return;
        }
        this.m_nCurrPos = -1;
    }

    public SinglePageTask getNext() throws WCMException {
        switch (this.m_nLoadBatchContentsModal) {
            case 2: {
                return this.getNextFromIterator();
            }
        }
        return this.getNextFromObjects();
    }

    public IPublishElement getPublishElement() {
        return this.m_folder;
    }

    public void setPublishElement(IPublishElement iPublishElement) {
        this.m_folder = (IPublishFolder)iPublishElement;
    }

    private void insureContentsLoadedByObjects() throws Exception {
        if (this.m_nCurrPos >= 0) {
            return;
        }
        DebugTimer debugTimer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            debugTimer.start();
        }
        WCMFilter wCMFilter = new WCMFilter();
        wCMFilter.setPageSize(this.m_nLoadBatchContentsPageSize);
        this.m_contents = this.m_bPublishAll ? this.m_folder.getAllContents(wCMFilter) : (this.m_nPublishType == 13 ? this.m_folder.getPublishedContents(wCMFilter) : this.m_folder.getIncreasedContents(wCMFilter));
        this.m_nCurrPos = 0;
        if (logger.isDebugEnabled()) {
            debugTimer.stop();
            logger.debug((Object)("load " + this.m_folder.getInfo() + " by objects use [" + debugTimer.getTime() + "]ms."));
        }
    }

    private SinglePageTask getNextFromObjects() throws WCMException {
        try {
            this.insureContentsLoadedByObjects();
            DebugTimer debugTimer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                debugTimer.start();
            }
            if (this.m_contents == null || this.m_nCurrPos >= this.m_contents.size()) {
                return null;
            }
            IPublishContent iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int n = this.m_contents.size();
            while (iPublishContent == null && this.m_nCurrPos < n) {
                iPublishContent = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            }
            if (logger.isDebugEnabled()) {
                debugTimer.stop();
                if (debugTimer.getTime() > 30L) {
                    logger.debug((Object)("get next content of " + this.m_folder.getInfo() + " from objects  use [" + debugTimer.getTime() + "]ms."));
                }
            }
            if (iPublishContent == null) {
                return null;
            }
            iPublishContent.setFolder(this.m_folder);
            return new SinglePageTask(iPublishContent);
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the next page task to execute!", exception);
        }
    }

    private void insureContentsLoadedByIterator() throws Exception {
        if (this.m_itContents != null) {
            return;
        }
        DebugTimer debugTimer = new DebugTimer();
        if (logger.isDebugEnabled()) {
            debugTimer.start();
        }
        this.m_itContents = this.m_bPublishAll ? this.m_folder.getAllContentsIterator(null) : (this.m_nPublishType == 13 ? this.m_folder.getPublishedContentsIterator(null) : this.m_folder.getIncreasedContentsIterator(null));
        if (logger.isDebugEnabled()) {
            debugTimer.stop();
            logger.debug((Object)("load " + this.m_folder.getInfo() + " by iterator  use [" + debugTimer.getTime() + "]ms."));
        }
    }

    private SinglePageTask getNextFromIterator() throws WCMException {
        try {
            this.insureContentsLoadedByIterator();
            DebugTimer debugTimer = new DebugTimer();
            if (logger.isDebugEnabled()) {
                debugTimer.start();
            }
            if (this.m_itContents == null || !this.m_itContents.hasNext()) {
                return null;
            }
            IPublishContent iPublishContent = (IPublishContent)this.m_itContents.next();
            while (iPublishContent == null && this.m_itContents.hasNext()) {
                iPublishContent = (IPublishContent)this.m_itContents.next();
            }
            if (logger.isDebugEnabled()) {
                debugTimer.stop();
                if (debugTimer.getTime() > 30L) {
                    logger.debug((Object)("get next content of " + this.m_folder.getInfo() + " from iterator  use [" + debugTimer.getTime() + "]ms."));
                }
            }
            if (iPublishContent == null) {
                return null;
            }
            if (iPublishContent.getFolder() == null) {
                if (this.m_folder.isRoot()) {
                    iPublishContent.setFolder(iPublishContent.getOriginalHome());
                } else {
                    iPublishContent.setFolder(this.m_folder);
                }
            }
            return new SinglePageTask(iPublishContent);
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the next page task to execute!", exception);
        }
    }

    void setPublishType(int n) {
        this.m_nPublishType = n;
    }
}

