/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TemplateParameterList {
    private HashMap m_oNameMaps;
    private ArrayList m_oParaList;
    private ArrayList m_oBatchList;
    private boolean m_zNestParsed;

    public TemplateParameterList() {
        this(false);
    }

    public TemplateParameterList(boolean bl) {
        if (bl) {
            this.m_oNameMaps = null;
            this.m_oParaList = null;
            this.m_oBatchList = new ArrayList();
        } else {
            this.m_oNameMaps = new HashMap();
            this.m_oParaList = new ArrayList();
            this.m_oBatchList = null;
        }
    }

    public HashMap getNameMaps() {
        return this.m_oNameMaps;
    }

    public TemplateParameter getParameter(String string) {
        if (this.m_oNameMaps != null && string != null) {
            return (TemplateParameter)this.m_oNameMaps.get(string);
        }
        return null;
    }

    public synchronized void addParameter(TemplateParameter templateParameter) {
        if (this.m_oNameMaps == null) {
            throw new IllegalStateException("In batch mode.");
        }
        Object v = this.m_oNameMaps.get(templateParameter.getParameterName());
        if (v != null) {
            templateParameter.setPreDeclared((TemplateParameter)v);
            return;
        }
        this.m_oNameMaps.put(templateParameter.getParameterName(), templateParameter);
        this.m_oParaList.add(templateParameter);
    }

    public synchronized void addParameterList(TemplateParameterList templateParameterList) {
        if (this.m_oBatchList == null) {
            throw new IllegalStateException("Not in batch mode.");
        }
        if (templateParameterList != null) {
            this.m_oBatchList.add(templateParameterList);
        }
    }

    public Iterator parameters() {
        if (this.m_oParaList != null) {
            return this.m_oParaList.iterator();
        }
        Iterator iterator = new Iterator(){
            Iterator m_oCurrList = null;
            int m_iCurrIndex = 0;
            Object m_oCurrObject = null;

            public boolean hasNext() {
                return this.m_oCurrObject != null || this.findNext();
            }

            public Object next() {
                if (this.m_oCurrObject != null || this.findNext()) {
                    Object object = this.m_oCurrObject;
                    this.m_oCurrObject = null;
                    return object;
                }
                return null;
            }

            private boolean findNext() {
                if (this.m_iCurrIndex == -1) {
                    return false;
                }
                if (this.m_oCurrList != null && this.m_oCurrList.hasNext()) {
                    this.m_oCurrObject = this.m_oCurrList.next();
                    return true;
                }
                TemplateParameterList templateParameterList = null;
                while (this.m_iCurrIndex < TemplateParameterList.this.m_oBatchList.size()) {
                    templateParameterList = (TemplateParameterList)TemplateParameterList.this.m_oBatchList.get(this.m_iCurrIndex++);
                    if (templateParameterList == null) continue;
                    this.m_oCurrList = templateParameterList.parameters();
                    return this.findNext();
                }
                this.m_iCurrIndex = -1;
                return false;
            }

            public void remove() {
            }
        };
        return iterator;
    }

    public int size() {
        if (this.m_oParaList != null) {
            return this.m_oParaList.size();
        }
        int n = 0;
        for (int i = 0; i < this.m_oBatchList.size(); ++i) {
            TemplateParameterList templateParameterList = (TemplateParameterList)this.m_oBatchList.get(i);
            if (templateParameterList == null) continue;
            n += templateParameterList.size();
        }
        return n;
    }

    public boolean getNestParsed() {
        return this.m_zNestParsed;
    }

    public void setNestParsed(boolean bl) {
        this.m_zNestParsed = bl;
    }
}

