/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.common.WCMException;
import java.util.LinkedList;
import java.util.List;

public class TemplateParameter {
    private static Type[] VALID_TYPES = new Type[]{Type.BOOLEAN, Type.INTEGER, Type.NUMBER, Type.STRING, Type.MULTI};
    private int m_iTemplateId;
    private String m_sTemplateName;
    private String m_sParameterName;
    private Type m_sParameterType;
    private String m_sParameterDefault;
    private String m_sParameterDefaultValue;
    private String m_sParameterDefaultDisplay;
    private List m_oEnumList;
    private Token[] m_sEnumValue;
    private char m_cEnumSplit = (char)96;
    private int m_iCustomFlag;
    private TemplateParameter m_oPreDeclared;

    public TemplateParameter() {
        this.setCanCustomDefault(true);
        this.m_sParameterType = Type.STRING;
    }

    public TemplateParameter getPreDeclared() {
        return this.m_oPreDeclared;
    }

    public void setPreDeclared(TemplateParameter templateParameter) {
        this.m_oPreDeclared = templateParameter;
    }

    public String getParameterName() {
        return this.m_sParameterName;
    }

    public void setParameterName(String string) {
        this.m_sParameterName = string;
    }

    public Type getParameterType() {
        return this.m_sParameterType;
    }

    public void setParameterType(Type type) {
        this.m_sParameterType = type;
    }

    public void setParameterType(String string) {
        if (string == null || string.length() <= 0) {
            this.setParameterType(Type.STRING);
            return;
        }
        string = string.toUpperCase();
        for (int i = VALID_TYPES.length - 1; i >= 0; --i) {
            Type type = VALID_TYPES[i];
            if (!string.equals(type.getName()) && !string.equals(type.getAlias())) continue;
            this.setParameterType(type);
            return;
        }
        this.setParameterType(Type.STRING);
    }

    public String getParameterDefault() {
        return this.m_sParameterDefault;
    }

    public String getParameterDefaultValue() {
        if (this.m_oPreDeclared != null) {
            return this.m_oPreDeclared.getParameterDefaultValue();
        }
        return this.m_sParameterDefaultValue;
    }

    public String getParameterDefaultDisplay() {
        return this.m_sParameterDefaultDisplay;
    }

    public void setParameterDefault(String string) {
        if (string != null) {
            int n = string.indexOf(this.m_cEnumSplit);
            if (n >= 0) {
                this.m_sParameterDefaultValue = string.substring(0, n);
                this.m_sParameterDefaultDisplay = string.substring(n + 1);
            } else {
                this.m_sParameterDefaultValue = string;
                this.m_sParameterDefaultDisplay = string;
            }
        } else {
            this.m_sParameterDefaultValue = null;
            this.m_sParameterDefaultDisplay = null;
        }
        this.m_sParameterDefault = string;
    }

    public Token[] getEnumValue() {
        if (this.m_sEnumValue == null && this.m_oEnumList != null && this.m_oEnumList.size() > 0) {
            Token[] tokenArray = new Token[this.m_oEnumList.size()];
            this.m_oEnumList.toArray(tokenArray);
            this.m_sEnumValue = tokenArray;
        }
        return this.m_sEnumValue;
    }

    public void addEnumValue(String string) {
        if (string != null) {
            int n = string.indexOf(this.m_cEnumSplit);
            if (n >= 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.addEnumValue(string2, string3);
            } else {
                this.addEnumValue(string, string);
            }
            this.m_sEnumValue = null;
        }
    }

    public void addEnumValue(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        if (this.m_oEnumList == null) {
            this.m_oEnumList = new LinkedList();
        }
        this.m_oEnumList.add(new Token(string, string2));
        this.setCanCustomDefault(false);
    }

    public String getEnumValueDisplay(String string) {
        if (string == null) {
            return null;
        }
        Token[] tokenArray = this.getEnumValue();
        if (tokenArray != null) {
            for (int i = tokenArray.length - 1; i >= 0; --i) {
                Token token = tokenArray[i];
                if (token == null || !string.equals(token.m_sValue) && (!string.equalsIgnoreCase(token.m_sValue) || !Type.BOOLEAN.getName().equals(this.m_sParameterType.getName()))) continue;
                return token.m_sDisplay;
            }
        }
        return string;
    }

    public char getEnumSplit() {
        return this.m_cEnumSplit;
    }

    public void setEnumSplit(char c) {
        this.m_cEnumSplit = c;
    }

    public boolean getCanCustom() {
        return this.m_iCustomFlag != 0;
    }

    public void setCanCustom(boolean bl) {
        this.m_iCustomFlag = bl ? (this.m_iCustomFlag |= 2) : 0;
    }

    private final void setCanCustomDefault(boolean bl) {
        this.m_iCustomFlag = bl ? (this.m_iCustomFlag |= 1) : (this.m_iCustomFlag &= 0xFFFFFFFE);
    }

    public Template getTemplate() throws WCMException {
        return Template.findById(this.getTemplateId());
    }

    public int getTemplateId() {
        return this.m_iTemplateId;
    }

    public void setTemplateId(int n) {
        this.m_iTemplateId = n;
    }

    public String getTemplateName() {
        return this.m_sTemplateName;
    }

    public void setTemplateName(String string) {
        this.m_sTemplateName = string;
    }

    public static class Token {
        private String m_sValue;
        private String m_sDisplay;

        private Token(String string, String string2) {
            this.m_sValue = string;
            this.m_sDisplay = string2;
        }

        public String getValue() {
            return this.m_sValue;
        }

        public String getDisplay() {
            return this.m_sDisplay;
        }

        public String toString() {
            return "TemplateParameter.Token." + this.m_sValue;
        }
    }

    public static class Type {
        public static final Type BOOLEAN = new Type("BOOLEAN", "B");
        public static final Type INTEGER = new Type("INTEGER", "I");
        public static final Type NUMBER = new Type("NUMBER", "N");
        public static final Type STRING = new Type("STRING", "S");
        public static final Type MULTI = new Type("MULTI", "M");
        private String m_sName;
        private String m_sAlias;

        private Type(String string, String string2) {
            this.m_sName = string;
            this.m_sAlias = string2;
        }

        public String getName() {
            return this.m_sName;
        }

        public String getAlias() {
            return this.m_sAlias;
        }

        public String toString() {
            return "TemplateParameter.Type." + this.m_sName;
        }
    }
}

