/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TagParserPageNav4Detail
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_tagItem;
    private static final String FLAG_START_STYLE = "<style id=_Custom_V6_Style";
    private static final String FLAG_END_STYLE = "</style>";
    Logger m_logger = Logger.getLogger(TagParserPageNav4Detail.class);

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_PAGENAV4DETAIL");
            tagBeanInfo.setDesc("TRS_PAGENAV4DETAIL");
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        CMSObj cMSObj = this.findHost(publishTagContext);
        if (!(cMSObj instanceof Document)) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
            stringBuffer.append(I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label2", "\u53ef\u80fd\u76f4\u63a5\u7528\u5728\u4e86\u6982\u89c8\u9875\u9762\u4e2d\u6216\u8005\u5176\u5b83\u975eTRS_DOCUMENTS\u6982\u89c8\u7f6e\u6807\u4e2d\uff01[tag-host="));
            stringBuffer.append(cMSObj).append(']');
            publishTagContext.addWarning(stringBuffer.toString());
            return null;
        }
        Document document = (Document)cMSObj;
        return this.separatePages(publishTagContext, this.parseHtmlContent(document, publishTagContext));
    }

    private String parseHtmlContent(Document document, PublishTagContext publishTagContext) throws WCMException {
        if (document.getChannel().getType() == 13) {
            return null;
        }
        if (document.getType() != 20) {
            return I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,");
        }
        String string = null;
        try {
            IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
            String string2 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishContent.getRealHome());
            String string3 = PublishPathCompass.calSubDirectory(iPublishContent, false);
            String string4 = string2 + string3;
            if (!publishTagContext.getAttribute("UrlIsABS", false)) {
                string4 = HtmlUtil.calRelativePath(string4, publishTagContext.getPageHttpPath());
            }
            string = document.getHtmlContentWithImgFilter(string4, true, true);
            if ((string = string.replaceAll("(?is)<TRS_COMMENT.*?>.*?</TRS_COMMENT>", "")) == null || string.length() == 0) {
                string = document.getContent();
            } else {
                this.distributionHTMLContentFiles(document, publishTagContext);
            }
            string = TagParseHelper.formatTextIfNeeded(publishTagContext, string);
            return string;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserDocument.class, "TagParserPageNav4Detail.label3", "\u89e3\u6790\u6b63\u6587\u5931\u8d25!"), exception);
        }
    }

    private void distributionHTMLContentFiles(Document document, PublishTagContext publishTagContext) {
        if (document.getType() != 20) {
            return;
        }
        try {
            HTMLContent hTMLContent = new HTMLContent(document.getPubHtmlContent());
            List list = hTMLContent.getWCMFiles();
            int n = list.size();
            if (n <= 0) {
                return;
            }
            boolean bl = publishTagContext.isPreview();
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)list.get(i);
                if (string2 == null || !CMyFile.fileExists(string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2)) continue;
                String string3 = publishPathCompass.getLocalPath(iPublishContent, bl);
                PublishSyncGlobalTuner.insureLocalPathExists(string3);
                CMyFile.copyFile(string, string3 + string2);
                if (bl) continue;
                publishTagContext.getFileDistributeShip().distributeFile(string, iPublishContent, null, true);
            }
        }
        catch (Exception exception) {
            this.m_logger.error((Object)(I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label15", "\u53d1\u5e03") + document + I18NMessage.get(WCMTagParserDocument.class, "WCMTagParserDocument.label16", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01")), (Throwable)exception);
        }
    }

    public String[] separatePages(PublishTagContext publishTagContext, String string) {
        String string2;
        Object object;
        Pattern pattern = Pattern.compile("(?is)<TRS_PAGE_SEPARATOR.*?>.*?</TRS_PAGE_SEPARATOR>");
        Matcher matcher = pattern.matcher(string);
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        String[] stringArray2 = new String[1];
        while (matcher.find()) {
            object = new String[++n];
            System.arraycopy(stringArray, 0, object, 0, n - 1);
            stringArray = object;
            object = new String[n + 1];
            System.arraycopy(stringArray2, 0, object, 0, n);
            stringArray2 = object;
            string2 = matcher.group();
            HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string2);
            HtmlElement htmlElement = htmlElementFinder.findNextElement("TRS_PAGE_SEPARATOR");
            String string3 = CMyString.showEmpty(htmlElement.getAttributeValue("pageTitle"), "");
            if (n == 1) {
                String string4;
                stringArray2[0] = string4 = htmlElement.getAttributeValue("firstPageTitle");
            }
            stringArray2[n] = string3;
            stringArray[n - 1] = string.substring(n3, matcher.start());
            n3 = matcher.end();
            if (n3 + 1 < n2) continue;
            break;
        }
        if (n3 > 0 && n3 < n2) {
            object = new String[++n];
            System.arraycopy(stringArray, 0, object, 0, n - 1);
            stringArray = object;
            stringArray[n - 1] = string.substring(n3);
        }
        if (n <= 0) {
            return new String[]{string};
        }
        if (n == 1) {
            return stringArray;
        }
        object = TagParserPageNav4Detail.extractStyleHTML(stringArray[0]);
        string2 = null;
        if (object != null) {
            string2 = TagParserPageNav4Detail.extractDivStartHTML(stringArray[0]);
        }
        if (string2 != null) {
            stringArray[0] = stringArray[0] + "</DIV>";
            stringArray[stringArray.length - 1] = string2 + (String)object + stringArray[stringArray.length - 1];
            for (int i = 1; i < stringArray.length - 1; ++i) {
                stringArray[i] = string2 + (String)object + stringArray[i] + "</DIV>";
            }
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println("for: " + stringArray[i]);
                    stringArray[i] = stringArray[i] + TagParserPageNav4Detail.outputVar(publishTagContext, stringArray2, i, stringArray.length);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(stringArray[0]);
        this.m_logger.debug((Object)stringArray[0]);
        return stringArray;
    }

    private static String outputVar(PublishTagContext publishTagContext, String[] stringArray, int n, int n2) {
        String string = "\n<SCRIPT language=\"javascript\">\n  var nCurrPage = " + (n + 1) + "\n  var nPageCount = " + n2 + "\n  var arrTitle = \"" + CMyString.filterForJs(CMyString.join(stringArray, "~")) + "\"" + "\n" + "\n  var sValue = window.location.href;" + "\n  var nFileStartPos = sValue.lastIndexOf('/t');" + "\n  var sFile = sValue.substring(nFileNameStartPos);" + "\n  var nFileEndPos = sFile.indexOf('?');" + "\n  if(nFileEndPos < 0){" + "\n      nFileEndPos = sFile.indexOf('#');" + "\n  }" + "\n  if(nFileEndPos > 0){" + "\n      sFile = sFile.substring(0, nFileEndPos);" + "\n  }" + "\n  var nFileNameEndPos = sFile.lastIndexOf('.');   " + "\n  var sFileExt = sFile.substring(nFileNameEndPos+1);" + "\n  var sFileName = sFile.substring(0, nFileNameEndPos);" + "\n  if(nCurrPage>1){" + "\n      var nFileNameStartPos = sFileName.lastIndexOf('_'+ (nCurrPage-1));  " + "\n      sFileName = sFileName.substring(0, nFileNameStartPos);  " + "\n  }" + "\n</SCRIPT>";
        return string;
    }

    private static String extractDivStartHTML(String string) {
        int n = string.indexOf("<DIV id='TRS_AUTOADD");
        if (n < 0) {
            n = string.indexOf("<DIV id=\"TRS_AUTOADD");
        }
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(">", n + 6);
        if (n2 < 0) {
            return null;
        }
        return string.substring(n, n2 + 1);
    }

    private static String extractStyleHTML(String string) {
        int n = string.indexOf(FLAG_START_STYLE);
        if (n <= 0) {
            return null;
        }
        int n2 = string.indexOf(FLAG_END_STYLE, n + 10);
        if (n2 <= 0) {
            return null;
        }
        return string.substring(n, n2 + FLAG_END_STYLE.length());
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getPageElement();
        if (iPublishElement == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return iPublishElement.getSubstance();
    }
}

