/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import java.util.HashMap;
import java.util.List;

public class TagParserCondition
implements ITagParser {
    private static final Operator s_defaultOperators = new OperatorEqual();
    private static final HashMap s_MapOperator = TagParserCondition.initOperators();
    private static TagBeanInfo s_TagBeanInfo = null;

    private static final HashMap initOperators() {
        HashMap<String, Operator> hashMap = new HashMap<String, Operator>();
        Operator operator = null;
        OperatorNumber operatorNumber = null;
        OperatorLength operatorLength = null;
        operator = new OperatorEqualCase();
        hashMap.put("=", operator);
        hashMap.put("equal", operator);
        operator = new OperatorEqual();
        hashMap.put("==", operator);
        operatorNumber = new OperatorLess();
        operatorNumber.setType(0);
        hashMap.put("<,INT", operatorNumber);
        operatorNumber = new OperatorLess();
        operatorNumber.setType(1);
        hashMap.put("<,FLOAT", operatorNumber);
        operatorNumber = new OperatorLess();
        operatorNumber.setType(2);
        hashMap.put("<", operatorNumber);
        operatorNumber = new OperatorLessEqual();
        operatorNumber.setType(0);
        hashMap.put("<=,INT", operatorNumber);
        operatorNumber = new OperatorLessEqual();
        operatorNumber.setType(1);
        hashMap.put("<=,FLOAT", operatorNumber);
        operatorNumber = new OperatorLessEqual();
        operatorNumber.setType(2);
        hashMap.put("<=", operatorNumber);
        operatorNumber = new OperatorGreater();
        operatorNumber.setType(0);
        hashMap.put(">,INT", operatorNumber);
        operatorNumber = new OperatorGreater();
        operatorNumber.setType(1);
        hashMap.put(">,FLOAT", operatorNumber);
        operatorNumber = new OperatorGreater();
        operatorNumber.setType(2);
        hashMap.put(">", operatorNumber);
        operatorNumber = new OperatorGreaterEqual();
        operatorNumber.setType(0);
        hashMap.put(">=,INT", operatorNumber);
        operatorNumber = new OperatorGreaterEqual();
        operatorNumber.setType(1);
        hashMap.put(">=,FLOAT", operatorNumber);
        operatorNumber = new OperatorGreaterEqual();
        operatorNumber.setType(2);
        hashMap.put(">=", operatorNumber);
        operator = new OperatorPresent();
        hashMap.put("present", operator);
        operator = new OperatorBlank();
        hashMap.put("blank", operator);
        operator = new OperatorContain();
        hashMap.put("contain", operator);
        operator = new OperatorStartsWith();
        hashMap.put("startsWith", operator);
        operator = new OperatorEndsWith();
        hashMap.put("endsWith", operator);
        operator = new OperatorMatch();
        hashMap.put("match", operator);
        operatorLength = new OperatorLength();
        operatorLength.setCompareType(0);
        hashMap.put("L", operatorLength);
        hashMap.put("longer", operatorLength);
        operatorLength = new OperatorLength();
        operatorLength.setCompareType(1);
        hashMap.put("L=", operatorLength);
        operatorLength = new OperatorLength();
        operatorLength.setCompareType(2);
        hashMap.put("S", operatorLength);
        hashMap.put("shorter", operatorLength);
        operatorLength = new OperatorLength();
        operatorLength.setCompareType(3);
        hashMap.put("S=", operatorLength);
        return hashMap;
    }

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_CONDITION");
            tagBeanInfo.setDesc("TRS_CONDITION");
            tagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CONDITION");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label1", "\u6267\u884c\u6761\u4ef6\u5c5e\u6027(CONDITION)"));
            tagBeanAttrInfo.setRequired(true);
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("REFERENCE");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label2", "\u5224\u65ad\u6267\u884c\u6761\u4ef6\u7684\u53c2\u8003\u503c(REFERENCE)"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setDefaultValue("true");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("OPERATOR");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label3", "\u6bd4\u8f83\u8fd0\u7b97\u7b26"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"=", "equal", "==", "<", "<=", ">", ">=", "present", "blank", "contain", "startsWith", "endsWith", "match", "L", "L=", "S", "S="});
            tagBeanAttrInfo.setDefaultValue("==");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("REVERSE");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label4", "\u662f\u5426\u7ffb\u8f6c\u53d8\u91cf\u503c\u548c\u53c2\u8003\u503c"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TYPE");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label5", "\u6bd4\u8f83\u8fd0\u7b97\u4e2d\u6570\u636e\u7c7b\u578b(INT,FLOAT,STRING)"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"INT", "FLOAT", "STRING"});
            tagBeanAttrInfo.setDefaultValue("false");
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("NOT");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label6", "\u662f\u5426\u6c42\u53cd"));
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"true", "false"});
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) throws WCMException {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string = this.getReference(publishTagContext);
        String string2 = this.getCondition(publishTagContext);
        Operator operator = this.getOperator(publishTagContext);
        boolean bl = publishTagContext.getAttribute("REVERSE", false);
        boolean bl2 = publishTagContext.getAttribute("NOT", false);
        if (bl) {
            String string3 = string;
            string = string2;
            string2 = string3;
        }
        boolean bl3 = false;
        String[] stringArray = string.split("~");
        for (int i = 0; i < stringArray.length && !(bl3 = operator.compare(string2, stringArray[i])); ++i) {
        }
        if (bl3 ^ bl2) {
            TagItem tagItem = publishTagContext.getTagItem();
            if (tagItem == null) {
                throw new IllegalStateException("no tag on TagContext");
            }
            List list = tagItem.getChildren();
            if (list != null) {
                return TagParseHelper.parseItems(list, publishTagContext);
            }
        }
        return null;
    }

    private String getCondition(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("CONDITION");
        if (string == null) {
            return null;
        }
        if (string.length() <= 0) {
            return string;
        }
        if (string.charAt(0) == '@') {
            return this.getTagObjAttribute(publishTagContext, string.substring(1));
        }
        if (string.charAt(0) == '#') {
            CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
            return cMSObj.getAttributeValue(string.substring(1));
        }
        return string;
    }

    private String getReference(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("REFERENCE");
        if (string == null) {
            return "true";
        }
        if (string.length() <= 0) {
            return string;
        }
        if (string.charAt(0) == '@') {
            return this.getTagObjAttribute(publishTagContext, string.substring(1));
        }
        if (string.charAt(0) == '#') {
            CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
            return cMSObj.getAttributeValue(string.substring(1));
        }
        return string;
    }

    private String getTagObjAttribute(PublishTagContext publishTagContext, String string) throws WCMException {
        if ("System.NowDate".equalsIgnoreCase(string)) {
            return CMyDateTime.now().toString("yyyy-MM-dd");
        }
        if ("ROWNO".equalsIgnoreCase(string)) {
            return String.valueOf(publishTagContext.getSequenceNumber());
        }
        if ("TOTALSIZE".equalsIgnoreCase(string)) {
            return String.valueOf(publishTagContext.getTagParser4List().getRecordSize());
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PAGE".equalsIgnoreCase(string2)) {
            return this.getPageObjAttribute(publishTagContext.getPageContext(), string3);
        }
        if ("SITE".equalsIgnoreCase(string2)) {
            CMSObj cMSObj = publishTagContext.getRoot().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishElement iPublishElement = publishTagContext.getUpperHost();
            IPublishFolder iPublishFolder = null;
            iPublishFolder = iPublishElement instanceof IPublishFolder ? ((IPublishFolder)iPublishElement).getParent() : iPublishElement.getFolder();
            return this.getFolderObjAttribute(iPublishFolder, string3);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label7", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PAGE,SITE,PARENT]"));
    }

    private String getPageObjAttribute(PublishPageContext publishPageContext, String string) throws WCMException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = publishPageContext.getPageElement().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("SITE".equalsIgnoreCase(string2)) {
            CMSObj cMSObj = publishPageContext.getRoot().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishElement iPublishElement = publishPageContext.getPageElement();
            IPublishFolder iPublishFolder = null;
            iPublishFolder = iPublishElement instanceof IPublishFolder ? ((IPublishFolder)iPublishElement).getParent() : iPublishElement.getFolder();
            return this.getFolderObjAttribute(iPublishFolder, string3);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label8", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[SITE,PARENT]"));
    }

    private String getFolderObjAttribute(IPublishFolder iPublishFolder, String string) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label9", "\u9519\u8bef\u7684\u4f7f\u7528\u573a\u666f\uff0c\u5df2\u7ecf\u4e0d\u5b58\u5728\u7236\u76ee\u5f55"));
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = iPublishFolder.getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
            return this.getFolderObjAttribute(iPublishFolder2, string3);
        }
        throw new WCMException(I18NMessage.get(TagParserCondition.class, "TagParserCondition.label10", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PARENT]"));
    }

    private Operator getOperator(PublishTagContext publishTagContext) {
        Operator operator;
        String string = publishTagContext.getAttribute("OPERATOR");
        if (string == null) {
            return s_defaultOperators;
        }
        String string2 = publishTagContext.getAttribute("TYPE");
        if (string2 != null && (string2 = string2.trim()).length() > 0 && !(string2 = string2.toUpperCase()).equals("STRING")) {
            string = string + ',' + string2;
        }
        if ((operator = (Operator)s_MapOperator.get(string)) == null) {
            return s_defaultOperators;
        }
        return operator;
    }

    public void clear() {
    }

    private static class OperatorLength
    extends Operator {
        static final int LONGER_THAN = 0;
        static final int LONGER_OR_EQUAL = 1;
        static final int SHORTER_THAN = 2;
        static final int SHORTER_OR_EQUAL = 3;
        private int m_iCompareType = 0;

        private OperatorLength() {
        }

        boolean compare(String string, String string2) {
            int n = this.getConditionLength(string);
            int n2 = this.getReferenceLength(string2);
            switch (this.m_iCompareType) {
                case 0: {
                    return n > n2;
                }
                case 1: {
                    return n >= n2;
                }
                case 2: {
                    return n < n2;
                }
                case 3: {
                    return n <= n2;
                }
            }
            return n > n2;
        }

        private final int getConditionLength(String string) {
            if (string == null) {
                return 0;
            }
            return string.length();
        }

        private final int getReferenceLength(String string) {
            if (string == null) {
                return 0;
            }
            int n = string.length();
            if (n > 10) {
                return n;
            }
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = string.charAt(i) - 48;
                if (n3 < 0 || n3 > 9) {
                    return n;
                }
                n2 = n2 * 10 + n3;
            }
            if (n2 > 0) {
                return n2;
            }
            return n;
        }

        int getCompareType() {
            return this.m_iCompareType;
        }

        void setCompareType(int n) {
            this.m_iCompareType = n;
        }
    }

    private static class OperatorMatch
    extends Operator {
        private OperatorMatch() {
        }

        boolean compare(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            return string.matches(string2);
        }
    }

    private static class OperatorEndsWith
    extends Operator {
        private OperatorEndsWith() {
        }

        boolean compare(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            return string.endsWith(string2);
        }
    }

    private static class OperatorStartsWith
    extends Operator {
        private OperatorStartsWith() {
        }

        boolean compare(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            return string.startsWith(string2);
        }
    }

    private static class OperatorContain
    extends Operator {
        private OperatorContain() {
        }

        boolean compare(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            return string.indexOf(string2) >= 0;
        }
    }

    private static class OperatorBlank
    extends Operator {
        private OperatorBlank() {
        }

        boolean compare(String string, String string2) {
            return string == null || string.length() <= 0;
        }
    }

    private static class OperatorPresent
    extends Operator {
        private OperatorPresent() {
        }

        boolean compare(String string, String string2) {
            return string != null;
        }
    }

    private static class OperatorGreaterEqual
    extends OperatorNumber {
        private OperatorGreaterEqual() {
        }

        boolean compareInt(int n, int n2) {
            return n >= n2;
        }

        boolean compareFloat(float f, float f2) {
            return f >= f2;
        }

        boolean compareString(String string, String string2) {
            return string.compareTo(string2) >= 0;
        }
    }

    private static class OperatorGreater
    extends OperatorNumber {
        private OperatorGreater() {
        }

        boolean compareInt(int n, int n2) {
            return n > n2;
        }

        boolean compareFloat(float f, float f2) {
            return f > f2;
        }

        boolean compareString(String string, String string2) {
            return string.compareTo(string2) > 0;
        }
    }

    private static class OperatorLessEqual
    extends OperatorNumber {
        private OperatorLessEqual() {
        }

        boolean compareInt(int n, int n2) {
            return n <= n2;
        }

        boolean compareFloat(float f, float f2) {
            return f <= f2;
        }

        boolean compareString(String string, String string2) {
            return string.compareTo(string2) <= 0;
        }
    }

    private static class OperatorLess
    extends OperatorNumber {
        private OperatorLess() {
        }

        boolean compareInt(int n, int n2) {
            return n < n2;
        }

        boolean compareFloat(float f, float f2) {
            return f < f2;
        }

        boolean compareString(String string, String string2) {
            return string.compareTo(string2) < 0;
        }
    }

    private static abstract class OperatorNumber
    extends Operator {
        static final int TYPE_INT = 0;
        static final int TYPE_FLOAT = 1;
        static final int TYPE_STRING = 2;
        int m_iCompareType = 2;

        private OperatorNumber() {
        }

        void setType(int n) {
            this.m_iCompareType = n;
        }

        boolean compare(String string, String string2) {
            if (string == null) {
                return false;
            }
            switch (this.m_iCompareType) {
                case 0: {
                    int n = Integer.parseInt(string);
                    int n2 = Integer.parseInt(string2);
                    return this.compareInt(n, n2);
                }
                case 1: {
                    float f = Float.parseFloat(string);
                    float f2 = Float.parseFloat(string2);
                    return this.compareFloat(f, f2);
                }
            }
            return this.compareString(string, string2);
        }

        abstract boolean compareInt(int var1, int var2);

        abstract boolean compareFloat(float var1, float var2);

        abstract boolean compareString(String var1, String var2);
    }

    private static class OperatorEqualCase
    extends Operator {
        private OperatorEqualCase() {
        }

        boolean compare(String string, String string2) {
            if (string == null) {
                return string2 == null;
            }
            return string.equals(string2);
        }
    }

    private static class OperatorEqual
    extends Operator {
        private OperatorEqual() {
        }

        boolean compare(String string, String string2) {
            if (string == null) {
                return string2 == null;
            }
            boolean bl = string.equalsIgnoreCase(string2);
            if (bl) {
                return true;
            }
            if (string.equalsIgnoreCase("true")) {
                string = "1";
            } else if (string.equalsIgnoreCase("false")) {
                string = "0";
            } else {
                return bl;
            }
            return string.equalsIgnoreCase(string2);
        }
    }

    public static abstract class Operator {
        abstract boolean compare(String var1, String var2);
    }
}

