/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.html.HtmlUtil;
import org.apache.log4j.Logger;

public abstract class TagParserCMSObjBase
implements ITagParser {
    private static Logger logger = Logger.getLogger(TagParserCMSObjBase.class);
    protected TagItem m_tagItem;
    protected CMSObj m_host = null;
    private static NamesRegister m_hostSpecialPropertiesRegister = new NamesRegister();

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_host != null) {
            this.m_host = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        this.m_host = this.findHost(publishTagContext);
        if (this.m_host == null) {
            return this.filterDefaultValue(publishTagContext, null);
        }
        try {
            String string = publishTagContext.getAttribute("FIELD");
            if (string == null || (string = string.trim()).length() == 0) {
                string = this.getDefaultField();
            }
            if (string == null || (string = string.trim()).length() == 0) {
                return new String[]{String.valueOf(this.m_host.getId())};
            }
            int n = this.lookupHostSpecialPropertyId(string = string.toUpperCase());
            if (n > 0) {
                return this.filterDefaultValue(publishTagContext, this.parseHostSpecialProperty(n, publishTagContext));
            }
            if (string.equalsIgnoreCase("_RECURL")) {
                String string2 = this.getAutoLinkUrl(publishTagContext);
                if (!this.isLinkElement() && !publishTagContext.getAttribute("UrlIsAbs", false)) {
                    string2 = HtmlUtil.calRelativePath(string2, publishTagContext.getPageHttpPath());
                }
                return new String[]{string2};
            }
            return this.filterDefaultValue(publishTagContext, this.parseHostNormalProperty(string, publishTagContext));
        }
        catch (Exception exception) {
            throw new WCMException(234, I18NMessage.get(TagParserCMSObjBase.class, "TagParserCMSObjBase.label1", "\u89e3\u6790\u7ec6\u89c8\u7f6e\u6807\u5931\u8d25\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), exception);
        }
    }

    private String[] filterDefaultValue(PublishTagContext publishTagContext, String[] stringArray) {
        String string = publishTagContext.getAttribute("DefaultValue");
        if (stringArray == null || stringArray.length <= 0) {
            return new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CMyString.showEmpty(stringArray[i], string);
        }
        return stringArray;
    }

    protected String getDefaultField() {
        return null;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return iPublishElement.getSubstance();
    }

    protected String[] parseHostNormalProperty(String string, PublishTagContext publishTagContext) throws WCMException {
        Object object = string.charAt(0) == '#' ? this.m_host.getAttributeValue(string.substring(1)) : this.m_host.getProperty(string);
        if (object == null) {
            return null;
        }
        return this.parseProperty(object, publishTagContext);
    }

    protected String[] parseProperty(Object object, PublishTagContext publishTagContext) throws WCMException {
        String string;
        int n;
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof CMyDateTime) {
            object2 = (CMyDateTime)object;
            n = publishTagContext.getAttribute("InMillis", false);
            if (n != 0) {
                string = String.valueOf(((CMyDateTime)object2).getTimeInMillis());
            } else {
                String string2 = publishTagContext.getAttribute("LOCALE");
                String string3 = publishTagContext.getAttribute("TIMEZONE");
                String string4 = this.getDateFormat(publishTagContext);
                string = ((CMyDateTime)object2).toString(string4, string2, string3);
            }
        } else {
            string = object instanceof String ? (String)object : object.toString();
        }
        if (string == null) {
            return null;
        }
        object2 = null;
        object2 = TagParseHelper.truncateTextIfNeeded(publishTagContext, string);
        object2 = TagParseHelper.formatTextIfNeeded(publishTagContext, (String)object2);
        object2 = TagParseHelper.addSpanStyleIfNeeded(publishTagContext, (String)object2);
        if (this.mayAutoLink(publishTagContext)) {
            object2 = this.addAutoLink((String)object2, string, publishTagContext);
        } else if (object instanceof CDBText && (n = publishTagContext.getAttribute("NUM", 0)) == 0) {
            if (publishTagContext.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages((String)object2);
            }
            return new String[]{object2};
        }
        if (publishTagContext.getAttribute("ISHTMLCONTENT", false)) {
            return TagParseHelper.parseHtmlContent((String)object2, (IPublishContent)publishTagContext.getUpperHost(), publishTagContext);
        }
        return new String[]{object2};
    }

    protected boolean mayAutoLink(PublishTagContext publishTagContext) {
        return publishTagContext.getAttribute("AUTOLINK", false);
    }

    protected String addAutoLink(String string, String string2, PublishTagContext publishTagContext) throws WCMException {
        String string3 = publishTagContext.getAttribute("TARGET");
        String string4 = publishTagContext.getAttribute("EXTRA");
        String string5 = publishTagContext.getAttribute("LINKTEXT");
        String string6 = null;
        if (publishTagContext.getAttribute("LINKALT", false) && ((string6 = publishTagContext.getAttribute("LINKALTTEXT")) == null || (string6 = string6.trim()).length() == 0)) {
            string6 = string2;
        }
        String string7 = this.getAutoLinkUrl(publishTagContext);
        if (!this.isLinkElement() && !publishTagContext.getAttribute("UrlIsAbs", false)) {
            string7 = HtmlUtil.calRelativePath(string7, publishTagContext.getPageHttpPath());
        }
        return HtmlUtil.renderLink(string7, string3, string6, string4, string, string5);
    }

    private boolean isLinkElement() {
        if (this.m_host == null) {
            return true;
        }
        try {
            IPublishElement iPublishElement = PublishElementFactory.makeElementFrom(this.m_host);
            return iPublishElement.isLink();
        }
        catch (Exception exception) {
            logger.error((Object)("The [" + this.m_host + "] is not IPublishElement\uff01"), (Throwable)exception);
            return true;
        }
    }

    protected abstract String getAutoLinkUrl(PublishTagContext var1) throws WCMException;

    protected String getDateFormat(PublishTagContext publishTagContext) {
        String string = publishTagContext.getAttribute("DATEFORMAT");
        if (string == null || (string = string.trim()).length() == 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        return TagParseHelper.parseDateFormat(string);
    }

    protected void registerHostSpecialProperty(String string, int n) {
        String string2 = this.m_tagItem.getName() + '.' + string;
        m_hostSpecialPropertiesRegister.register(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lookupHostSpecialPropertyId(String string) {
        String string2 = this.m_tagItem.getName() + '.';
        if (!m_hostSpecialPropertiesRegister.contains(string2)) {
            NamesRegister namesRegister = m_hostSpecialPropertiesRegister;
            synchronized (namesRegister) {
                if (!m_hostSpecialPropertiesRegister.contains(string2)) {
                    this.registerHostSpecialProperties();
                    m_hostSpecialPropertiesRegister.register(string2, 0);
                }
            }
        }
        return m_hostSpecialPropertiesRegister.lookup(string2 + string, -1);
    }

    protected abstract void registerHostSpecialProperties();

    protected abstract String[] parseHostSpecialProperty(int var1, PublishTagContext var2) throws WCMException;
}

