/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseResults;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.tools.HtmlCleaner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TagParseHelper {
    private static final Logger LOG = Logger.getLogger(TagParseHelper.class);
    private static final String SEP_PATTERN = "(?is)<TRS_PAGE_SEPARATOR.*?>.*?</TRS_PAGE_SEPARATOR>";
    public static final int AUTOFORMATTYPE_HTML = 1;
    public static final int AUTOFORMATTYPE_HTMLVALUE = 2;
    public static final int AUTOFORMATTYPE_JAVASCRIPT = 3;
    public static final int AUTOFORMATTYPE_XML = 4;
    public static final int AUTOFORMATTYPE_INNERTEXT = 5;
    private static NamesRegister s_oNamesRegister = new NamesRegister();
    private static final String FLAG_START_STYLE = "<style id=_Custom_V6_Style";
    private static final String FLAG_END_STYLE = "</style>";
    private static final String FLAG_PASTE_STYLE = "cas_content";
    private static final Set SPECIAL_TAG_SET;

    private TagParseHelper() {
    }

    public static TagItem strToTagItem(String string) throws Exception {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        TagDocument tagDocument = TagDocumentReader.read(string.trim());
        if (tagDocument != null && tagDocument.getItemCount() > 0 && (object = tagDocument.getItemAt(0)) instanceof TagItem) {
            return (TagItem)object;
        }
        return null;
    }

    public static String[] parseItem(TagItem tagItem, PublishTagContext publishTagContext) throws WCMException {
        if (tagItem == null) {
            return null;
        }
        try {
            String string;
            ITagParser iTagParser = TagParserFactory.createParserByName(tagItem.getName());
            publishTagContext.setTagItem(tagItem);
            iTagParser.setTagItem(tagItem);
            String[] stringArray = iTagParser.parse(publishTagContext);
            if (!TagParseHelper.isSpecialTag(tagItem.getName()) && TagParseHelper.isNull(stringArray) && !CMyString.isEmpty(string = tagItem.getAttribute("Default"))) {
                stringArray = new String[]{string};
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (exception instanceof WCMException && ((WCMException)exception).getErrNo() > 200000) {
                throw (WCMException)exception;
            }
            throw new WCMException(234, I18NMessage.get(TagParseHelper.class, "TagParseHelper.label1", "\u89e3\u6790\u7f6e\u6807\u53d1\u751f\u5f02\u5e38\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: \n") + tagItem.toString(), exception);
        }
    }

    private static boolean isSpecialTag(String string) {
        return SPECIAL_TAG_SET.contains(string.toUpperCase());
    }

    private static boolean isNull(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        boolean bl = true;
        int n = stringArray.length;
        for (int i = 0; bl && i < n; ++i) {
            bl = CMyString.isEmpty(stringArray[i]);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parseItems(List list, PublishTagContext publishTagContext) throws WCMException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TagParseResults tagParseResults = new TagParseResults();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e instanceof String) {
                    tagParseResults.append((String)e);
                    continue;
                }
                TagItem tagItem = (TagItem)e;
                String[] stringArray = TagParseHelper.parseItem(tagItem, publishTagContext);
                if (stringArray == null) continue;
                tagParseResults.append(stringArray);
            }
            String[] stringArray = tagParseResults.toStrArray();
            return stringArray;
        }
        finally {
            tagParseResults.clear();
        }
    }

    public static String parseDateFormat(String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return "yyyy-MM-dd";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 4);
        int n = 0;
        int n2 = cArray.length;
        block10: while (n < n2) {
            char c;
            if ((c = cArray[n++]) != '%') {
                stringBuffer.append(c);
                continue;
            }
            if (n == n2) {
                stringBuffer.append('%');
                break;
            }
            c = cArray[n++];
            switch (c) {
                case 'Y': {
                    stringBuffer.append("yyyy");
                    continue block10;
                }
                case 'M': {
                    if (n + 1 < n2 && cArray[n] == 'O' && cArray[n + 1] == 'N') {
                        stringBuffer.append("MM");
                        n += 2;
                        continue block10;
                    }
                    stringBuffer.append("mm");
                    continue block10;
                }
                case 'm': {
                    stringBuffer.append("MM");
                    continue block10;
                }
                case 'D': {
                    if (n + 1 < n2 && cArray[n] == 'A' && cArray[n + 1] == 'Y') {
                        stringBuffer.append("dd");
                        n += 2;
                        continue block10;
                    }
                    stringBuffer.append("%D");
                    continue block10;
                }
                case 'd': {
                    stringBuffer.append("dd");
                    continue block10;
                }
                case 'H': {
                    stringBuffer.append("HH");
                    continue block10;
                }
                case 'S': {
                    stringBuffer.append("ss");
                    continue block10;
                }
                case '%': {
                    stringBuffer.append('%');
                    --n;
                    continue block10;
                }
            }
            stringBuffer.append('%').append(c);
        }
        return stringBuffer.toString();
    }

    public static String[] separatePagesOld(String string) {
        int n;
        String string2;
        String[] stringArray;
        Pattern pattern = Pattern.compile(SEP_PATTERN);
        Matcher matcher = pattern.matcher(string);
        String[] stringArray2 = new String[1];
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (matcher.find()) {
            if (++n2 > stringArray2.length) {
                stringArray = new String[n2];
                System.arraycopy(stringArray2, 0, stringArray, 0, n2 - 1);
                stringArray2 = stringArray;
            }
            stringArray2[n2 - 1] = string.substring(n4, matcher.start());
            n4 = matcher.end();
            if (n4 + 1 < n3) continue;
        }
        if (n4 > 0 && n4 < n3) {
            stringArray = new String[++n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2 - 1);
            stringArray2 = stringArray;
            stringArray2[n2 - 1] = string.substring(n4);
        }
        if (n2 <= 0) {
            return new String[]{string};
        }
        if (n2 == 1) {
            return stringArray2;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = HtmlCleaner.parse(stringArray2[i]);
            if (string2 == null || string2.trim().length() <= 0) continue;
            if (string2.endsWith("-")) {
                string2 = string2.substring(0, string2.length() - 2);
                stringArray2[i] = TagParseHelper.reverseAppendTag(stringArray2[i], string2, false);
                continue;
            }
            stringArray2[i] = TagParseHelper.appendTag(stringArray2[i], string2, true);
        }
        String string3 = TagParseHelper.extractStyleHTML(stringArray2[0]);
        string2 = null;
        if (string3 != null) {
            int n5;
            string2 = TagParseHelper.extractDivStartHTML(stringArray2[0]);
            if (string2 != null) {
                stringArray2[stringArray2.length - 1] = string2 + string3 + stringArray2[stringArray2.length - 1] + "</DIV>";
                for (n = 1; n < stringArray2.length - 1; ++n) {
                    stringArray2[n] = string2 + string3 + stringArray2[n] + "</DIV>";
                }
            }
            if ((n = stringArray2[0].indexOf(FLAG_PASTE_STYLE)) > 0) {
                for (n5 = 1; n5 < stringArray2.length - 1; ++n5) {
                    stringArray2[n5] = "<DIV class='cas_content'>" + stringArray2[n5] + "</DIV>";
                }
                stringArray2[stringArray2.length - 1] = "<DIV class='cas_content'>" + stringArray2[stringArray2.length - 1];
            }
            for (n5 = 1; n5 < stringArray2.length - 1; ++n5) {
                stringArray2[n5] = "<DIV class='TRS_Editor'>" + stringArray2[n5] + "</DIV>";
            }
            if (n > 0) {
                stringArray2[stringArray2.length - 1] = stringArray2[stringArray2.length - 1].substring(6);
            }
            stringArray2[stringArray2.length - 1] = "<DIV class='TRS_Editor'>" + stringArray2[stringArray2.length - 1] + "</div>";
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                for (n = 0; n < stringArray2.length; ++n) {
                    stringArray2[n] = stringArray2[n] + TagParseHelper.getPageNavigator(n, stringArray2.length);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray2;
    }

    public static String[] separatePages(String string) {
        int n;
        int n2;
        Pattern pattern = Pattern.compile(SEP_PATTERN);
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>(5);
        int n3 = string.length();
        int n4 = 0;
        while (matcher.find()) {
            arrayList.add(string.substring(n4, matcher.start()));
            n4 = matcher.end();
        }
        if (n4 > 0 && n4 < n3) {
            arrayList.add(string.substring(n4));
        }
        if (arrayList.size() <= 1) {
            arrayList.clear();
            return new String[]{string};
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        arrayList.clear();
        String string2 = stringArray[0];
        int n5 = string2.indexOf(FLAG_PASTE_STYLE);
        if (n5 == -1) {
            n5 = string2.indexOf(FLAG_START_STYLE);
            if (n5 != -1) {
                n5 = string2.indexOf(FLAG_END_STYLE, n5);
                string2 = string2.substring(0, n5 + FLAG_END_STYLE.length());
            } else {
                string2 = null;
            }
        } else {
            n5 = '>' != string2.charAt(n5 += FLAG_PASTE_STYLE.length()) ? (n5 += 2) : ++n5;
            string2 = string2.substring(0, n5);
        }
        if (string2 != null) {
            n2 = stringArray.length;
            for (n = 1; n < n2; ++n) {
                stringArray[n] = string2 + stringArray[n];
            }
        }
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string3 = stringArray[n];
            String string4 = HtmlCleaner.parse(string3);
            if (string4 == null || string4.trim().length() <= 0) continue;
            if (string4.endsWith("-")) {
                string4 = string4.substring(0, string4.length() - 2);
                stringArray[n] = TagParseHelper.reverseAppendTag(string3, string4, false);
                continue;
            }
            stringArray[n] = TagParseHelper.appendTag(string3, string4, true);
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = stringArray[n] + TagParseHelper.getPageNavigator(n, n2);
                }
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)"failed to generate nav of wcm51 style.", (Throwable)exception);
        }
        return stringArray;
    }

    private static String appendTag(String string, String string2, boolean bl) {
        String string3 = string;
        for (int i = 0; i < string2.split(",").length; ++i) {
            string3 = bl ? string3 + " </" + string2.split(",")[i] + ">" : "<" + string2.split(",")[i] + "> " + string3;
        }
        return string3;
    }

    private static String reverseAppendTag(String string, String string2, boolean bl) {
        String string3 = string;
        for (int i = string2.split(",").length - 1; i >= 0; --i) {
            string3 = bl ? string3 + " </" + string2.split(",")[i] + ">" : "<" + string2.split(",")[i] + "> " + string3;
        }
        return string3;
    }

    private static String extractDivStartHTML(String string) {
        int n = string.indexOf("<DIV id='TRS_AUTOADD");
        if (n < 0) {
            n = string.indexOf("<DIV id=\"TRS_AUTOADD");
        }
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(">", n + 6);
        if (n2 < 0) {
            return null;
        }
        return string.substring(n, n2 + 1);
    }

    private static String extractStyleHTML(String string) {
        int n = string.indexOf(FLAG_START_STYLE);
        if (n <= 0) {
            return null;
        }
        int n2 = string.indexOf(FLAG_END_STYLE, n + 10);
        if (n2 <= 0) {
            return null;
        }
        return string.substring(n, n2 + FLAG_END_STYLE.length());
    }

    public static String truncateTextIfNeeded(TagItem tagItem, String string) throws WCMException {
        int n = tagItem.getIntAttribute("NUM", 0);
        if (n <= 0) {
            return string;
        }
        String string2 = tagItem.getAttribute("TRUNCATEDFLAG");
        if (string2 == null) {
            string2 = "...";
        }
        return CMyString.truncateStr(string, n, string2);
    }

    public static String truncateTextIfNeeded(PublishTagContext publishTagContext, String string) throws WCMException {
        int n = publishTagContext.getAttribute("NUM", 0);
        if (n <= 0) {
            return string;
        }
        string = CMyString.innerText(string);
        String string2 = publishTagContext.getAttribute("TRUNCATEDFLAG");
        if (string2 == null) {
            string2 = "...";
        }
        return CMyString.truncateStr(string, n, string2);
    }

    public static String formatTextIfNeeded(TagItem tagItem, String string) {
        if (!tagItem.getBooleanAttribute("AUTOFORMAT", false)) {
            return string;
        }
        String string2 = tagItem.getAttribute("AUTOFORMATTYPE");
        string2 = string2 == null || (string2 = string2.trim()).length() == 0 ? "HTML" : string2.toUpperCase();
        int n = s_oNamesRegister.lookup(string2, 1);
        String string3 = null;
        switch (n) {
            case 2: {
                string3 = CMyString.filterForHTMLValue(string);
                break;
            }
            case 3: {
                string3 = CMyString.filterForJs(string);
                break;
            }
            case 4: {
                string3 = CMyString.filterForXML(string);
                break;
            }
            case 5: {
                string3 = CMyString.innerText(string);
                break;
            }
            default: {
                string3 = CMyString.transDisplay(string);
            }
        }
        return string3;
    }

    public static String formatTextIfNeeded(PublishTagContext publishTagContext, String string) {
        if (!publishTagContext.getAttribute("AUTOFORMAT", false)) {
            return string;
        }
        String string2 = publishTagContext.getAttribute("AUTOFORMATTYPE");
        string2 = string2 == null || (string2 = string2.trim()).length() == 0 ? "HTML" : string2.toUpperCase();
        int n = s_oNamesRegister.lookup(string2, 1);
        String string3 = null;
        switch (n) {
            case 2: {
                string3 = CMyString.filterForHTMLValue(string);
                break;
            }
            case 3: {
                string3 = CMyString.filterForJs(string);
                break;
            }
            case 4: {
                string3 = CMyString.filterForXML(string);
                break;
            }
            case 5: {
                string3 = CMyString.innerText(string);
                break;
            }
            default: {
                string3 = CMyString.transDisplay(string, false);
            }
        }
        return string3;
    }

    public static Template findNestedTemplate(PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("TEMPNAME");
        IPublishFolder iPublishFolder = publishTagContext.getPageElement().getFolder().getRoot();
        return TagParseHelper.findNestedTemplate(string, iPublishFolder);
    }

    public static Template findNestedTemplate(TagItem tagItem, IPublishFolder iPublishFolder) throws WCMException {
        String string = tagItem.getAttribute("TEMPNAME");
        return TagParseHelper.findNestedTemplate(string, iPublishFolder);
    }

    public static Template findNestedTemplate(String string, IPublishFolder iPublishFolder) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(232, "Template name requried in tag <TRS_TEMPLATE>");
        }
        TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = templateCacheMgr.lookupByName(iPublishFolder, string);
        if (template == null) {
            throw new WCMException(232, "Template [" + string + "] not found in " + iPublishFolder.getInfo() + "!");
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4List(PublishTagContext publishTagContext, ITagParser4List iTagParser4List) throws WCMException {
        int n;
        int n2 = publishTagContext.getAttribute("STARTPOS", 0);
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = iTagParser4List.getRecordSize();
        int n4 = publishTagContext.getAttribute("NUM", 0);
        if (n4 <= 0 || n4 > n3) {
            n4 = n3;
        }
        if ((n = publishTagContext.getAttribute("LOOP", 0)) < 0 || n > n4) {
            n = n4;
        }
        int n5 = publishTagContext.getAttribute("PAGESIZE", 0);
        List list = publishTagContext.getTagItem().getChildren();
        ArrayList<String> arrayList = new ArrayList<String>();
        TagParseResults tagParseResults = new TagParseResults();
        String[] stringArray = null;
        try {
            PublishTagContext publishTagContext2;
            iTagParser4List.setStartPos(n2);
            for (int i = 0; i < n && (publishTagContext2 = iTagParser4List.getDelegatedContext()) != null; ++i) {
                if (n5 > 0 && i / n5 > arrayList.size()) {
                    arrayList.add(tagParseResults.get(0));
                    tagParseResults.clear();
                }
                if ((stringArray = TagParseHelper.parseItems(list, publishTagContext2)) == null) continue;
                tagParseResults.append(stringArray);
            }
            arrayList.add(tagParseResults.get(0));
            publishTagContext.getPageContext().setExtraAttribute("RECORD_COUNT", String.valueOf(n3));
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            if (tagParseResults != null) {
                tagParseResults.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4List(TagItem tagItem, PublishTagContext publishTagContext, ITagParser4List iTagParser4List) throws WCMException {
        PublishTagContext publishTagContext2;
        String string = null;
        if (tagItem.containsChild("TRS_EXISTSDATA") && iTagParser4List.getRecordSize() > 0) {
            publishTagContext2 = null;
            publishTagContext2 = publishTagContext.getParent() == null ? new PublishTagContext(publishTagContext.getPageContext()) : new PublishTagContext(publishTagContext.getParent(), tagItem, publishTagContext.getUpperHost());
            string = TagParseHelper.preparseChildTagItem(tagItem, publishTagContext2, "TRS_EXISTSDATA");
        }
        if (tagItem.containsChild("TRS_NOTEXISTSDATA") && iTagParser4List.getRecordSize() <= 0) {
            publishTagContext2 = null;
            publishTagContext2 = publishTagContext.getParent() == null ? new PublishTagContext(publishTagContext.getPageContext()) : new PublishTagContext(publishTagContext.getParent(), tagItem, publishTagContext.getUpperHost());
            string = TagParseHelper.preparseChildTagItem(tagItem, publishTagContext2, "TRS_NOTEXISTSDATA");
            return new String[]{string};
        }
        int n = publishTagContext.getAttribute("STARTPOS", 0);
        if (n < 0) {
            n = 0;
        }
        int n2 = iTagParser4List.getRecordSize();
        int n3 = publishTagContext.getAttribute("NUM", 0);
        if (n3 <= 0) {
            n3 = n2;
        }
        int n4 = publishTagContext.getAttribute("PAGESIZE", 0);
        List list = tagItem.getChildren();
        boolean bl = tagItem.containsChild("TRS_RECORD");
        ArrayList<String> arrayList = new ArrayList<String>();
        TagParseResults tagParseResults = new TagParseResults();
        String[] stringArray = null;
        int n5 = 0;
        try {
            String[] stringArray2;
            PublishTagContext publishTagContext3;
            boolean bl2;
            iTagParser4List.setStartPos(n);
            if (publishTagContext.isPreview() && n4 > 0 && n3 > n4 && (bl2 = ConfigServer.getServer().getSysConfigValue("ONLY_FIRST_ON_PREVIEW", "false").trim().equalsIgnoreCase("true"))) {
                n3 = n4;
            }
            while (n5 < n3 && (publishTagContext3 = iTagParser4List.getNextRecordContext()) != null) {
                if (n4 > 0 && n5 / n4 > arrayList.size()) {
                    if (string != null) {
                        arrayList.add(string + tagParseResults.get(0));
                    } else {
                        arrayList.add(tagParseResults.get(0));
                    }
                    tagParseResults.clear();
                }
                if (!bl) {
                    stringArray = TagParseHelper.parseItems(list, publishTagContext3);
                    if (stringArray != null) {
                        tagParseResults.append(stringArray);
                    }
                    ++n5;
                    continue;
                }
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e instanceof String) {
                        tagParseResults.append((String)e);
                        continue;
                    }
                    if ("TRS_RECORD".equalsIgnoreCase(((TagItem)e).getName())) {
                        PublishTagContext publishTagContext4 = new PublishTagContext(publishTagContext, (TagItem)e);
                        int n6 = publishTagContext4.getAttribute("NUM", 1);
                        stringArray2 = new String[]{CMyString.showNull(publishTagContext4.getAttribute("SUPPLEMENT"), "")};
                        if (n6 <= 0) {
                            n6 = 1;
                        }
                        int n7 = 0;
                        for (n7 = 0; n7 < n6 && n5 < n3; ++n7) {
                            if (publishTagContext3 == null) {
                                publishTagContext3 = iTagParser4List.getNextRecordContext();
                            }
                            if (publishTagContext3 == null) {
                                tagParseResults.append(stringArray2);
                                continue;
                            }
                            stringArray = TagParseHelper.parseItems(((TagItem)e).getChildren(), publishTagContext3);
                            if (stringArray != null) {
                                tagParseResults.append(stringArray);
                            }
                            ++n5;
                            publishTagContext3 = null;
                        }
                        while (n7++ < n6) {
                            tagParseResults.append(stringArray2);
                        }
                        continue;
                    }
                    stringArray = TagParseHelper.parseItem((TagItem)e, publishTagContext3);
                    if (stringArray == null) continue;
                    tagParseResults.append(stringArray);
                }
            }
            if (string != null) {
                arrayList.add(string + tagParseResults.get(0));
            } else {
                arrayList.add(tagParseResults.get(0));
            }
            publishTagContext.getPageContext().setExtraAttribute("RECORD_COUNT", String.valueOf(n2));
            if (arrayList.size() > 1 && (bl2 = publishTagContext.getAttribute("WML", false))) {
                Template template = publishTagContext.getPageContext().getTemplate();
                stringArray2 = template.getOutputFileName();
                String string2 = template.getOutputFileExt();
                stringArray = new String[arrayList.size()];
                int n8 = stringArray.length;
                for (int i = 0; i < n8; ++i) {
                    stringArray[i] = arrayList.get(i) + "<br/>" + TagParseHelper.makeCurrNavContent((String)stringArray2, string2, i, n8);
                }
                String[] stringArray3 = stringArray;
                return stringArray3;
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            String[] stringArray4 = stringArray;
            return stringArray4;
        }
        finally {
            if (tagParseResults != null) {
                tagParseResults.clear();
            }
        }
    }

    private static String preparseChildTagItem(TagItem tagItem, PublishTagContext publishTagContext, String string) throws WCMException {
        List list = tagItem.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e == null || !(e instanceof TagItem) || !((TagItem)e).getName().equalsIgnoreCase(string)) continue;
            List list2 = ((TagItem)e).getChildren();
            String[] stringArray = TagParseHelper.parseItems(list2, publishTagContext);
            if (stringArray == null || stringArray.length <= 0) break;
            return stringArray[0];
        }
        return null;
    }

    private static String makeCurrNavContent(String string, String string2, int n, int n2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            string3 = null;
            string3 = n == 1 ? string + "." + string2 : string + "_" + (n - 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label2", "\">&lt;&lt;\u4e0a\u4e00\u9875</a>"));
            stringBuffer.append("&nbsp;&nbsp;");
        }
        if (n == 0 || n != n2 - 1) {
            string3 = string + "_" + (n + 1) + "." + string2;
            stringBuffer.append("<a href=\"" + string3 + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label3", "\">\u4e0b\u4e00\u9875&gt;&gt;</a>"));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4Children(TagItem tagItem, PublishTagContext publishTagContext) throws WCMException {
        List list = tagItem.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>();
        TagParseResults tagParseResults = new TagParseResults();
        String[] stringArray = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e instanceof String) {
                    tagParseResults.append((String)e);
                    continue;
                }
                stringArray = TagParseHelper.parseItem((TagItem)e, publishTagContext);
                if (stringArray == null) continue;
                tagParseResults.append(stringArray);
            }
            arrayList.add(tagParseResults.get(0));
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            if (tagParseResults != null) {
                tagParseResults.clear();
            }
        }
    }

    public static ArrayList makeSelectFields(TagItem tagItem, String string) {
        List list = tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        String string2 = string.toUpperCase();
        return TagParseHelper.makeSelectFields(tagItem, string2, arrayList);
    }

    private static ArrayList makeSelectFields(TagItem tagItem, String string, ArrayList arrayList) {
        List list = tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e == null || !(e instanceof TagItem)) continue;
            TagItem tagItem2 = (TagItem)e;
            if (tagItem2.getName().equals(string)) {
                String string2 = tagItem2.getAttribute("FIELD");
                if (CMyString.isEmpty(string2)) {
                    string2 = tagItem2.getAttribute("ID");
                }
                TagParseHelper.addField(arrayList, string2);
                continue;
            }
            TagParseHelper.makeSelectFields(tagItem2, string, arrayList);
        }
        return arrayList;
    }

    private static void addField(ArrayList arrayList, String string) {
        if (string == null || (string = string.trim()).length() <= 0) {
            return;
        }
        String string2 = null;
        string2 = string.charAt(0) == '#' ? "ATTRIBUTE" : string.toUpperCase();
        if (arrayList.indexOf(string2) < 0) {
            arrayList.add(string2);
        }
    }

    public static String addAutoLink(String string, String string2, String string3, PublishTagContext publishTagContext) {
        String string4 = publishTagContext.getAttribute("TARGET");
        String string5 = publishTagContext.getAttribute("EXTRA");
        String string6 = publishTagContext.getAttribute("LINKTEXT");
        String string7 = null;
        if (publishTagContext.getAttribute("LINKALT", false) && ((string7 = publishTagContext.getAttribute("LINKALTTEXT")) == null || (string7 = string7.trim()).length() == 0)) {
            string7 = string3;
        }
        return HtmlUtil.renderLink(string, string4, string7, string5, string2, string6);
    }

    public static String addSpanStyleIfNeeded(PublishTagContext publishTagContext, String string) {
        if (string == null) {
            return null;
        }
        String string2 = publishTagContext.getAttribute("CLASSNAME");
        if (string2 == null || string2.length() <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 16);
        stringBuffer.append("<SPAN class=\"").append(string2).append("\">");
        stringBuffer.append(string).append("</SPAN>");
        return stringBuffer.toString();
    }

    public static String[] addSpanStyleIfNeeded(PublishTagContext publishTagContext, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String string = publishTagContext.getAttribute("CLASSNAME");
        if (CMyString.isEmpty(string)) {
            return stringArray;
        }
        String string2 = stringArray[0];
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 128);
        stringBuffer.append("<span class='");
        stringBuffer.append(string);
        stringBuffer.append("'>");
        stringBuffer.append(string2);
        stringBuffer.append("</span>");
        stringArray[0] = stringBuffer.toString();
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuffer.setLength(0);
            stringBuffer.append("<span class='");
            stringBuffer.append(string);
            stringBuffer.append("'>");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("</span>");
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    public static String[] parseHtmlContent(String string, IPublishContent iPublishContent, PublishTagContext publishTagContext) throws WCMException {
        if (iPublishContent == null || iPublishContent.getSubstance() == null) {
            return null;
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        String string2 = null;
        try {
            String string3 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishContent.getRealHome());
            String string4 = PublishPathCompass.calSubDirectory(iPublishContent, false);
            String string5 = string3 + string4;
            if (!publishTagContext.getAttribute("UrlIsABS", false)) {
                string5 = HtmlUtil.calRelativePath(string5, publishTagContext.getPageHttpPath());
            }
            HTMLContent hTMLContent = new HTMLContent(string);
            string2 = hTMLContent.parseHTMLContent(string5);
            TagParseHelper.distributionHTMLContentFiles(iPublishContent, publishTagContext, hTMLContent.getWCMFiles());
            if (publishTagContext.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(string2);
            }
            return new String[]{string2};
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(TagParseHelper.class, "TagParseHelper.label4", "\u89e3\u6790 ") + iPublishContent.getInfo() + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label5", " \u7684\u6b63\u6587\u5931\u8d25!"), exception);
        }
    }

    public static void distributionHTMLContentFiles(IPublishContent iPublishContent, PublishTagContext publishTagContext, List list) throws WCMException {
        try {
            int n = list.size();
            if (n <= 0) {
                return;
            }
            boolean bl = publishTagContext.isPreview();
            PublishPathCompass publishPathCompass = publishTagContext.getPathCompass();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = (String)list.get(i);
                if (string2 == null || !CMyFile.fileExists(string = FilesMan.getFilesMan().mapFilePath(string2, 0) + string2)) continue;
                String string3 = publishPathCompass.getLocalPath(iPublishContent, bl);
                PublishSyncGlobalTuner.insureLocalPathExists(string3);
                CMyFile.copyFile(string, string3 + string2);
                if (bl) continue;
                publishTagContext.getFileDistributeShip().distributeFile(string, iPublishContent, null, true);
            }
        }
        catch (Exception exception) {
            publishTagContext.addWarning(I18NMessage.get(TagParseHelper.class, "TagParseHelper.label6", "\u53d1\u5e03") + iPublishContent.getInfo() + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label7", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(exception));
        }
    }

    private static String getPageNavigator(int n, int n2) {
        if (n2 <= 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append(TagParseHelper.getGotoPageScript(n));
        stringBuffer.append("<DIV id='idTRSNavigator' class='clsTRSNavigatorDIV'>");
        stringBuffer.append(TagParseHelper.getListNavigator(n, n2));
        stringBuffer.append("</DIV>");
        return stringBuffer.toString();
    }

    private static String getListNavigator(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(255);
        if (n != 0) {
            stringBuffer.append("<A id='idTRSListLink' class='clsTRSListLink' href='javascript:gotoPage(0);'>1</A>");
        } else {
            stringBuffer.append("1");
        }
        for (int i = 1; i < n2; ++i) {
            if (n != i) {
                stringBuffer.append(",<A id='idTRSListLink' class='idTRSListLink' href='javascript:gotoPage(" + i + ");'>");
                stringBuffer.append(i + 1);
                stringBuffer.append("</A>");
                continue;
            }
            stringBuffer.append(",");
            stringBuffer.append(i + 1);
        }
        return stringBuffer.toString();
    }

    private static String getGotoPageScript(int n) {
        String string = "\n<SCRIPT language=\"javascript\">\n<!--\n  var nPageIndex = " + n + "\n;" + "\n  var sValue = window.location.href;" + "\n  var nFileStartPos = sValue.lastIndexOf('/t');" + "\n  var sFile = sValue.substring(nFileNameStartPos);" + "\n  var nFileEndPos = sFile.indexOf('?');" + "\n  if(nFileEndPos < 0){" + "\n      nFileEndPos = sFile.indexOf('#');" + "\n  }" + "\n  if(nFileEndPos > 0){" + "\n      sFile = sFile.substring(0, nFileEndPos);" + "\n  }" + "\n" + "\n" + "\n  var nFileNameEndPos = sFile.lastIndexOf('.');   " + "\n  var sFileExt = sFile.substring(nFileNameEndPos+1);" + "\n  " + "\n  var sFileName = sFile.substring(0, nFileNameEndPos);" + "\n  if(nPageIndex>0){" + "\n      var nFileNameStartPos = sFileName.lastIndexOf('_'+nPageIndex);  " + "\n      sFileName = sFileName.substring(0, nFileNameStartPos);  " + "\n  }" + "\n  " + "\n  function gotoPage(_nPageIndex){" + "\n      var sURL = \"\";" + "\n      if(_nPageIndex>0){" + "\n          sURL = sFileName + \"_\" + _nPageIndex + \".\" + sFileExt;" + "\n      }else{" + "\n          sURL = sFileName +  \".\" + sFileExt;" + "\n      }" + "\n" + "\n      window.location.href = sURL;" + "\n      return false;" + "\n  }" + "\n  " + "\n//-->" + "\n</SCRIPT>";
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            String string = CMyFile.readFile("c:\\test.html");
            System.out.println("==============Src==================");
            System.out.println(string);
            String[] stringArray2 = TagParseHelper.separatePages(string);
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("==============Sep" + i + "==================");
                System.out.println(stringArray2[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String[] parseContent(IPublishElement iPublishElement, String string) throws Exception {
        return TagParseHelper.parseContent(iPublishElement, string, "NORM");
    }

    public static boolean isVisualParseMode(PublishTagContext publishTagContext) {
        String string = publishTagContext.getPageContext().getExtraAttribute("_ParseMode_");
        return "EDIT".equals(string);
    }

    public static String[] parseContent(IPublishElement iPublishElement, String string, String string2) throws Exception {
        TagDocument tagDocument = TagDocumentReader.read(string);
        IPublishFolder iPublishFolder = null;
        if (iPublishElement instanceof IPublishFolder) {
            iPublishFolder = (IPublishFolder)iPublishElement;
        } else {
            iPublishFolder = ((IPublishContent)iPublishElement).getRealHome();
            if (iPublishElement.getFolder() == null) {
                ((IPublishContent)iPublishElement).setFolder(iPublishFolder);
            }
        }
        PublishTaskContext publishTaskContext = new PublishTaskContext(null, iPublishFolder);
        PublishPageContext publishPageContext = new PublishPageContext(iPublishElement, publishTaskContext);
        if (string2 != null) {
            publishPageContext.setExtraAttribute("_ParseMode_", string2);
        }
        PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
        return TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext);
    }

    static {
        s_oNamesRegister.register("HTML", 1);
        s_oNamesRegister.register("HTMLVALUE", 2);
        s_oNamesRegister.register("JAVASCRIPT", 3);
        s_oNamesRegister.register("JS", 3);
        s_oNamesRegister.register("XML", 4);
        s_oNamesRegister.register("INNERTEXT", 5);
        SPECIAL_TAG_SET = new HashSet(2);
        SPECIAL_TAG_SET.add("TRS_VARIABLE");
        SPECIAL_TAG_SET.add("TRS_ENUM");
    }
}

