/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;

public class TagItem
implements IClearable {
    private String m_sName;
    private HashMap m_hAttributes = null;
    private Hashtable m_hExtraAttributes = null;
    private HashMap m_hVariableParameters = null;
    private List m_children = null;
    private int m_iBeginLineNo;
    private int m_iBeginColumn;
    private int m_iCloseLineNo;
    private int m_iCloseColumn;
    private TagItem m_parentItem;
    private boolean m_zIsVariableDeclare;
    private TemplateParameter m_oVariableParameter;

    public static final boolean isVariableParameter(String string) {
        if (string == null || string.length() <= 3) {
            return false;
        }
        return string.charAt(0) == '$' && string.charAt(1) == '{' && string.charAt(string.length() - 1) == '}';
    }

    public static final boolean isVariableDeclare(String string) {
        return "TRS_VARIABLE".equals(string);
    }

    public void clear() {
        if (this.m_hAttributes != null && !this.m_hAttributes.isEmpty()) {
            this.m_hAttributes.clear();
        }
        if (this.m_children != null && !this.m_children.isEmpty()) {
            ContainerUtil.clearContainer((List)this.m_children);
        }
        if (this.m_hExtraAttributes != null && !this.m_hExtraAttributes.isEmpty()) {
            this.m_hExtraAttributes.clear();
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        if (string != null) {
            string = string.toUpperCase();
        }
        if (this.m_sName == null) {
            this.m_sName = string;
            this.m_zIsVariableDeclare = TagItem.isVariableDeclare(string);
            if (this.m_zIsVariableDeclare) {
                this.m_oVariableParameter = new TemplateParameter();
                this.m_hVariableParameters = new HashMap();
                this.m_hVariableParameters.put(null, this.m_oVariableParameter);
            }
        } else {
            this.m_sName = string;
            this.m_zIsVariableDeclare = false;
        }
    }

    public HashMap getAttributes() {
        return this.m_hAttributes;
    }

    public String getAttribute(String string) {
        if (this.m_hAttributes == null || string == null) {
            return null;
        }
        return (String)this.m_hAttributes.get(string.toUpperCase());
    }

    public String getAttributeTrim(String string) {
        String string2 = this.getAttribute(string);
        return string2 == null ? null : string2.trim();
    }

    public String getRequiredAttribute(String string) throws WCMException {
        String string2 = this.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            throw new WCMException(1106, "Attribute [" + string + "] required!");
        }
        return string2;
    }

    public String getRequiredAttributeTrim(String string) throws WCMException {
        String string2 = this.getAttributeTrim(string);
        if (string2 == null || string2.length() == 0) {
            throw new WCMException(1106, "Property [" + string + "] required!");
        }
        return string2;
    }

    public int getIntAttribute(String string, int n) throws WCMException {
        String string2 = this.getAttributeTrim(string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new WCMException(2, "Value [" + string2 + "] of attribute [" + n + "] is not integer!", exception);
        }
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        String string2 = this.getAttribute(string);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    public void setAttributes(HashMap hashMap) {
        this.m_hAttributes = hashMap;
    }

    public void setAttribute(String string, String string2) throws WCMException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new WCMException(10, "Property name required!");
        }
        string = string.toUpperCase();
        if (string2 == null) {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(string, string2);
            } else if (this.m_hVariableParameters != null) {
                this.m_hVariableParameters.remove(string);
            }
            if (this.m_hAttributes != null) {
                this.m_hAttributes.remove(string);
            }
        } else {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(string, string2);
            } else if (TagItem.isVariableParameter(string2)) {
                this.setVariableParameter(string, string2);
            }
            if (this.m_hAttributes == null) {
                this.m_hAttributes = new HashMap();
            }
            this.m_hAttributes.put(string.toUpperCase(), string2);
        }
    }

    public void setAttribute(String string, int n) throws WCMException {
        this.setAttribute(string, String.valueOf(n));
    }

    public void setAttribute(String string, boolean bl) throws WCMException {
        this.setAttribute(string, bl ? "true" : "false");
    }

    public String removeAttribute(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        if (this.m_hVariableParameters != null) {
            this.m_hVariableParameters.remove(string);
        }
        if (this.m_hAttributes != null) {
            return (String)this.m_hAttributes.remove(string);
        }
        return null;
    }

    public List getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    public boolean containsChild(String string) {
        if (this.m_children == null) {
            return false;
        }
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.m_children.get(i);
            if (e == null || !(e instanceof TagItem) || !((TagItem)e).getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String getText() {
        Object e;
        if (this.m_children != null && !this.m_children.isEmpty() && (e = this.m_children.get(0)) != null && e instanceof String) {
            return (String)e;
        }
        return null;
    }

    public String setText(String string) {
        String string2 = this.getText();
        if (string == null) {
            return string2;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        if (this.m_children.isEmpty()) {
            this.m_children.add(string);
        } else {
            Object e = this.m_children.get(0);
            if (e != null && e instanceof String) {
                this.m_children.set(0, string);
            } else {
                this.m_children.add(0, string);
            }
        }
        return string2;
    }

    public void setChildren(List list) {
        this.m_children = list;
    }

    public void addChild(TagItem tagItem) {
        if (tagItem == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(tagItem);
        if (this.m_oVariableParameter != null && "TRS_ENUM".equals(tagItem.getName())) {
            this.m_oVariableParameter.addEnumValue(tagItem.getAttribute("VALUE"), tagItem.getAttribute("DISPLAY"));
        }
    }

    public void addChild(String string) {
        if (string == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(this.getName());
        if (this.m_hAttributes != null) {
            for (Map.Entry entry : this.m_hAttributes.entrySet()) {
                stringBuffer.append(' ').append(entry.getKey()).append("=\"");
                stringBuffer.append(CMyString.replaceStr((String)entry.getValue(), "\"", "\\\""));
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                Iterator iterator = this.m_children.get(i);
                if (iterator instanceof TagItem) {
                    stringBuffer.append(((TagItem)((Object)iterator)).toString());
                    continue;
                }
                stringBuffer.append(iterator.toString());
            }
        }
        stringBuffer.append("</").append(this.getName()).append(">");
        return stringBuffer.toString();
    }

    public int getBeginColumn() {
        return this.m_iBeginColumn;
    }

    public void setBeginColumn(int n) {
        this.m_iBeginColumn = n;
    }

    public int getBeginLineNo() {
        return this.m_iBeginLineNo;
    }

    public void setBeginLineNo(int n) {
        this.m_iBeginLineNo = n;
    }

    public int getCloseColumn() {
        return this.m_iCloseColumn;
    }

    public void setCloseColumn(int n) {
        this.m_iCloseColumn = n;
    }

    public int getCloseLineNo() {
        return this.m_iCloseLineNo;
    }

    public void setCloseLineNo(int n) {
        this.m_iCloseLineNo = n;
    }

    public String getDescWithPos() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getName());
        stringBuffer.append(I18NMessage.get(TagItem.class, "TagItem.label1", "[\u884c:")).append(this.m_iBeginLineNo).append(',');
        stringBuffer.append(I18NMessage.get(TagItem.class, "TagItem.label2", "\u5217:")).append(this.m_iBeginColumn).append(']');
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public void setExtraAttribute(String string, String string2) {
        if (this.m_hExtraAttributes == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
            hashtable.put(string.toUpperCase(), string2);
            this.m_hExtraAttributes = hashtable;
        } else {
            this.m_hExtraAttributes.put(string.toUpperCase(), string2);
        }
    }

    public String getExtraAttributeValue(String string) {
        if (this.m_hExtraAttributes == null) {
            return null;
        }
        Object v = this.m_hExtraAttributes.get(string.toUpperCase());
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public HashMap getVariableParameters() {
        return this.m_hVariableParameters;
    }

    public TemplateParameter getVariableParameter(String string) {
        if (string == null || this.m_hVariableParameters == null) {
            return null;
        }
        return (TemplateParameter)this.m_hVariableParameters.get(string.toUpperCase());
    }

    private void setVariableParameter(String string, String string2) {
        if (this.m_hVariableParameters == null) {
            this.m_hVariableParameters = new HashMap();
        }
        TemplateParameter templateParameter = new TemplateParameter();
        this.m_hVariableParameters.put(string, templateParameter);
        String string3 = string2.substring(2, string2.length() - 1);
        int n = string3.indexOf(126);
        if (n <= 0) {
            templateParameter.setParameterName(string3);
            return;
        }
        templateParameter.setParameterName(string3.substring(0, n++));
        int n2 = string3.indexOf(126, n);
        if (n2 <= 0) {
            templateParameter.setParameterType(TemplateParameter.Type.STRING);
            templateParameter.setParameterDefault(string3.substring(n));
            return;
        }
        templateParameter.setParameterType(string3.substring(n, n2++));
        int n3 = string3.indexOf(126, n2);
        if (n3 <= 0) {
            templateParameter.setParameterDefault(string3.substring(n2));
            return;
        }
        templateParameter.setParameterDefault(string3.substring(n2, n3++));
        int n4 = 0;
        int n5 = n3;
        while ((n4 = string3.indexOf(126, n5)) > 0) {
            templateParameter.addEnumValue(string3.substring(n5, n4));
            n5 = n4 + 1;
        }
        if (n5 < string3.length()) {
            templateParameter.addEnumValue(string3.substring(n5));
        } else {
            templateParameter.setCanCustom(true);
        }
    }

    private void parseVariableDeclare(String string, String string2) {
        if (this.m_oVariableParameter == null) {
            throw new IllegalStateException("'m_oVariableParameter' is null");
        }
        if ("NAME".equals(string)) {
            if (string2 == null) {
                throw new IllegalArgumentException("'Variable name' is null");
            }
            this.m_oVariableParameter.setParameterName(string2);
            return;
        }
        if ("TYPE".equals(string)) {
            this.m_oVariableParameter.setParameterType(string2);
            return;
        }
        if ("DEFAULT".equals(string)) {
            this.m_oVariableParameter.setParameterDefault(string2);
            return;
        }
        if ("SPLIT".equals(string)) {
            if (string2 != null && (string2 = string2.trim()).length() == 1) {
                this.m_oVariableParameter.setEnumSplit(string2.charAt(0));
            }
            return;
        }
        if ("ENUMERATE".equals(string)) {
            this.m_oVariableParameter.addEnumValue(string2);
            return;
        }
        if ("CANCUSTOM".equals(string)) {
            this.m_oVariableParameter.setCanCustom("true".equalsIgnoreCase(string2));
            return;
        }
    }

    public Iterator findItems(final String[] stringArray) {
        Iterator iterator = new Iterator(){
            int m_iCurrentIndex = -1;
            List m_oCurrentList = TagItem.access$000(TagItem.this);
            TagItem m_oCurrentItem = null;
            Stack m_oStack = new Stack();

            public void remove() {
            }

            public boolean hasNext() {
                return this.m_oCurrentItem != null || this.findNext();
            }

            public Object next() {
                if (this.m_oCurrentItem != null || this.findNext()) {
                    TagItem tagItem = this.m_oCurrentItem;
                    this.m_oCurrentItem = null;
                    return tagItem;
                }
                return null;
            }

            /*
             * Unable to fully structure code
             */
            private boolean findNext() {
                block0: while (true) {
                    ++this.m_iCurrentIndex;
                    while (this.m_iCurrentIndex >= this.m_oCurrentList.size()) {
                        if (this.m_oStack.isEmpty()) {
                            return false;
                        }
                        this.m_oCurrentList = (List)this.m_oStack.pop();
                        this.m_iCurrentIndex = (Integer)this.m_oStack.pop();
                        ++this.m_iCurrentIndex;
                    }
                    var1_1 = this.m_oCurrentList.get(this.m_iCurrentIndex);
                    if (!(var1_1 instanceof TagItem)) continue;
                    var2_2 = (TagItem)var1_1;
                    if (var2_2.hasChildren()) {
                        this.m_oStack.push(new Integer(this.m_iCurrentIndex));
                        this.m_oStack.push(this.m_oCurrentList);
                        this.m_oCurrentList = var2_2.getChildren();
                        this.m_iCurrentIndex = -1;
                    }
                    if (stringArray == null || stringArray.length == 0) {
                        this.m_oCurrentItem = var2_2;
                        return true;
                    }
                    var3_3 = var2_2.getName();
                    var4_4 = 0;
                    while (true) {
                        if (var4_4 < stringArray.length) ** break;
                        continue block0;
                        if (var3_3.equalsIgnoreCase(stringArray[var4_4])) {
                            this.m_oCurrentItem = var2_2;
                            return true;
                        }
                        ++var4_4;
                    }
                    break;
                }
            }
        };
        return iterator;
    }

    public void setParent(TagItem tagItem) {
        this.m_parentItem = tagItem;
    }

    public TagItem getParent() {
        return this.m_parentItem;
    }

    public List findParentItems() {
        ArrayList<TagItem> arrayList = new ArrayList<TagItem>(3);
        for (TagItem tagItem = this.m_parentItem; tagItem != null; tagItem = tagItem.getParent()) {
            arrayList.add(tagItem);
        }
        return arrayList;
    }

    static /* synthetic */ List access$000(TagItem tagItem) {
        return tagItem.m_children;
    }
}

