/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.components.common.publish.domain.tagparser.ScanContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagFormatHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import java.util.List;
import org.apache.log4j.Logger;

public class TagDocumentReader {
    public static boolean IS_DEBUG = false;
    private static final Logger logger = Logger.getLogger((String)TagDocumentReader.class.getName());
    public static final int ST_TAGNAME = 1;
    public static final int ST_TAGNAME_END = 2;
    public static final int ST_ATTRNAME = 3;
    public static final int ST_ATTRNAME_END = 4;
    public static final int ST_ATTRVALUE_HASQUOTE = 5;
    public static final int ST_ATTRVALUE_NOQUOTE = 6;
    public static final int ST_ATTRVALUE_END = 7;
    public static final int ST_STARTTAG_END = 8;
    public static final int ST_CHILD_BEGIN = 9;
    public static final int ST_CHILD_TAGITEM = 10;
    public static final int ST_CHILD_STRING = 11;
    public static final int ST_CHILD_STRING_END = 12;
    public static final int ST_ENDTAG_CHECK = 93;
    public static final int ST_SELFCLOSEDTAG_CHECK = 95;
    public static final int ST_ATTRVALUE_HASQUOTE_BEGIN = 13;
    public static final int ST_ATTRVALUE_HASQUOTE_ENDCHECK = 14;
    private static char[][][] READING_MAP = new char[][][]{new char[][]{{'\u0001'}}, new char[][]{{'\u0001'}, {' ', '\u0002'}, {'/', '\u0002'}, {'>', '\u0002'}}, new char[][]{{'\u0003'}, {'>', '\b'}, {'/', '_'}}, new char[][]{{'\u0003'}, {'=', '\u0004'}, {'/', '\u0004'}, {'>', '\u0004'}}, new char[][]{{'\u0006'}, {' ', '\u0007'}, {'/', '\u0007'}, {'>', '\u0007'}, {'\"', '\r'}, {'\'', '\r'}}, new char[][]{{'\u0005'}, {'\"', '\u000e'}, {'\'', '\u000e'}}, new char[][]{{'\u0006'}, {'/', '\u0007'}, {'>', '\u0007'}, {' ', '\u0007'}}, new char[][]{{'\u0003'}, {'>', '\b'}, {'/', '_'}}, new char[][]{{'\t'}, {'<', '/', ']'}}, new char[][]{{'\u000b'}, {'<', '/', 'T', 'R', 'S', '_', ']'}, {'<', 'T', 'R', 'S', '_', '\n'}}, new char[][]{{'\t'}}, new char[][]{{'\u000b'}, {'<', '/', 'T', 'R', 'S', '_', '\f'}, {'<', 'T', 'R', 'S', '_', '\f'}}, new char[][]{{'x'}, {'<', '/', ']'}, {'<', '\t'}}};

    private TagDocumentReader() {
    }

    public static TagDocument read(String string) throws Exception {
        if (string == null) {
            throw new WCMException(10, "Tag document content required.");
        }
        TagDocument tagDocument = new TagDocument();
        ScanContext scanContext = new ScanContext(string);
        if (!scanContext.hasChar()) {
            return tagDocument;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 9;
        int n2 = 0;
        block7: while (scanContext.hasChar()) {
            char c = scanContext.getChar();
            if (IS_DEBUG) {
                System.out.print("CS=" + n + "; Char=" + c + "; nPos=" + scanContext.getOffset());
            }
            n = TagDocumentReader.lookupNextStatus(n, scanContext);
            if (IS_DEBUG) {
                System.out.println("; NS=" + n);
            }
            switch (n) {
                case 93: {
                    throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label1", "\u975e\u9884\u671f\u7684\u7ed3\u675f\u7f6e\u6807! ") + scanContext.lookAround(n2));
                }
                case 11: {
                    stringBuffer.append(c);
                    scanContext.skipChar();
                    continue block7;
                }
                case 9: {
                    continue block7;
                }
                case 10: {
                    n2 = scanContext.getOffset();
                    TagItem tagItem = TagDocumentReader.readItem(scanContext);
                    tagDocument.addItem(tagItem);
                    continue block7;
                }
                case 12: {
                    tagDocument.addItem(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue block7;
                }
            }
            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label2", "\u672a\u77e5\u7684\u8f6c\u79fb\u72b6\u6001:") + n + scanContext.lookAround(n2));
        }
        if (stringBuffer.length() > 0) {
            tagDocument.addItem(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        int n3 = tagDocument.getItemCount();
        for (int i = 0; i < n3; ++i) {
            Object object = tagDocument.getItemAt(i);
            if (!(object instanceof TagItem)) continue;
            TagDocumentReader.formateItem((TagItem)object);
        }
        return tagDocument;
    }

    private static void formateItem(TagItem tagItem) throws WCMException {
        if (tagItem == null) {
            return;
        }
        TagDocumentReader.standardizeTagItem(tagItem);
        List list = tagItem.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof TagItem)) continue;
            TagDocumentReader.formateItem((TagItem)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookAround(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n3;
            int n4;
            if (n2 >= cArray.length) {
                n2 = cArray.length - 1;
            }
            if ((n4 = n2 - n) < 160) {
                for (n3 = n; n3 <= n2; ++n3) {
                    stringBuffer.append(cArray[n3]);
                }
            } else {
                int n5 = n + 79;
                for (n3 = n; n3 <= n5; ++n3) {
                    stringBuffer.append(cArray[n3]);
                }
                stringBuffer.append("...");
                for (n3 = n2 - 79; n3 <= n2; ++n3) {
                    stringBuffer.append(cArray[n3]);
                }
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            stringBuffer.setLength(0);
        }
    }

    private static TagItem readItem(ScanContext scanContext) throws Exception {
        TagItem tagItem = new TagItem();
        tagItem.setBeginColumn(scanContext.getColumn());
        tagItem.setBeginLineNo(scanContext.getLineNo());
        if (!scanContext.hasChar()) {
            return tagItem;
        }
        int n = scanContext.getOffset();
        int n2 = 1;
        scanContext.skipChar();
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            Object object;
            block24: while (scanContext.hasChar()) {
                char c2 = scanContext.getChar();
                if (IS_DEBUG) {
                    System.out.print("CS=" + n2 + "; Char=" + c2 + "; nPos=" + scanContext.getOffset());
                }
                n2 = TagDocumentReader.lookupNextStatus(n2, scanContext);
                if (IS_DEBUG) {
                    System.out.println("; NS=" + n2);
                }
                switch (n2) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 11: {
                        stringBuffer.append(c2);
                        scanContext.skipChar();
                        continue block24;
                    }
                    case 2: {
                        if (stringBuffer.length() == 0) {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label3", "\u7f3a\u5c11\u7f6e\u6807\u540d\u79f0! ") + scanContext.lookAround(n));
                        }
                        tagItem.setName(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        while (scanContext.hasChar() && Character.isWhitespace(scanContext.getChar())) {
                            scanContext.skipChar();
                        }
                        continue block24;
                    }
                    case 4: {
                        if (c2 != '=') {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label4", "\u7f6e\u6807\u5c5e\u6027[") + stringBuffer.toString() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label5", "]\u7f3a\u5c11'='! ") + scanContext.lookAround(n));
                        }
                        if (stringBuffer.length() == 0) {
                            throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label6", "\u7f3a\u5c11\u7f6e\u6807\u5c5e\u6027\u540d\u79f0! ") + scanContext.lookAround(n));
                        }
                        string = stringBuffer.toString().trim();
                        stringBuffer.setLength(0);
                        scanContext.skipChar();
                        while (scanContext.hasChar() && Character.isWhitespace(scanContext.getChar())) {
                            scanContext.skipChar();
                        }
                        continue block24;
                    }
                    case 13: {
                        c = c2;
                        n2 = 5;
                        scanContext.skipChar();
                        continue block24;
                    }
                    case 14: {
                        if (c2 != c || scanContext.prevChar() == '\\') {
                            stringBuffer.append(c2);
                            scanContext.skipChar();
                            n2 = 5;
                            continue block24;
                        }
                        n2 = 7;
                        scanContext.skipChar();
                    }
                    case 7: {
                        tagItem.setAttribute(string, stringBuffer.toString());
                        stringBuffer.setLength(0);
                        while (scanContext.hasChar() && Character.isWhitespace(scanContext.getChar())) {
                            scanContext.skipChar();
                        }
                        continue block24;
                    }
                    case 8: {
                        scanContext.skipChar();
                        continue block24;
                    }
                    case 9: {
                        continue block24;
                    }
                    case 10: {
                        object = TagDocumentReader.readItem(scanContext);
                        tagItem.addChild((TagItem)object);
                        ((TagItem)object).setParent(tagItem);
                        continue block24;
                    }
                    case 12: {
                        tagItem.addChild(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        continue block24;
                    }
                    case 93: {
                        scanContext.skipChar();
                        scanContext.skipChar();
                        object = (tagItem.getName() + '>').toCharArray();
                        boolean bl = true;
                        scanContext.mark();
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            if (!scanContext.hasChar()) {
                                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + tagItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label8", " \u6ca1\u6709\u7ed3\u675f! ") + scanContext.lookAround(n));
                            }
                            char c3 = scanContext.getChar();
                            scanContext.skipChar();
                            Object object2 = object[i];
                            if (c3 == object2 || Character.toUpperCase(c3) == object2) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            tagItem.setCloseColumn(scanContext.getColumn());
                            tagItem.setCloseLineNo(scanContext.getLength());
                            return tagItem;
                        }
                        n2 = 11;
                        stringBuffer.append("</");
                        scanContext.reset();
                        continue block24;
                    }
                    case 95: {
                        scanContext.skipChar();
                        if (scanContext.hasChar() && scanContext.getChar() == '>') {
                            scanContext.skipChar();
                            tagItem.setCloseColumn(scanContext.getColumn());
                            tagItem.setCloseLineNo(scanContext.getLength());
                            return tagItem;
                        }
                        throw new WCMDatainvalidException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + tagItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label9", " \u7f3a\u5c11\u7ed3\u675f\u5b57\u7b26'>'! ") + scanContext.lookAround(n));
                    }
                }
                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label2", "\u672a\u77e5\u7684\u8f6c\u79fb\u72b6\u6001:") + n2 + scanContext.lookAround(n));
            }
            object = null;
            switch (n2) {
                case 1: {
                    tagItem.setName(stringBuffer.toString());
                }
                case 2: {
                    object = "close tag required. ";
                    break;
                }
                case 3: 
                case 4: {
                    object = "value of attribute [" + string + "] is required. ";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 14: {
                    object = "value of attribute [" + string + "] is not closed. ";
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    object = I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label10", "\u7f3a\u5c11\u7ed3\u675f\u7f6e\u6807!");
                    break;
                }
                case 10: {
                    object = "tag item child is not closed. ";
                }
            }
            if (object != null) {
                throw new WCMException(232, I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label7", "\u7f6e\u6807 ") + tagItem.getDescWithPos() + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label11", " \u6709\u9519\u8bef:") + (String)object + scanContext.lookAround(n) + I18NMessage.get(TagDocumentReader.class, "TagDocumentReader.label12", " [\u72b6\u6001=") + n2 + "] ");
            }
            tagItem.setCloseColumn(scanContext.getColumn());
            tagItem.setCloseLineNo(scanContext.getLength());
            return tagItem;
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to read tag item while parsed result is: " + tagItem.toString()), (Throwable)exception);
            tagItem.clear();
            stringBuffer.setLength(0);
            throw exception;
        }
    }

    private static void standardizeTagItem(TagItem tagItem) throws WCMException {
        String string;
        if (tagItem.getName().equalsIgnoreCase("TRS_OUTLINE")) {
            tagItem.removeAttribute("TYPE");
        }
        if ((string = tagItem.getAttributeTrim("ID")) != null && string.length() > 4 && string.substring(0, 4).equalsIgnoreCase("_TRS")) {
            tagItem.setName("TRS_" + string.substring(4));
            tagItem.removeAttribute("ID");
        }
        tagItem.removeAttribute("TRS_OUTLINE_DESC");
        TagFormatHelper.standardize(tagItem);
    }

    public static int lookupNextStatus(int n, ScanContext scanContext) throws Exception {
        if (n >= READING_MAP.length) {
            throw new WCMException(10, "No route is found for status " + n);
        }
        char[][] cArray = READING_MAP[n];
        for (int i = 1; i < cArray.length; ++i) {
            int n2;
            char[] cArray2 = cArray[i];
            boolean bl = true;
            scanContext.mark();
            for (n2 = 0; n2 < cArray2.length - 1; ++n2) {
                if (scanContext.hasChar()) {
                    char c = cArray2[n2];
                    char c2 = scanContext.getChar();
                    scanContext.skipChar();
                    if (c == c2 || c == ' ' && Character.isWhitespace(c2) || c == Character.toUpperCase(c2)) continue;
                }
                bl = false;
                break;
            }
            scanContext.reset();
            if (!bl) continue;
            return cArray2[n2];
        }
        return cArray[0][0];
    }
}

