/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.infra.I18NMessage;

public class ScanContext {
    private String m_sText;
    private int m_iLineNo = 1;
    private int m_iColumn = 1;
    private int m_iOffset;
    private int m_iMarkedLineNo;
    private int m_iMarkedColumn;
    private int m_iMarkedOffset;

    public ScanContext(String string) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException(I18NMessage.get(ScanContext.class, "ScanContext.label1", "\u6a21\u677f\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.m_sText = string;
    }

    public boolean hasChar() {
        return this.m_iOffset < this.m_sText.length();
    }

    public char getChar() {
        return this.m_sText.charAt(this.m_iOffset);
    }

    public char prevChar() {
        return this.m_sText.charAt(this.m_iOffset - 1);
    }

    public void skipChar() {
        char c;
        if (this.m_iOffset >= this.m_sText.length()) {
            return;
        }
        if ((c = this.m_sText.charAt(this.m_iOffset++)) == '\n') {
            ++this.m_iLineNo;
            this.m_iColumn = 1;
        } else {
            ++this.m_iColumn;
        }
    }

    public int getColumn() {
        return this.m_iColumn;
    }

    public int getLineNo() {
        return this.m_iLineNo;
    }

    public int getOffset() {
        return this.m_iOffset;
    }

    public int getLength() {
        return this.m_sText.length();
    }

    public void mark() {
        this.m_iMarkedLineNo = this.m_iLineNo;
        this.m_iMarkedColumn = this.m_iColumn;
        this.m_iMarkedOffset = this.m_iOffset;
    }

    public void reset() {
        this.m_iLineNo = this.m_iMarkedLineNo;
        this.m_iColumn = this.m_iMarkedColumn;
        this.m_iOffset = this.m_iMarkedOffset;
    }

    public String lookAround(int n) {
        return this.lookAround(n, this.m_iOffset);
    }

    public String lookAround(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append('(');
        stringBuffer.append(I18NMessage.get(ScanContext.class, "ScanContext.label2", "\u884c=")).append(this.getLineNo()).append(',');
        stringBuffer.append(I18NMessage.get(ScanContext.class, "ScanContext.label3", "\u5217=")).append(this.getColumn()).append(',');
        stringBuffer.append(I18NMessage.get(ScanContext.class, "ScanContext.label4", "\u504f\u79fb=")).append(this.getOffset()).append(',');
        stringBuffer.append(I18NMessage.get(ScanContext.class, "ScanContext.label5", "\u6e90\u7801="));
        if (n2 >= this.m_sText.length()) {
            n2 = this.m_sText.length();
        }
        if (n2 - n < 160) {
            stringBuffer.append(this.m_sText.substring(n, n2));
        } else {
            stringBuffer.append(this.m_sText.substring(n, n + 79));
            stringBuffer.append("...");
            stringBuffer.append(this.m_sText.substring(n2 - 79, n2));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

