/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishTagContext {
    private static final Logger s_logger = Logger.getLogger(PublishTagContext.class);
    private PublishPageContext m_pageContext;
    private IPublishElement m_upperHost;
    private PublishTagContext m_parent;
    private Map m_extraAttributes;
    private IPublishFolder m_upperFolder = null;
    private TagItem m_oCurrTagItem = null;
    private HashMap m_mVariableArgument = null;
    private String m_sPrefixOfArgument = null;
    private ITagParser4List m_oTagParser4List;
    private int m_iSequenceNumber;
    public static final String ATTRNAME_CURR_NESTTAGITEM = "CURR.NEST.TEMPNAM";
    private TagItem m_oPreNestTemplateTagItem = null;
    private TagItem m_oCurrNestTemplateTagItem = null;

    public PublishTagContext(IPublishElement iPublishElement, Map map, PublishPageContext publishPageContext) {
        this(iPublishElement, map, null, publishPageContext);
    }

    public PublishTagContext(IPublishElement iPublishElement, Map map, PublishTagContext publishTagContext) {
        this(iPublishElement, map, publishTagContext, publishTagContext.getPageContext());
    }

    private PublishTagContext(IPublishElement iPublishElement, Map map, PublishTagContext publishTagContext, PublishPageContext publishPageContext) {
        this.m_extraAttributes = map;
        this.m_pageContext = publishPageContext;
        this.m_parent = publishTagContext;
        this.setUpperHost(iPublishElement);
    }

    public PublishTagContext(PublishPageContext publishPageContext) {
        this.m_oCurrTagItem = null;
        this.m_parent = null;
        this.m_pageContext = publishPageContext;
        this.m_upperHost = publishPageContext.getPageElement();
        try {
            this.m_mVariableArgument = this.m_upperHost.getTemplateArguments();
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(PublishTagContext.class, "PublishTagContext.label1", "\u83b7\u53d6\u53d1\u5e03\u5bf9\u8c61\u7684\u6a21\u677f\u53c2\u6570\u503c\u5217\u8868\u5931\u8d25"), (Throwable)exception);
        }
        this.m_sPrefixOfArgument = null;
    }

    public PublishTagContext(PublishTagContext publishTagContext, TagItem tagItem) {
        this.init(publishTagContext, tagItem, null);
    }

    public PublishTagContext(PublishTagContext publishTagContext, TagItem tagItem, ITagParser4List iTagParser4List) {
        this.init(publishTagContext, tagItem, null);
        this.m_oTagParser4List = iTagParser4List;
    }

    public PublishTagContext(PublishTagContext publishTagContext, TagItem tagItem, IPublishElement iPublishElement) {
        this.init(publishTagContext, tagItem, iPublishElement);
    }

    private void init(PublishTagContext publishTagContext, TagItem tagItem, IPublishElement iPublishElement) {
        this.m_parent = publishTagContext;
        this.m_oCurrTagItem = tagItem;
        this.m_upperHost = iPublishElement;
        this.m_pageContext = publishTagContext.getPageContext();
        this.m_oTagParser4List = publishTagContext.getTagParser4List();
        this.m_mVariableArgument = publishTagContext.m_mVariableArgument;
        this.m_sPrefixOfArgument = publishTagContext.m_sPrefixOfArgument;
        this.m_oCurrNestTemplateTagItem = publishTagContext.m_oCurrNestTemplateTagItem;
        this.m_oPreNestTemplateTagItem = publishTagContext.m_oCurrNestTemplateTagItem;
    }

    public ITagParser4List getTagParser4List() {
        return this.m_oTagParser4List;
    }

    public IPublishElement getUpperHost() {
        if (this.m_upperHost == null && this.m_oTagParser4List != null) {
            try {
                this.m_oTagParser4List.substantiateContext(this);
            }
            catch (Exception exception) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label2", "\u4f7f\u7528[") + this.m_oTagParser4List + I18NMessage.get(PublishTagContext.class, "PublishTagContext.label3", "]\u5b9e\u4f53\u5316[") + this + I18NMessage.get(PublishTagContext.class, "PublishTagContext.label4", "]\u65f6\u53d1\u751f\u9519\u8bef")), (Throwable)exception);
            }
        }
        return this.m_upperHost;
    }

    public void setUpperHost(IPublishElement iPublishElement) {
        this.m_upperHost = iPublishElement;
    }

    public PublishTagContext getParent() {
        return this.m_parent;
    }

    public void setParent(PublishTagContext publishTagContext) {
        this.m_parent = publishTagContext;
    }

    public PublishPageContext getPageContext() {
        return this.m_pageContext;
    }

    public Map getExtraAttributes() {
        return this.m_extraAttributes;
    }

    public String getExtraAttribute(String string) {
        if (this.m_extraAttributes == null) {
            return null;
        }
        return (String)this.m_extraAttributes.get(string.toUpperCase());
    }

    public boolean getBooleanExtraAttribute(String string, boolean bl) {
        String string2 = this.getExtraAttribute(string);
        if (string2 == null || (string2 = string2.trim()).length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    public void setExtraAttributes(Map map) {
        this.m_extraAttributes = map;
    }

    public boolean isPreview() {
        return this.m_pageContext.isPreview();
    }

    public IPublishFolder getPageFolder() {
        return this.m_pageContext.getPageFolder();
    }

    public IPublishElement getPageElement() {
        return this.m_pageContext.getPageElement();
    }

    public String getPageHttpPath() throws WCMException {
        return this.m_pageContext.getPageHttpPath();
    }

    public IPublishFolder getRoot() throws WCMException {
        return this.m_pageContext.getRoot();
    }

    public void addWarning(String string, int n, String string2) throws WCMException {
        this.m_pageContext.addWarning(string, n, string2);
    }

    public void addWarning(String string) throws WCMException {
        this.m_pageContext.addWarning(string);
    }

    public PublishPathCompass getPathCompass() {
        return this.m_pageContext.getPathCompass();
    }

    public FileDistributeShip getFileDistributeShip() {
        return this.m_pageContext.getFileDistributeShip();
    }

    public IPublishFolder getUpperFolder() {
        if (this.m_upperFolder == null) {
            this.m_upperFolder = this.findNearestUpperFolder();
        }
        return this.m_upperFolder;
    }

    public void setUpperFolder(IPublishFolder iPublishFolder) {
        this.m_upperFolder = iPublishFolder;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label5", "\u5207\u6362\u53d1\u5e03\u5bf9\u8c61\u7684\u76ee\u5f55\u5230:") + iPublishFolder));
        }
    }

    private IPublishFolder findNearestUpperFolder() {
        PublishTagContext publishTagContext = this;
        do {
            IPublishFolder iPublishFolder;
            if ((iPublishFolder = publishTagContext.m_upperFolder) == null) continue;
            return iPublishFolder;
        } while ((publishTagContext = publishTagContext.getParent()) != null);
        return this.m_pageContext.getPageFolder();
    }

    public void log2Monitor(String string) {
        if (this.m_pageContext != null) {
            this.m_pageContext.log2Monitor(string);
        }
    }

    public TagItem getTagItem() {
        return this.m_oCurrTagItem;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_oCurrTagItem = tagItem;
    }

    public HashMap getAttributes() {
        this.assertCurrTagItemNotNull();
        return this.m_oCurrTagItem.getAttributes();
    }

    public String getAttribute(String string) {
        this.assertCurrTagItemNotNull();
        String string2 = this.m_oCurrTagItem.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        if (!TagItem.isVariableParameter(string2)) {
            try {
                return this.parsePageVariables(string2);
            }
            catch (Exception exception) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label6", "\u518d\u6b21\u89e3\u6790\u7f6e\u6807\u5c5e\u6027\u5931\u8d25\uff01[Value=") + string2 + "]"), (Throwable)exception);
                return null;
            }
        }
        TemplateParameter templateParameter = this.m_oCurrTagItem.getVariableParameter(string);
        if (templateParameter == null) {
            return string2;
        }
        String string3 = templateParameter.getParameterName();
        if (string3.charAt(0) == '@') {
            try {
                return this.getTagObjAttribute(this, string3.substring(1));
            }
            catch (Exception exception) {
                s_logger.error((Object)(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label7", "\u83b7\u53d6\u7f6e\u6807\u53d8\u91cf\u7684\u503c\u5931\u8d25\uff01[Name=") + string3 + "]"), (Throwable)exception);
                return null;
            }
        }
        if (this.m_mVariableArgument == null) {
            if (this.m_oCurrNestTemplateTagItem == null) {
                return templateParameter.getParameterDefaultValue();
            }
            return this.m_oCurrNestTemplateTagItem.getAttribute(string3);
        }
        String string4 = TemplateArgument.makeCacheKey(this.m_sPrefixOfArgument, string3);
        String string5 = (String)this.m_mVariableArgument.get(string4);
        if (string5 != null) {
            return string5;
        }
        if (this.m_oCurrNestTemplateTagItem != null && (string5 = this.m_oCurrNestTemplateTagItem.getAttribute(string3)) != null) {
            return string5;
        }
        return templateParameter.getParameterDefaultValue();
    }

    private final void assertCurrTagItemNotNull() {
        if (this.m_oCurrTagItem == null) {
            throw new IllegalStateException("no tag on TagContext");
        }
    }

    public String getAttributeTrim(String string) {
        String string2 = this.getAttribute(string);
        return string2 == null ? null : string2.trim();
    }

    public int getAttribute(String string, int n) throws WCMException {
        String string2 = this.getAttributeTrim(string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new WCMException(2, "Value [" + string2 + "] of attribute [" + string + "] is not integer!", exception);
        }
    }

    public boolean getAttribute(String string, boolean bl) {
        String string2 = this.getAttributeTrim(string);
        if (string2 == null || string2.length() == 0) {
            return bl;
        }
        return string2.equalsIgnoreCase("true") || string2.equals("1");
    }

    public String getPrefixOfArgument() {
        return this.m_sPrefixOfArgument;
    }

    public void setPrefixOfArgument(String string) {
        if (string != null && string.length() <= 0) {
            string = null;
        }
        if (this.m_sPrefixOfArgument != null && string != null) {
            return;
        }
        this.m_sPrefixOfArgument = string;
    }

    public int getSequenceNumber() throws WCMException {
        if (this.m_oTagParser4List == null) {
            throw new WCMException("");
        }
        return this.m_iSequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.m_iSequenceNumber = n;
    }

    public void saveNestTemplateContext() {
        if (!this.m_oCurrTagItem.getName().equalsIgnoreCase("TRS_TEMPLATE")) {
            return;
        }
        this.setPrefixOfArgument(this.m_oCurrTagItem.getAttribute("IDENTITY"));
        this.m_oPreNestTemplateTagItem = this.m_oCurrNestTemplateTagItem;
        this.m_oCurrNestTemplateTagItem = this.m_oCurrTagItem;
    }

    public void clearNestTemplateeContext() {
        this.m_oCurrNestTemplateTagItem = this.m_oPreNestTemplateTagItem;
        this.setPrefixOfArgument(null);
    }

    private String getTagObjAttribute(PublishTagContext publishTagContext, String string) throws WCMException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = publishTagContext.getUpperHost().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PAGE".equalsIgnoreCase(string2)) {
            return this.getPageObjAttribute(publishTagContext.getPageContext(), string3);
        }
        if ("SITE".equalsIgnoreCase(string2)) {
            CMSObj cMSObj = publishTagContext.getRoot().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishElement iPublishElement = publishTagContext.getUpperHost();
            IPublishFolder iPublishFolder = null;
            iPublishFolder = iPublishElement instanceof IPublishFolder ? ((IPublishFolder)iPublishElement).getParent() : iPublishElement.getFolder();
            return this.getFolderObjAttribute(iPublishFolder, string3);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label8", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PAGE,SITE,PARENT]"));
    }

    private String getPageObjAttribute(PublishPageContext publishPageContext, String string) throws WCMException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = publishPageContext.getPageElement().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("SITE".equalsIgnoreCase(string2)) {
            CMSObj cMSObj = publishPageContext.getRoot().getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishElement iPublishElement = publishPageContext.getPageElement();
            IPublishFolder iPublishFolder = null;
            iPublishFolder = iPublishElement instanceof IPublishFolder ? ((IPublishFolder)iPublishElement).getParent() : iPublishElement.getFolder();
            return this.getFolderObjAttribute(iPublishFolder, string3);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label9", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[SITE,PARENT]"));
    }

    private String getFolderObjAttribute(IPublishFolder iPublishFolder, String string) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label10", "\u9519\u8bef\u7684\u4f7f\u7528\u573a\u666f\uff0c\u5df2\u7ecf\u4e0d\u5b58\u5728\u7236\u76ee\u5f55"));
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null || string2.length() <= 0) {
            CMSObj cMSObj = iPublishFolder.getSubstance();
            return cMSObj.getPropertyAsString(string3);
        }
        if ("PARENT".equalsIgnoreCase(string2)) {
            IPublishFolder iPublishFolder2 = iPublishFolder.getParent();
            return this.getFolderObjAttribute(iPublishFolder2, string3);
        }
        throw new WCMException(I18NMessage.get(PublishTagContext.class, "PublishTagContext.label11", "\u9519\u8bef\u7684\u9886\u57df\u540d\u79f0\uff0c\u53ea\u652f\u6301[PARENT]"));
    }

    public String parsePageVariables(String string) throws WCMException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        stringBuffer = new StringBuffer();
        while (n2 < cArray.length) {
            char c;
            if ((c = cArray[n2++]) == '$' && n2 < n && cArray[n2] == '{' && cArray[n2 + 1] == '@') {
                StringBuffer stringBuffer2 = new StringBuffer(16);
                ++n2;
                ++n2;
                int n3 = 0;
                boolean bl = false;
                while (n3++ < 20 && n2 < n) {
                    if ((c = cArray[n2++]) == '}') {
                        bl = true;
                        break;
                    }
                    stringBuffer2.append(c);
                }
                if (bl) {
                    String string2 = stringBuffer2.toString().toUpperCase();
                    String string3 = this.getTagObjAttribute(this, string2);
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append("${@").append(stringBuffer2).append('}');
                    continue;
                }
                stringBuffer.append("${@").append(stringBuffer2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

