/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.FileNamedStyle;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishContentImplBase;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import org.aton.container.IClearable;

public class PublishPathCompass
implements IClearable {
    private HashMap m_hFolderInfoCache = new HashMap();
    private HashMap m_hRootDomainCache = new HashMap();
    private String m_sPublishLocalRoot = null;
    private String m_sPreviewLocalRoot = null;
    private String m_sPreviewHttpRoot = null;
    private String m_sPublishHttpRoot = null;
    private TemplateEmployMgr m_templateEmployMgr = null;
    private static final int FOLDERINFO_INDEX_FULLDATAPATH = 0;
    private static final int FOLDERINFO_INDEX_DETAILPAGEEXT = 1;
    private static final int FOLDERINFO_INDEX_HTTPDATAPATH = 2;

    public void clear() {
        this.m_hFolderInfoCache.clear();
        this.m_hRootDomainCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findFolderInfo(IPublishFolder iPublishFolder) throws WCMException {
        String string = iPublishFolder.getPathKey();
        String[] stringArray = (String[])this.m_hFolderInfoCache.get(string);
        if (stringArray == null) {
            HashMap hashMap = this.m_hFolderInfoCache;
            synchronized (hashMap) {
                String string2 = PublishPathCompass.calFullDataPath(iPublishFolder, false);
                String string3 = this.findFolderDetailPageExt(iPublishFolder);
                String string4 = iPublishFolder.getRoot().getDataPath();
                string4 = CMyString.setStrEndWith(string4, '/');
                stringArray = new String[]{string2, string3, string2.replaceFirst(string4, "")};
                this.m_hFolderInfoCache.put(string, stringArray);
            }
        }
        return stringArray;
    }

    private String findFolderDetailPageExt(IPublishFolder iPublishFolder) throws WCMException {
        Template template;
        String string = null;
        if (this.m_templateEmployMgr == null) {
            this.m_templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        }
        if ((template = this.m_templateEmployMgr.getDetailTemplate(iPublishFolder)) != null) {
            string = template.getOutputFileExt();
        }
        return string == null ? "htm" : string;
    }

    public static String calFullDataPath(IPublishElement iPublishElement, boolean bl) throws WCMException {
        if (iPublishElement.isFolder()) {
            return PublishPathCompass.calFullDataPath((IPublishFolder)iPublishElement, bl);
        }
        return PublishPathCompass.calFullDataPath((IPublishContent)iPublishElement, bl);
    }

    public static String calFullDataPath(IPublishFolder iPublishFolder, boolean bl) throws WCMException {
        String string;
        if (PublishServerConfigMapper.isPublishInRootPath()) {
            IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
            string = CMyString.setStrEndWith(iPublishFolder2.getDataPath(), '/');
            if (string == null) {
                throw new WCMException("[" + iPublishFolder2.getInfo() + I18NMessage.get(PublishPathCompass.class, "PublishPathCompass.label1", "]\u6ca1\u6709\u8bbe\u7f6e\u5b58\u653e\u8def\u5f84\uff01"));
            }
            if (!iPublishFolder.isRoot()) {
                string = string + iPublishFolder.getDataPath() + "_" + iPublishFolder.getId() + "/";
            }
        } else {
            string = CMyString.setStrEndWith(iPublishFolder.getDataPath(), '/');
            for (IPublishFolder iPublishFolder3 = iPublishFolder.getParent(); iPublishFolder3 != null; iPublishFolder3 = iPublishFolder3.getParent()) {
                string = CMyString.setStrEndWith(iPublishFolder3.getDataPath(), '/') + string;
            }
        }
        if (bl && File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static String calFullDataPath(IPublishContent iPublishContent, boolean bl) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        if (iPublishFolder == null) {
            throw new WCMException(1100, "Home folder of content not found!");
        }
        return PublishPathCompass.calFullDataPath(iPublishFolder, bl) + PublishPathCompass.calSubDirectory(iPublishContent, bl);
    }

    public static String calSubDirectory(IPublishContent iPublishContent, boolean bl) throws WCMException {
        CMyDateTime cMyDateTime;
        if (PublishServerConfigMapper.isDirDividedByDate() && (cMyDateTime = iPublishContent.getCreatedTime()) != null && !cMyDateTime.isNull()) {
            return cMyDateTime.toString(PublishServerConfigMapper.getDirDividedByDateFormat(bl)) + (bl ? File.separatorChar : (char)'/');
        }
        return "";
    }

    public static String makeDetailPageFileName(IPublishContent iPublishContent, String string, int n) {
        String string2 = "";
        FileNamedStyle fileNamedStyle = iPublishContent.getFileNamedStyle();
        string2 = fileNamedStyle != null ? PublishPathCompass.getRuledFileNamedString(iPublishContent, fileNamedStyle) : PublishPathCompass.getOldFileNamedString(iPublishContent);
        return PublishPathCompass.makePageFileName(string2, string, n);
    }

    public static String makeDetailPageFileName(IPublishContent iPublishContent) {
        String string = "";
        FileNamedStyle fileNamedStyle = iPublishContent.getFileNamedStyle();
        string = fileNamedStyle != null ? PublishPathCompass.getRuledFileNamedString(iPublishContent, fileNamedStyle) : PublishPathCompass.getOldFileNamedString(iPublishContent);
        return string;
    }

    private static String getRuledFileNamedString(IPublishContent iPublishContent, FileNamedStyle fileNamedStyle) {
        String string = fileNamedStyle.getPattern();
        if (string != null) {
            Object[] objectArray = new Object[]{new Integer(iPublishContent.getSubstance().getId()), iPublishContent.getCreatedTime().getDateTime(), new Integer(((PublishContentImplBase)iPublishContent).getDetailTemplateType())};
            return MessageFormat.format(string, objectArray);
        }
        String string2 = "";
        try {
            string2 = string2 + fileNamedStyle.getPrefix();
            String string3 = fileNamedStyle.getToken() == null ? "" : fileNamedStyle.getToken();
            switch (fileNamedStyle.getAdden()) {
                case 1: {
                    string2 = string2 + string3 + iPublishContent.getSubstance().getId();
                    break;
                }
                case 2: {
                    string2 = string2 + string3 + iPublishContent.getCreatedTime().getTimeInMillis();
                    break;
                }
                case 3: {
                    string2 = string2 + string3 + iPublishContent.getSubstance().getId() + ((PublishContentImplBase)iPublishContent).getDetailTemplateType();
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot read correctly with FileNamedStyle @[" + PublishServerConfigMapper.getPublishSrvId() + "]!", exception);
        }
        return string2;
    }

    private static String getOldFileNamedString(IPublishContent iPublishContent) {
        return "t" + String.valueOf(iPublishContent.getId());
    }

    public static String makePageFileName(String string, String string2, int n) {
        if (n <= 0) {
            return string + '.' + string2;
        }
        return string + '_' + n + '.' + string2;
    }

    public String getFullDataPath(IPublishElement iPublishElement, boolean bl) throws WCMException {
        if (iPublishElement.isFolder()) {
            return this.getFullDataPath((IPublishFolder)iPublishElement, bl);
        }
        return this.getFullDataPath((IPublishContent)iPublishElement, bl);
    }

    public String getFullDataPath(IPublishFolder iPublishFolder, boolean bl) throws WCMException {
        return this.getFullDataPath(iPublishFolder, bl, false);
    }

    private String getFullDataPath(IPublishFolder iPublishFolder, boolean bl, boolean bl2) throws WCMException {
        String[] stringArray = this.findFolderInfo(iPublishFolder);
        String string = stringArray[bl2 ? 2 : 0];
        if (bl && File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public String getFullDataPath(IPublishContent iPublishContent, boolean bl) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getFullDataPath(iPublishFolder, bl) + PublishPathCompass.calSubDirectory(iPublishContent, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootDomain(IPublishFolder iPublishFolder) throws WCMException {
        IPublishFolder iPublishFolder2 = iPublishFolder.getRoot();
        String string = iPublishFolder.getPathKey();
        String string2 = (String)this.m_hRootDomainCache.get(string);
        if (string2 == null) {
            HashMap hashMap = this.m_hRootDomainCache;
            synchronized (hashMap) {
                string2 = CMyString.setStrEndWith(iPublishFolder2.getRootDomain(), '/');
                this.m_hRootDomainCache.put(string, string2);
            }
        }
        return string2;
    }

    public String getAbsoluteHttpPath(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement.isFolder()) {
            return this.getAbsoluteHttpPath((IPublishFolder)iPublishElement);
        }
        return this.getAbsoluteHttpPath((IPublishContent)iPublishElement);
    }

    public String getAbsoluteHttpPath(IPublishFolder iPublishFolder) throws WCMException {
        return this.getRootDomain(iPublishFolder) + this.getFullDataPath(iPublishFolder, false, true);
    }

    public String getAbsoluteHttpPath(IPublishContent iPublishContent) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getAbsoluteHttpPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, false);
    }

    public String getHttpUrl(IPublishContent iPublishContent, int n) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        Template template = null;
        try {
            template = iPublishContent.getDetailTemplate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "html";
        if (template != null) {
            string = template.getOutputFileExt();
        } else {
            String[] stringArray = this.findFolderInfo(iPublishFolder);
            string = stringArray[1];
        }
        return this.getAbsoluteHttpPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, false) + PublishPathCompass.makeDetailPageFileName(iPublishContent, string, n);
    }

    public String getPreviewHttpUrl(IPublishContent iPublishContent, int n) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        String[] stringArray = this.findFolderInfo(iPublishFolder);
        String string = stringArray[1];
        return this.getPreviewHttpPath(iPublishContent) + PublishPathCompass.makeDetailPageFileName(iPublishContent, string, n);
    }

    public String getPublishHttpUrl(IPublishContent iPublishContent, int n) throws WCMException {
        return this.getPublishHttpPath(iPublishContent) + PublishPathCompass.makeDetailPageFileName(iPublishContent, iPublishContent.getDetailTemplate().getOutputFileExt(), n);
    }

    public String getLocalPath(IPublishElement iPublishElement, boolean bl) throws WCMException {
        return bl ? this.getPreviewLocalPath(iPublishElement) : this.getPublishLocalPath(iPublishElement);
    }

    public String getPublishLocalPath(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement.isFolder()) {
            return this.getPublishLocalPath((IPublishFolder)iPublishElement);
        }
        return this.getPublishLocalPath((IPublishContent)iPublishElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishLocalPath(IPublishFolder iPublishFolder) throws WCMException {
        if (this.m_sPublishLocalRoot == null) {
            PublishPathCompass publishPathCompass = this;
            synchronized (publishPathCompass) {
                String string = FilesMan.getFilesMan().getPathConfigValue("LP", 0);
                if (string == null) {
                    throw new WCMException(14, "Path config for LP required!");
                }
                this.m_sPublishLocalRoot = CMyString.setStrEndWith(string, File.separatorChar);
            }
        }
        return this.m_sPublishLocalRoot + this.getFullDataPath(iPublishFolder, true);
    }

    public String getPublishLocalPath(IPublishContent iPublishContent) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getPublishLocalPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, true);
    }

    public String getPreviewLocalPath(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement.isFolder()) {
            return this.getPreviewLocalPath((IPublishFolder)iPublishElement);
        }
        return this.getPreviewLocalPath((IPublishContent)iPublishElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviewLocalPath(IPublishFolder iPublishFolder) throws WCMException {
        if (this.m_sPreviewLocalRoot == null) {
            PublishPathCompass publishPathCompass = this;
            synchronized (publishPathCompass) {
                String string = FilesMan.getFilesMan().getPathConfigValue("LV", 0);
                if (string == null || (string = string.trim()).length() == 0) {
                    throw new WCMException(14, "Path config for LV required!");
                }
                this.m_sPreviewLocalRoot = CMyString.setStrEndWith(string, File.separatorChar);
            }
        }
        return this.m_sPreviewLocalRoot + this.getFullDataPath(iPublishFolder, true);
    }

    public String getPreviewLocalPath(IPublishContent iPublishContent) throws WCMException {
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getPreviewLocalPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviewHttpPath(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement.isFolder()) {
            IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
            if (this.m_sPreviewHttpRoot == null) {
                PublishPathCompass publishPathCompass = this;
                synchronized (publishPathCompass) {
                    String string = FilesMan.getFilesMan().getPathConfigValue("LV", 1);
                    if (string == null || (string = string.trim()).length() == 0) {
                        throw new WCMException(14, "Path config for LV required!");
                    }
                    string = string.replace('\\', '/');
                    this.m_sPreviewHttpRoot = CMyString.setStrEndWith(string, '/');
                }
            }
            return this.m_sPreviewHttpRoot + this.getFullDataPath(iPublishFolder, false);
        }
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getPreviewHttpPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishHttpPath(IPublishElement iPublishElement) throws WCMException {
        if (iPublishElement.isFolder()) {
            IPublishFolder iPublishFolder = (IPublishFolder)iPublishElement;
            if (this.m_sPublishHttpRoot == null) {
                PublishPathCompass publishPathCompass = this;
                synchronized (publishPathCompass) {
                    String string = FilesMan.getFilesMan().getPathConfigValue("LP", 1);
                    if (string == null || (string = string.trim()).length() == 0) {
                        throw new WCMException(14, "Path config for LV required!");
                    }
                    string = string.replace('\\', '/');
                    this.m_sPublishHttpRoot = CMyString.setStrEndWith(string, '/');
                }
            }
            return this.m_sPublishHttpRoot + this.getFullDataPath(iPublishFolder, false);
        }
        IPublishContent iPublishContent = (IPublishContent)iPublishElement;
        IPublishFolder iPublishFolder = iPublishContent.getRealHome();
        return this.getPublishHttpPath(iPublishFolder) + PublishPathCompass.calSubDirectory(iPublishContent, false);
    }

    public String getRootImageHttpPath(IPublishElement iPublishElement) throws WCMException {
        String string = this.getFullDataPath(iPublishElement, false);
        return HtmlUtil.calParentRelativePath(string) + "images/";
    }

    public String getRootHttpPathFrom(IPublishElement iPublishElement) throws WCMException {
        try {
            IPublishFolder iPublishFolder = iPublishElement.getFolder().getRoot();
            String string = this.getFullDataPath(iPublishFolder, false);
            String string2 = this.getFullDataPath(iPublishElement, false);
            return HtmlUtil.calRelativePath(string, string2);
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to calculate the root http path from " + iPublishElement.getInfo(), exception);
        }
    }
}

