/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class PublishPageContext
implements IClearable {
    private Logger s_logger = Logger.getLogger(PublishPageContext.class);
    private Map m_extraAttributes;
    private Map m_variableAttributes;
    private PublishTaskContext m_taskContext;
    private IPublishElement m_pageElement;
    private IPublishFolder m_root = null;
    private Template m_oTemplate = null;
    private IPublishProgressMonitor m_oProgressMonitor = null;
    private StringBuffer m_buffWarnings = null;
    private String m_sPageHttpPath = null;
    private String m_sPageHttpURL = null;
    private String m_sFileName = null;

    public PublishPageContext(PublishPageContext publishPageContext) {
        this.m_pageElement = publishPageContext.getPageElement();
        this.m_taskContext = publishPageContext.getTaskContext();
        this.m_oProgressMonitor = publishPageContext.getProgressMonitor();
    }

    public PublishPageContext(IPublishElement iPublishElement, PublishTaskContext publishTaskContext) {
        this(iPublishElement, publishTaskContext, null);
    }

    public PublishPageContext(IPublishElement iPublishElement, PublishTaskContext publishTaskContext, IPublishProgressMonitor iPublishProgressMonitor) {
        this.m_pageElement = iPublishElement;
        this.m_taskContext = publishTaskContext;
        this.m_oProgressMonitor = iPublishProgressMonitor;
    }

    public PublishTaskContext getTaskContext() {
        return this.m_taskContext;
    }

    public IPublishElement getPageElement() {
        return this.m_pageElement;
    }

    public IPublishFolder getPageFolder() {
        if (this.m_pageElement instanceof IPublishFolder) {
            return (IPublishFolder)this.m_pageElement;
        }
        return ((IPublishContent)this.m_pageElement).getFolder();
    }

    public void clear() {
        if (this.m_buffWarnings != null) {
            this.m_buffWarnings.setLength(0);
        }
        if (this.m_sPageHttpPath != null) {
            this.m_sPageHttpPath = null;
        }
    }

    public boolean isPreview() {
        return this.m_taskContext.isPreview();
    }

    public IPublishFolder getRoot() throws WCMException {
        if (this.m_root != null) {
            return this.m_root;
        }
        if (this.m_pageElement.isFolder()) {
            this.m_root = this.m_pageElement.getFolder().getRoot();
            return this.m_root;
        }
        this.m_root = this.m_taskContext.getRoot();
        Template template = this.m_oTemplate;
        if (template == null) {
            template = ((IPublishContent)this.m_pageElement).getDetailTemplate();
        }
        if (template.getRootId() != this.m_root.getId()) {
            this.m_root = template.getRoot();
        }
        return this.m_root;
    }

    public void setRoot(IPublishFolder iPublishFolder) {
        this.m_root = iPublishFolder;
    }

    public PublishPathCompass getPathCompass() {
        return this.m_taskContext.getPathCompass();
    }

    public FileDistributeShip getFileDistributeShip() {
        return this.m_taskContext.getFileDistributeShip();
    }

    public void incDetailPageCount() {
        this.m_taskContext.incDetailPageCount();
    }

    public void incOutlinePageCount() {
        this.m_taskContext.incOutlinePageCount();
    }

    public void addWarning(String string, int n, String string2) throws WCMException {
        if (!PublishServerConfigMapper.isSendWarningIfFileNotFound()) {
            return;
        }
        if (this.m_buffWarnings == null) {
            this.m_buffWarnings = new StringBuffer();
        }
        this.m_buffWarnings.append(string).append("(ID=").append(n).append("): ");
        this.m_buffWarnings.append(string2).append("\n");
    }

    public void addWarning(String string) throws WCMException {
        if (!PublishServerConfigMapper.isSendWarningIfFileNotFound()) {
            return;
        }
        if (this.m_buffWarnings == null) {
            this.m_buffWarnings = new StringBuffer();
        }
        this.m_buffWarnings.append(string).append("\n");
    }

    public String getWarnings() {
        return this.m_buffWarnings == null ? null : this.m_buffWarnings.toString();
    }

    public boolean hasWarnings() {
        return this.m_buffWarnings != null;
    }

    public String getPageHttpPath() throws WCMException {
        if (this.m_sPageHttpPath == null && this.m_sPageHttpPath == null) {
            PublishPathCompass publishPathCompass = this.getPathCompass();
            this.m_sPageHttpPath = this.m_pageElement instanceof IPublishFolder ? publishPathCompass.getAbsoluteHttpPath((IPublishFolder)this.m_pageElement) : publishPathCompass.getAbsoluteHttpPath((IPublishContent)this.m_pageElement);
        }
        return this.m_sPageHttpPath;
    }

    public String getPageHttpURL() throws WCMException {
        if (this.m_sPageHttpURL == null && this.m_sPageHttpURL == null) {
            String string = this.getPageHttpPath();
            if (this.m_pageElement instanceof IPublishContent) {
                if (((IPublishContent)this.m_pageElement).isLink()) {
                    this.m_sPageHttpURL = ((IPublishContent)this.m_pageElement).getLinkUrl();
                } else {
                    if (CMyString.isEmpty(this.m_sFileName)) {
                        IPublishContent iPublishContent = (IPublishContent)this.m_pageElement;
                        String string2 = PublishPathCompass.makeDetailPageFileName(iPublishContent);
                        Template template = iPublishContent.getDetailTemplate();
                        if (template == null) {
                            throw new WCMException(231, iPublishContent.getInfo() + I18NMessage.get(PublishPageContext.class, "PublishPageContext.label1", "\u6ca1\u6709\u7ec6\u89c8\u6a21\u677f\uff01"));
                        }
                        String string3 = template.getOutputFileExt();
                        this.m_sFileName = string2 + "." + string3;
                    }
                    this.m_sPageHttpURL = string + this.m_sFileName;
                }
            } else {
                this.m_sPageHttpURL = string;
            }
        }
        return this.m_sPageHttpURL;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public void setFileName(String string) {
        this.m_sFileName = string;
    }

    public void log2Monitor(String string) {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.info(string);
        }
    }

    public IPublishProgressMonitor getProgressMonitor() {
        return this.m_oProgressMonitor;
    }

    public void addErrorLog(int n, String string, String string2) {
        try {
            if (this.m_taskContext != null) {
                this.m_taskContext.addErrorLog(n, this.m_pageElement, string, string2);
            } else {
                this.s_logger.error((Object)(string2 + "\n" + string));
            }
        }
        catch (Throwable throwable) {
            this.s_logger.error((Object)"Failed to add error log for page publish task!", throwable);
        }
    }

    public void addErrorLog(int n, String string, Throwable throwable) {
        this.addErrorLog(n, string, CMyException.getStackTraceText(throwable));
    }

    public String getExtraAttribute(String string) {
        if (this.m_extraAttributes == null) {
            return null;
        }
        return (String)this.m_extraAttributes.get(string.toUpperCase());
    }

    public void setExtraAttribute(String string, String string2) {
        if (this.m_extraAttributes == null) {
            this.m_extraAttributes = new HashMap(1);
        }
        this.m_extraAttributes.put(string.toUpperCase(), string2);
    }

    public Template getTemplate() {
        return this.m_oTemplate;
    }

    public void setTemplate(Template template) {
        this.m_oTemplate = template;
    }

    public String getVariableAttribute(String string) {
        if (string == null) {
            return null;
        }
        if (this.m_variableAttributes == null) {
            return null;
        }
        return (String)this.m_variableAttributes.get(string);
    }

    public void setVariableAttribute(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (this.m_variableAttributes == null) {
            this.m_variableAttributes = new HashMap();
        }
        this.m_variableAttributes.put(string.toUpperCase(), string2);
    }
}

