/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class PublishDistributionLCListener
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static final Logger logger = Logger.getLogger(PublishDistributionLCListener.class);

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        PublishDistribution publishDistribution;
        if (955 == baseObj.getWCMType() && (publishDistribution = (PublishDistribution)baseObj).isEnabled()) {
            this.redistributeAppendixes(publishDistribution.getFolder());
        }
    }

    private void redistributeAppendixes(final IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null || !iPublishFolder.isRoot()) {
            return;
        }
        new Thread(){

            public void run() {
                ContextHelper.initContext(User.getSystem());
                TemplateMgr templateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
                try {
                    templateMgr.redistributeAppendixes(iPublishFolder, true);
                }
                catch (WCMException wCMException) {
                    logger.warn((Object)"redistribute faile", (Throwable)wCMException);
                }
            }
        }.start();
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        PublishDistribution publishDistribution;
        if (955 == baseObj.getWCMType() && ((publishDistribution = (PublishDistribution)baseObj).isEnabled() && (publishDistribution.isChangeProperty("TARGETSERVER") || publishDistribution.isChangeProperty("DATAPATH")) || publishDistribution.getNewPropertyAsInt("ENABLED", 0) == 1)) {
            this.redistributeAppendixes(publishDistribution.getFolder());
        }
    }
}

