/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileDistributorImpFileLocal
implements IFileDistristributor {
    private static final Logger s_logger = Logger.getLogger(FileDistributorImpFileLocal.class);
    private static final Object s_locker = new Object();
    private int m_iDistributionID;
    private String m_sRootDirectory;

    public int getConfigID() {
        return this.m_iDistributionID;
    }

    public void setTargetRoot(PublishDistribution publishDistribution) throws Exception {
        this.m_iDistributionID = publishDistribution.getId();
        this.m_sRootDirectory = CMyString.setStrEndWith(publishDistribution.getDataPath(), File.separatorChar);
        if (CMyString.isEmpty(this.m_sRootDirectory)) {
            throw new Exception("Root directory of local distribution target [ID=" + publishDistribution.getId() + "] not set!");
        }
    }

    public void distributeFile(String string, String string2, boolean bl) throws Exception {
        String string3 = this.reviseDestPath(string2);
        this.insureDestPath(string3);
        string3 = string3 + CMyFile.extractFileName(string);
        if (bl && CMyFile.fileExists(string3)) {
            return;
        }
        boolean bl2 = this.distributeFile0(string, string3);
        int n = 100;
        int n2 = 1;
        while (!bl2) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            s_logger.warn((Object)("Try again copy [" + string + "] to [" + string3 + "], already try [" + n2 + "] times!"));
            bl2 = this.distributeFile0(string, string3);
            if (++n2 <= n) continue;
            break;
        }
    }

    private boolean distributeFile0(String string, String string2) throws Exception {
        File file = new File(string);
        long l = file.length();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file2 = new File(string2);
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray, 0, 4096)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CMyException(55, "\u8981\u590d\u5236\u7684\u539f\u6587\u4ef6\u6ca1\u6709\u53d1\u73b0", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CMyException(50, "\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return new File(string2).length() >= l;
    }

    public boolean renameFile(String string, String string2, String string3) throws Exception {
        String string4 = this.reviseDestPath(string3);
        String string5 = string4 + string;
        String string6 = string4 + string2;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("to rename [" + string5 + "] to [" + string6 + "]"));
        }
        return CMyFile.moveFile(string5, string6);
    }

    public boolean withdrawFile(String string, String string2) throws Exception {
        String string3 = this.reviseDestPath(string2) + string;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("to delete file [" + string3 + "]"));
        }
        return CMyFile.deleteFile(string3);
    }

    public boolean withdrawPath(String string) throws Exception {
        String string2 = this.reviseDestPath(string);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("to delete path [" + string2 + "]"));
        }
        return this.renamePath(string2);
    }

    private boolean renamePath(String string) {
        File file = new File(string);
        if (!file.exists() && !file.isDirectory()) {
            return true;
        }
        return file.renameTo(new File(file.getParentFile(), PublishConstants.makeDeletedPathName(file.getName())));
    }

    private String reviseDestPath(String string) {
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return this.m_sRootDirectory + CMyString.setStrEndWith(string, File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insureDestPath(String string) throws WCMException {
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        try {
            Object object = s_locker;
            synchronized (object) {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(50, "Failed to create directroy [" + string + "] on disk!", exception);
        }
        file = new File(string);
        if (!file.exists()) {
            throw new WCMException(50, "Failed to create directroy [" + string + "] on disk![Double Check]");
        }
    }
}

