/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import java.io.File;
import java.io.RandomAccessFile;

public class FileDistributeQueue {
    public static final int UPLOAD_FILE = 1;
    public static final int DELETE_FILE = 2;
    public static final int DELETE_PATH = 3;
    private static final int BUFFER_SIZE = 256;
    private String m_sFileName;
    private File m_oListFile;
    private RandomAccessFile m_oFileList;
    private int m_iFileOffset;
    private int m_iReadCount;
    private int m_iReadOffset;
    private int m_iReadLength;
    private Item[] m_oReadBuffer;
    private int m_iSaveCount;
    private int m_iSaveOffset;
    private Item[] m_oSaveBuffer;

    public FileDistributeQueue(int n) {
        this.init(n + ".fdq", false);
    }

    public FileDistributeQueue(String string) {
        this.init(string, true);
    }

    private void init(String string, boolean bl) {
        this.m_sFileName = string;
        if (bl) {
            this.m_oListFile = null;
        }
        this.m_oReadBuffer = new Item[256];
        this.m_iReadOffset = 0;
        this.m_iReadLength = 0;
        this.m_oSaveBuffer = new Item[256];
        this.m_iSaveOffset = 0;
    }

    public synchronized Item getItem() {
        if (this.m_iReadLength > 0 && this.m_iReadOffset < this.m_iReadLength) {
            ++this.m_iReadCount;
            return this.m_oReadBuffer[this.m_iReadOffset++];
        }
        if (this.m_oListFile != null) {
            this.loadBuffer();
            if (this.m_iReadOffset < this.m_iReadLength) {
                ++this.m_iReadCount;
                return this.m_oReadBuffer[this.m_iReadOffset++];
            }
        }
        if (this.m_iSaveOffset > 0 && this.m_iReadCount < 256) {
            return this.m_oSaveBuffer[this.m_iReadCount++];
        }
        return null;
    }

    protected synchronized void putItem(int n, String string, String string2, boolean bl) {
        if (this.m_iSaveOffset < 256) {
            Item item = this.m_oSaveBuffer[this.m_iSaveOffset];
            if (item == null) {
                item = this.m_oSaveBuffer[this.m_iSaveOffset] = new Item();
            }
            ++this.m_iSaveCount;
            ++this.m_iSaveOffset;
            item.setType(n);
            item.setLocalFile(string);
            item.setRemotePath(string2);
            item.setNoOverWrite(bl);
        } else {
            this.saveBuffer();
            this.putItem(n, string, string2, bl);
        }
    }

    private void loadBuffer() {
    }

    private void saveBuffer() {
    }

    private void saveStatus() {
    }

    public class Item {
        private int m_iOff;
        private int m_iType;
        private String m_sLocal;
        private String m_sRemote;
        private String m_sFolderKey;
        private boolean m_zNotOver;

        public final int getType() {
            return this.m_iType;
        }

        public final void setType(int n) {
            this.m_iType = n;
        }

        int getOffset() {
            return this.m_iOff;
        }

        void setOffset(int n) {
            this.m_iOff = n;
        }

        public final String getLocalFile() {
            return this.m_sLocal;
        }

        public final void setLocalFile(String string) {
            this.m_sLocal = string;
        }

        public final String getRemotePath() {
            return this.m_sRemote;
        }

        public final void setRemotePath(String string) {
            this.m_sRemote = string;
        }

        public boolean getNoOverWrite() {
            return this.m_zNotOver;
        }

        public void setNoOverWrite(boolean bl) {
            this.m_zNotOver = bl;
        }
    }
}

