/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message.notify;

import com.trs.DreamFactory;
import com.trs.components.common.message.notify.NotificationSchemeConfig;
import com.trs.infra.BaseServer;
import com.trs.infra.config.XMLConfigServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class NotificationServer
extends BaseServer
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)NotificationServer.class.getName());
    private Map m_hSchemes = new HashMap();
    private boolean m_bLoaded = false;

    public synchronized void clear() {
        this.m_hSchemes.clear();
    }

    public static NotificationServer getInstance() {
        NotificationServer notificationServer = (NotificationServer)DreamFactory.createObjectById("NotificationServer");
        if (!notificationServer.isStarted()) {
            notificationServer.startup();
        }
        return notificationServer;
    }

    public NotificationSchemeConfig lookupSchemeForEvent(String string) {
        NotificationServer notificationServer = NotificationServer.getInstance();
        return (NotificationSchemeConfig)notificationServer.m_hSchemes.get(string);
    }

    public boolean needNotifyForEvent(String string) {
        NotificationSchemeConfig notificationSchemeConfig = NotificationServer.getInstance().lookupSchemeForEvent(string);
        return notificationSchemeConfig != null && notificationSchemeConfig.isEnabled();
    }

    public synchronized void refresh() {
        if (this.m_bLoaded) {
            this.clear();
            this.m_bLoaded = false;
        }
        List list = XMLConfigServer.getInstance().getConfigObjects(NotificationSchemeConfig.class);
        for (int i = 0; i < list.size(); ++i) {
            NotificationSchemeConfig notificationSchemeConfig = (NotificationSchemeConfig)list.get(i);
            this.m_hSchemes.put(notificationSchemeConfig.getEvent(), notificationSchemeConfig);
        }
        this.m_bLoaded = true;
        logger.info((Object)"Finished to refresh the notification server.");
    }

    protected void doShutdown() {
        this.clear();
    }

    protected boolean doStart() {
        this.refresh();
        return this.m_bLoaded;
    }
}

