/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.Messages;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class MsgQueue
extends CMSObj {
    public static final int OBJ_TYPE = 310;
    public static final String DB_TABLE_NAME = "WCMMSGQUEUE";
    public static final String DB_ID_NAME = "QUEUEID";
    public static final int TYPE_NORMAL_MSG = 1;
    public static final int TYPE_FLOW_MSG = 2;
    public static final int TYPE_WARNING = 3;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 310;
    }

    public int getMessageId() {
        return this.getPropertyAsInt("MSGID", 0);
    }

    public Message getMessage(User user) throws WCMException {
        int n = this.getMessageId();
        if (n == 0) {
            return null;
        }
        try {
            WCMFilter wCMFilter = new WCMFilter("", "MsgId=" + n, "");
            Messages messages = new Messages(user, 1, 1);
            messages.open(wCMFilter);
            return messages.isEmpty() ? null : (Message)messages.getAt(0);
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(MsgQueue.class, "MsgQueue.label1", "\u53d6\u6d88\u606f\u961f\u5217\u4e2d\u6700\u65b0\u6d88\u606f\u96c6\u5408\u65f6\u51fa\u9519(MsgQueue.getNewMsg)"), wCMException);
        }
    }

    public boolean setMessage(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(MsgQueue.class, "MsgQueue.label2", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61ID(MsgQueue.messageId)"));
        }
        return this.setProperty("MSGID", n);
    }

    public boolean setMessage(Message message) throws WCMException {
        if (message == null || !message.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label3", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61(MsgQueue.setMessage)"));
        }
        return this.setMessage(message.getId());
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        if (n != 204 && n != 201 && n != 203) {
            throw new WCMException(1100, I18NMessage.get(MsgQueue.class, "MsgQueue.label4", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MsgQueue.setObjType\uff09"));
        }
        return this.setProperty("OBJTYPE", n);
    }

    public boolean setObj(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label5", "\u65e0\u6548\u5bf9\u8c61\uff08MsgQueue.setObj\uff09"));
        }
        if (!this.setObjType(cMSObj.getWCMType())) {
            return false;
        }
        return this.setObjId(cMSObj.getId());
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(MsgQueue.class, "MsgQueue.label6", "ObjId\u503c\u65e0\u6548(MsgQueue.setObjId)"));
        }
        return this.setProperty("OBJID", n);
    }

    public boolean isReaded() {
        return this.getPropertyAsBoolean("READED", false);
    }

    public boolean setReaded(boolean bl) throws WCMException {
        return this.setProperty("READED", bl);
    }

    public int getMsgType() {
        return this.getPropertyAsInt("MSGTYPE", 1);
    }

    public boolean setMsgType(int n) throws WCMException {
        if (n != 1 && n != 2 && n != 3) {
            throw new WCMException(10, I18NMessage.get(MsgQueue.class, "MsgQueue.label7", "MsgType\u503c\u65e0\u6548(Message.setMsgType)"));
        }
        return this.setProperty("MSGTYPE", n);
    }

    public boolean isValid() throws WCMException {
        Number number = null;
        Number number2 = null;
        Number number3 = null;
        if (this.isAddMode()) {
            number = (Number)this.getAllProperty().get("MSGID");
            number2 = (Number)this.getAllProperty().get("OBJTYPE");
            number3 = (Number)this.getAllProperty().get("OBJID");
            if (number == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label8", "\u5c5e\u6027MessageId\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
            if (number2 == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
            if (number3 == null) {
                throw new WCMException(1106, I18NMessage.get(MsgQueue.class, "MsgQueue.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(MsgQueue.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MsgQueue.class, "MsgQueue.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MsgQueue.isValid)"));
            }
            number = (Number)this.getNewProperty("MSGID");
            number2 = (Number)this.getNewProperty("OBJTYPE");
            number3 = (Number)this.getNewProperty("OBJID");
            if (number == null) {
                number = (Number)this.getAllProperty().get("MSGID");
            }
            if (number2 == null) {
                number2 = (Number)this.getAllProperty().get("OBJTYPE");
            }
            if (number3 == null) {
                number3 = (Number)this.getAllProperty().get("OBJID");
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public static final MsgQueue findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (MsgQueue)BaseObj.findById(MsgQueue.class, n);
    }

    public static final MsgQueue createNewInstance() throws WCMException {
        return (MsgQueue)BaseObj.createNewInstance(MsgQueue.class);
    }

    public static final MsgQueue findByKey(Object object) throws WCMException {
        return (MsgQueue)BaseObj.findByKey(MsgQueue.class, object);
    }
}

