/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageSendingMapper;
import com.trs.components.common.message.Messages;
import com.trs.components.common.message.MsgQueue;
import com.trs.components.common.message.MsgQueues;
import com.trs.components.common.message.MsgReceiver;
import com.trs.components.common.message.MsgReceivers;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class MessageServer {
    private static Logger logger = Logger.getLogger(MessageServer.class);

    public static void send(Message message) throws WCMException {
        if (message == null) {
            throw new WCMException(10, I18NMessage.get(MessageServer.class, "MessageServer.label1", "\u8981\u53d1\u9001\u7684\u6d88\u606f\u65e0\u6548[null]"));
        }
        Users users = message.getReceivers();
        if (message.isAddMode()) {
            message.insert(ContextHelper.getLoginUser());
        }
        MessageServer.sendTo(message, users);
    }

    private static void sendTo(Message message, Users users) throws WCMException {
        String string = message.getSendType();
        User user = null;
        String[] stringArray = CMyString.split(string, ",");
        ISendWorker iSendWorker = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = MessageSendingMapper.getInstance().getWorker(stringArray[i]);
            if (string2 == null) {
                throw new WCMException(1354, "Unknown message send type: " + stringArray[i]);
            }
            iSendWorker = (ISendWorker)DreamFactory.createObjectById(string2);
            for (int j = 0; j < users.size(); ++j) {
                user = (User)users.getAt(j);
                if (user == null) continue;
                iSendWorker.send(message, user);
            }
        }
    }

    public static Messages getUnreadMessages(User user, WCMFilter wCMFilter) throws WCMException {
        String string = "EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=" + user.getId() + " AND ObjType=" + 204 + " AND WCMMessage.MsgId=WCMMsgQueue.MsgId AND Readed=" + 0 + ")";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "CrTime desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Messages.openWCMObjs(user, wCMFilter2);
    }

    public static boolean hasUnreadMessage(User user) throws WCMException {
        return MessageServer.hasUnreadMessage(user, null);
    }

    public static boolean hasUnreadMessage(User user, int[] nArray) throws WCMException {
        int n = nArray == null ? 0 : nArray.length;
        StringBuffer stringBuffer = new StringBuffer("SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 and Readed=0".length() + n * 16);
        stringBuffer.append("SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 and Readed=0");
        if (n > 0) {
            stringBuffer.append(" and (");
            stringBuffer.append("MsgType=?");
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(" or ");
                stringBuffer.append("MsgType=?");
            }
            stringBuffer.append(")");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            int n2;
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setMaxRows(1);
            preparedStatement.setInt(1, user.getId());
            for (n2 = 0; n2 < n; ++n2) {
                preparedStatement.setInt(2 + n2, nArray[n2]);
            }
            resultSet = preparedStatement.executeQuery();
            n2 = resultSet.next() ? 1 : 0;
            return n2 != 0;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to get unread messages!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close result", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public static Messages getSentMsgs(User user, WCMFilter wCMFilter) throws WCMException {
        String string = "CrUser=? AND DeletedBySender=0";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "CrTime desc");
        wCMFilter2.addSearchValues(0, user.getName());
        wCMFilter2.mergeWith(wCMFilter);
        return Messages.openWCMObjs(user, wCMFilter2);
    }

    public static Messages getReceivedMsgs(User user, WCMFilter wCMFilter) throws WCMException {
        String string = "EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=" + user.getId() + " AND ObjType=" + 204 + " AND WCMMessage.MsgId=WCMMsgQueue.MsgId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "CrTime desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Messages.openWCMObjs(user, wCMFilter2);
    }

    public static void delete(User user, String string) throws WCMException {
        Messages messages = Messages.findByIds(user, string);
        MessageServer.delete(user, messages);
    }

    private static void deleteBySender(User user, Message message) throws WCMException {
        if (MessageServer.isCanDrop(user, message)) {
            message.delete(user);
        } else {
            message.canEdit(user);
            message.setDeletedBySender();
            message.update(user);
        }
    }

    private static void deleteByReceiver(User user, Message message) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(message.getId(), user);
        if (msgQueue != null) {
            msgQueue.delete(user);
        }
        if (message.isDeletedBySender() && MessageServer.isCanDrop(user, message)) {
            message.delete(user);
        }
    }

    private static boolean isCanDrop(User user, Message message) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMMSGQUEUE", "MsgId=" + message.getId(), "");
        MsgQueues msgQueues = MsgQueues.openWCMObjs(user, wCMFilter);
        return msgQueues.isEmpty();
    }

    public static void emptyInbox(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMMSGQUEUE", "ObjId=" + user.getId() + " AND ObjType=" + 204, "");
        MsgQueues msgQueues = MsgQueues.openWCMObjs(user, wCMFilter);
        msgQueues.removeAll();
    }

    public static void emptyOutbox(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "DeletedBySender=0", "");
        Messages messages = MessageServer.getSentMsgs(user, wCMFilter);
        MessageServer.delete(user, messages);
    }

    private static void delete(User user, Messages messages) throws WCMException {
        Message message = null;
        for (int i = 0; i < messages.size(); ++i) {
            message = (Message)messages.getAt(i);
            if (message == null) continue;
            if (message.getCrUserName().equals(user.getName())) {
                MessageServer.deleteBySender(user, message);
            }
            MessageServer.deleteByReceiver(user, message);
        }
    }

    public static boolean isMessageReaded(Message message, User user) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(message.getId(), user);
        if (msgQueue == null) {
            return false;
        }
        return msgQueue.isReaded();
    }

    public static void setMessageReaded(Message message, User user, boolean bl) throws WCMException {
        MsgQueue msgQueue = MessageServer.getMsgQueue(message.getId(), user);
        if (msgQueue == null) {
            return;
        }
        if (bl && msgQueue.isReaded() || !bl && !msgQueue.isReaded()) {
            return;
        }
        try {
            msgQueue.validCanEditAndLock(user);
            msgQueue.setReaded(bl);
            msgQueue.update(user);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static MsgQueue getMsgQueue(int n, User user) throws WCMException {
        String string = "MsgId=" + n + " AND ObjId=" + user.getId() + " AND ObjType=" + 204;
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.setMaxRowNumber(1);
        MsgQueues msgQueues = MsgQueues.openWCMObjs(user, wCMFilter);
        if (msgQueues.isEmpty()) {
            return null;
        }
        return (MsgQueue)msgQueues.getAt(0);
    }

    public static Messages getMessages(int n, User user, WCMFilter wCMFilter) throws WCMException {
        switch (n) {
            case 0: {
                return MessageServer.getUnreadMessages(user, wCMFilter);
            }
            case 2: {
                return MessageServer.getReceivedMsgs(user, wCMFilter);
            }
            case 1: {
                return MessageServer.getSentMsgs(user, wCMFilter);
            }
        }
        return null;
    }

    public static String getReceiverNames(Message message, int n) throws WCMException {
        if (message == null) {
            throw new WCMException(10, I18NMessage.get(MessageServer.class, "MessageServer.label2", "\u65e0\u6548\u7684\u6d88\u606f\u5bf9\u8c61!"));
        }
        WCMFilter wCMFilter = new WCMFilter("WCMMSGRECEIVER", "MsgId=" + message.getId() + " AND RECEIVERTYPE=" + n, "", "ReceiverName");
        MsgReceivers msgReceivers = MsgReceivers.openWCMObjs(wCMFilter);
        String string = ",";
        MsgReceiver msgReceiver = null;
        for (int i = 0; i < msgReceivers.size(); ++i) {
            msgReceiver = (MsgReceiver)msgReceivers.getAt(i);
            if (msgReceiver == null) continue;
            string = string + msgReceiver.getReceiverName() + ",";
        }
        return string.substring(1);
    }

    public static Message findById(User user, int n) throws WCMException {
        String string = "MSGID=? and (CrUser=?  or EXISTS(SELECT MsgId FROM WCMMsgQueue WHERE ObjId=? AND ObjType=204 AND WCMMessage.MsgId=WCMMsgQueue.MsgId))";
        WCMFilter wCMFilter = new WCMFilter("", string, "CrTime desc");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.addSearchValues(1, user.getName());
        wCMFilter.addSearchValues(2, user.getId());
        wCMFilter.setMaxRowNumber(1);
        Messages messages = new Messages(user, 1, 1);
        messages.setMaxSize(1);
        messages.open(wCMFilter);
        if (messages.isEmpty()) {
            return null;
        }
        return (Message)messages.getAt(0);
    }

    public static Messages findByIds(User user, String string) throws WCMException {
        MessageServer.assertValidIdSequence(string);
        String string2 = "MSGID in(" + string + ") " + "and (CrUser=? " + " or " + "EXISTS(SELECT MsgId FROM WCMMsgQueue " + "WHERE ObjId=? AND ObjType=204 AND WCMMessage.MsgId=WCMMsgQueue.MsgId)" + ")";
        WCMFilter wCMFilter = new WCMFilter("", string2, "CrTime desc");
        wCMFilter.addSearchValues(0, user.getName());
        wCMFilter.addSearchValues(1, user.getId());
        Messages messages = new Messages(user);
        messages.open(wCMFilter);
        return messages;
    }

    private static void assertValidIdSequence(String string) throws WCMException {
        if (CMyString.isEmpty(string)) {
            throw new WCMException(10, "\u65e0\u6548\u7684ID\u5e8f\u5217.");
        }
        for (char c : string.trim().toCharArray()) {
            if (c == ',' || c == ' ' || Character.isDigit(c)) continue;
            throw new WCMException(10, "\u65e0\u6548\u7684ID\u5e8f\u5217.");
        }
    }

    public static void deleteMessage(int n, User user) throws WCMException {
        String string = "app/flowdoc/workflow_process_render.jsp?FlowDocId=" + n;
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MSGTYPE=? AND MBODY LIKE ? AND MSGID in(");
        stringBuffer.append("SELECT MSGID FROM WCMMSGRECEIVER WHERE RECEIVERTYPE=204 AND RECEIVERID=?");
        stringBuffer.append(")");
        wCMFilter.addSearchValues(3);
        wCMFilter.addSearchValues("%" + string + "%");
        wCMFilter.addSearchValues(user.getId());
        wCMFilter.setWhere(stringBuffer.toString());
        Messages messages = Messages.openWCMObjs(user, wCMFilter);
        if (messages.size() == 0) {
            return;
        }
        Message message = (Message)messages.getAt(0);
        if (message != null) {
            MessageServer.delete(user, String.valueOf(message.getId()));
        }
    }
}

