/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.MailContentHelper;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.TRSMailer;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EmailSendWorker
implements ISendWorker {
    private static Logger logger = Logger.getLogger(EmailSendWorker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, User user) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("TO_USER", user.getName());
        hashMap.put("CONTENT", message.getBody());
        hashMap.put("FROM_USER", message.getCrUserName());
        CMyEmail cMyEmail = new CMyEmail();
        cMyEmail.setTo(user.getEmail());
        cMyEmail.setSubject(message.getTitle());
        try {
            cMyEmail.setBody(MailContentHelper.makeEmailContent(hashMap));
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label1", "\u6784\u9020\u90ae\u4ef6\u5185\u5bb9\u5931\u8d25!"), (Throwable)exception);
        }
        cMyEmail.setMailFormat(1);
        String string = message.getCrUser().getEmail();
        logger.debug((Object)("FromEmail:" + string));
        cMyEmail.setFrom(string);
        cMyEmail.setFromUser(message.getCrUserName());
        TRSMailer tRSMailer = new TRSMailer();
        try {
            if (!tRSMailer.send(cMyEmail, CMySMTPServer.getDefaultSMTPServer())) {
                throw new WCMException(I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label2", "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!") + tRSMailer.getMailLogString());
            }
        }
        catch (CMyException cMyException) {
            logger.error((Object)I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label3", "\u90ae\u4ef6\u53d1\u9001\u53d1\u751f\u5f02\u5e38!"), (Throwable)cMyException);
        }
        finally {
            if (cMyEmail != null) {
                cMyEmail = null;
            }
        }
    }
}

