/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedules;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.database.FieldInfo;
import java.util.ArrayList;
import java.util.List;

public class Schedule
extends CMSObj {
    public static final int OBJ_TYPE = 501;
    public static final String DB_TABLE_NAME = "WCMSCHEDULE";
    public static final String DB_ID_NAME = "SCHID";
    public static final int MODE_ONE_TIME_DAY = 1;
    public static final int MODE_MORE_TIMES_DAY = 2;
    public static final int MODE_ONE_TIME_ONLY = 3;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_NOTSTART = 0;
    public static final int STATUS_WAIT = 1;
    public static final int STATUS_RUN = 5;
    public static final int STATUS_DONE = 7;
    public static final int STATUS_EXPIRED = 8;
    public static final int STATUS_FAILED = 9;
    public static final int STATUS_CANCELED = 10;
    public static final int STATUS_PARAM_INVALID = 11;
    public CMyDateTime dtAddList = CMyDateTime.now();

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 501;
    }

    public String getName() {
        return (String)this.getProperty("SCHNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("SCHNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("SCHDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("SCHDESC", string);
    }

    public int getSenderType() {
        return this.getPropertyAsInt("SENDERTYPE", 0);
    }

    public int getSenderId() {
        return this.getPropertyAsInt("SENDERID", 0);
    }

    public boolean setSender(int n, int n2) throws WCMException {
        return this.setProperty("SENDERTYPE", n) && this.setProperty("SENDERID", n2);
    }

    public boolean setSender(CMSObj cMSObj) throws WCMException {
        if (cMSObj == null) {
            return this.setSender(0, 0);
        }
        if (!cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label1", "\u6307\u5b9aSender\u5bf9\u8c61\u65e0\u6548(Job.setSender)"));
        }
        return this.setSender(cMSObj.getWCMType(), cMSObj.getId());
    }

    public int getStatus() {
        return this.getPropertyAsInt("SCHSTATUS", 1);
    }

    public boolean setStatus(int n) throws WCMException {
        return this.setProperty("SCHSTATUS", n);
    }

    public boolean isDeleted() {
        return this.getStatus() < 0;
    }

    public boolean setDeleted(boolean bl) throws WCMException {
        int n = this.getStatus();
        if (n < 0 == bl) {
            return false;
        }
        return this.setStatus(-n);
    }

    public int getWorkerTypeId() {
        return this.getPropertyAsInt("OPTYPE", 0);
    }

    public JobWorkerType getWorkerType() throws WCMException {
        int n = this.getWorkerTypeId();
        return JobWorkerType.findById(n);
    }

    public boolean setWorkerType(int n) throws WCMException {
        return this.setWorkerType(JobWorkerType.findById(n));
    }

    public boolean setWorkerType(JobWorkerType jobWorkerType) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1107, I18NMessage.get(Schedule.class, "Schedule.label2", "\u5c5e\u6027OpType\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (jobWorkerType == null || !jobWorkerType.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label3", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u6027\u5bf9\u8c61"));
        }
        return this.setProperty("OPTYPE", jobWorkerType.getId());
    }

    public String getOperArgs() {
        return (String)this.getProperty("OPARGS");
    }

    public String getOperArgValue(String string) {
        String string2 = this.getOperArgs();
        if (string2 == null || string2.length() <= 0) {
            return "";
        }
        AttributesString attributesString = new AttributesString(this.getOperArgs());
        return attributesString.getAttributeValue(string);
    }

    public List getOperArgNames() {
        String string = this.getOperArgs();
        if (string == null || string.length() <= 0) {
            return new ArrayList();
        }
        AttributesString attributesString = new AttributesString(this.getOperArgs());
        return attributesString.getNameList();
    }

    public boolean setOperArgs(String string) throws WCMException {
        return this.setProperty("OPARGS", string);
    }

    public int getMode() {
        return this.getPropertyAsInt("SCHMODE", 0);
    }

    public boolean setMode(int n) throws WCMException {
        return this.setProperty("SCHMODE", n);
    }

    public CMyDateTime getExeTime() {
        return (CMyDateTime)this.getProperty("ETime");
    }

    public boolean setExeTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label4", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setExeTime)"));
        }
        return this.setProperty("ETIME", cMyDateTime);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("SDATE");
    }

    public boolean setStartTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label5", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setStartTime)"));
        }
        return this.setProperty("SDATE", cMyDateTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EDATE");
    }

    public boolean setEndTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label6", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setEndTime)"));
        }
        return this.setProperty("EDATE", cMyDateTime);
    }

    public int getParam() {
        return this.getPropertyAsInt("PARAM", 0);
    }

    public boolean setParam(int n) throws WCMException {
        return this.setProperty("PARAM", n);
    }

    public CMyDateTime getLastExeTime() {
        return this.getPropertyAsDateTime("LASTEXETIME");
    }

    public boolean setLastExeTime() throws WCMException {
        return this.setProperty("LASTEXETIME", CMyDateTime.now());
    }

    public boolean setLastExeTime(CMyDateTime cMyDateTime) throws WCMException {
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label7", "\u6307\u5b9a\u65f6\u95f4\u65e0\u6548(Schedule.setLastExeTime)"));
        }
        return this.setProperty("LASTEXETIME", cMyDateTime.clone());
    }

    public int getLasExeResult() {
        return this.getPropertyAsInt("LASTEXERES", 0);
    }

    public boolean setLastExeResult(int n) throws WCMException {
        return this.setProperty("LASTEXERES", n);
    }

    public int getLastTimeUsed() {
        return this.getPropertyAsInt("LASTTIMEUSED", 0);
    }

    public boolean setLastTimeUsed(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label8", "\u6307\u5b9a\u7684\u65f6\u95f4\u503c\u5c0f\u4e8e0(Schedule.setTimeUsed)"));
        }
        return this.setProperty("LASTTIMEUSED", n);
    }

    public boolean isValid() throws WCMException {
        block16: {
            String string;
            block15: {
                string = null;
                if (!this.isAddMode()) break block15;
                string = (String)this.getAllProperty().get("SCHNAME");
                if (string == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label9", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                if (this.getProperty("OpType") == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label10", "\u64cd\u4f5c\u7c7b\u578b\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                if (this.getProperty("SchMode") == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label11", "Schedule\u6a21\u5f0f\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                switch (this.getMode()) {
                    case 2: {
                        if (this.getStartTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label12", "StartTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        if (this.getEndTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label13", "EndTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        if (this.getParam() <= 0) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label13", "EndTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    case 1: {
                        if (this.getExeTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label14", "ExeTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    case 3: {
                        if (this.getExeTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label15", "ExecTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    default: {
                        throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label16", "Mode\u4e0d\u7b26\u5408\u89c4\u8303(Schedule.isValid)"));
                    }
                }
            }
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Schedule.class, "Schedule.label17", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Schedule.isValid)"));
            }
            string = (String)this.getNewProperty("SCHNAME");
            if (!this.isChangeProperty("LASTEXETIME")) {
                FieldInfo fieldInfo = this.getDBManager().getFieldInfo(DB_TABLE_NAME, "LASTEXETIME");
                this.setProperty("LASTEXETIME", new NullValue(fieldInfo.getDataType().getType()));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            if (this.getAllProperty().get("SCHSTATUS") == null) {
                this.setStatus(1);
            }
            super.insert(user);
        }
    }

    public boolean logicalDelete(User user) throws WCMException {
        return this.doLogicalDelete(user, true);
    }

    public boolean logicalUndelete(User user) throws WCMException {
        return this.doLogicalDelete(user, false);
    }

    private boolean doLogicalDelete(User user, boolean bl) throws WCMException {
        if (!this.isValidInstance()) {
            return false;
        }
        boolean bl2 = false;
        try {
            if (this.isDeleted() == bl) {
                return true;
            }
            if (!this.canEdit(user)) {
                return false;
            }
            bl2 = true;
            this.setDeleted(bl);
            this.update(user);
            return true;
        }
        catch (Exception exception) {
            if (bl2) {
                try {
                    this.cancelUpdate(user);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new WCMException(1100, I18NMessage.get(Schedule.class, "Schedule.label18", "\u903b\u8f91\u5220\u9664\u8ba1\u5212\u5931\u8d25\uff08Schedule.logicalDelete\uff09"), exception);
        }
    }

    public synchronized Object clone() {
        Schedule schedule = (Schedule)super.clone();
        schedule.dtAddList = (CMyDateTime)this.dtAddList.clone();
        return schedule;
    }

    public boolean isFinished() {
        return this.getStatus() >= 7;
    }

    public static final Schedule findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Schedule)BaseObj.findById(Schedule.class, n);
    }

    public static final Schedule createNewInstance() throws WCMException {
        return (Schedule)BaseObj.createNewInstance(Schedule.class);
    }

    public static final Schedule findByKey(Object object) throws WCMException {
        return (Schedule)BaseObj.findByKey(Schedule.class, object);
    }

    public static final Schedule findBySender(int n, BaseObj baseObj) throws WCMException {
        String string = "OpType=? and SenderType=? and SenderId=?";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(baseObj.getWCMType());
        wCMFilter.addSearchValues(baseObj.getId());
        wCMFilter.setMaxRowNumber(1);
        Schedules schedules = Schedules.openWCMObjs(User.getSystem(), wCMFilter);
        if (schedules.isEmpty()) {
            return null;
        }
        return (Schedule)schedules.getAt(0);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Schedule.class, "Schedule.label19", "[\u8ba1\u5212\u4efb\u52a1-") + this.getId() + "]";
    }
}

