/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.message.Message;
import com.trs.components.common.reminder.Reminder;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.job.JobScheduler;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.calendar.DailyCalendar;

public class JobScheduleServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(JobScheduleServer.class);
    private boolean m_bSlaveNode = true;
    private JobScheduler m_oJobScheduler = (JobScheduler)DreamFactory.createObjectById("JobScheduler");

    protected void doShutdown() {
        this.m_oJobScheduler.shutDown();
    }

    protected boolean doStart() {
        ClusterConfig clusterConfig = ClusterConfigHelper.getConfig();
        boolean bl = this.m_bSlaveNode = clusterConfig.isEnabled() && !clusterConfig.isMaster();
        if (this.m_bSlaveNode) {
            return true;
        }
        try {
            Schedules schedules = new Schedules(User.getSystem());
            WCMFilter wCMFilter = new WCMFilter();
            schedules.open(wCMFilter);
            long l = System.currentTimeMillis();
            int n = schedules.size();
            for (int i = 0; i < n; ++i) {
                Schedule schedule = null;
                try {
                    schedule = (Schedule)schedules.getAt(i);
                    if (schedule == null) continue;
                    if (schedule.getMode() == 3) {
                        if (schedule.getStatus() >= 7) continue;
                        CMyDateTime cMyDateTime = schedule.getExeTime();
                        if (cMyDateTime == null || cMyDateTime.isNull()) {
                            logger.warn((Object)("Invalid job: " + schedule));
                            continue;
                        }
                        if (cMyDateTime.getTimeInMillis() < l) {
                            logger.info((Object)("Reschedule a one time only job: " + schedule));
                        }
                    }
                    this.scheduleJob(schedule);
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)(schedule + "schedule faild."), (Throwable)exception);
                    this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label2", "\u5c06Job\u52a0\u5165\u961f\u5217\u5931\u8d25!"), exception);
                }
            }
        }
        catch (WCMException wCMException) {
            this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label1", "\u83b7\u53d6\u7cfb\u7edf\u7684Schedule\u5931\u8d25!"), wCMException);
        }
        try {
            this.m_oJobScheduler.start();
        }
        catch (WCMException wCMException) {
            this.addError(I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label3", "\u542f\u52a8Scheduler\u5931\u8d25!"), wCMException);
            return false;
        }
        return true;
    }

    void deleteJob(Schedule schedule) throws WCMException {
        if (this.m_bSlaveNode) {
            return;
        }
        this.m_oJobScheduler.deleteJob(this.getJobName(schedule));
    }

    void scheduleJob(Schedule schedule) throws WCMException {
        Object object;
        if (this.m_bSlaveNode || schedule == null) {
            return;
        }
        AttributesString attributesString = new AttributesString(schedule.getOperArgs());
        try {
            attributesString.putAttributeValue("SenderType", String.valueOf(schedule.getSenderType()));
            attributesString.putAttributeValue("SenderId", String.valueOf(schedule.getSenderId()));
            attributesString.putAttributeValue("ScheduleId", "" + schedule.getId());
            object = schedule.getCrUserName();
            if (!CMyString.isEmpty((String)object)) {
                attributesString.putAttributeValue("CrUser", (String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (schedule.getMode() == 3) {
            this.m_oJobScheduler.addJob(this.getJobName(schedule), schedule.getWorkerType().getWorkerClass(), attributesString.toString(), schedule.getExeTime());
            return;
        }
        object = schedule.getWorkerType();
        if (object == null) {
            logger.error((Object)(schedule + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label4", "\u6307\u5b9a\u7684WorkerType[") + schedule.getWorkerTypeId() + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label5", "]\u65e0\u6548\uff01")));
            return;
        }
        Trigger trigger = this.getTrigger(schedule);
        this.m_oJobScheduler.addJob(this.getJobName(schedule), ((JobWorkerType)object).getWorkerClass(), attributesString.toString(), trigger);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Schedule To Start AT:" + trigger.getStartTime()));
            logger.debug((Object)("Schedule jod:" + this.getJobName(schedule) + " next fire at:" + trigger.getNextFireTime()));
        }
    }

    private String getJobName(Schedule schedule) {
        return "SCHEDULE[" + schedule.getId() + "]" + schedule.getName();
    }

    private Trigger getTrigger(Schedule schedule) throws WCMException {
        if (1 == schedule.getMode()) {
            return this.getCronTrigger(schedule, this.getTriggerName(schedule));
        }
        try {
            return this.getSimpleTrigger2(schedule, this.getTriggerName(schedule));
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label6", "\u83b7\u53d6\u8ba1\u5212\u4efb\u52a1\u7684\u89e6\u53d1\u5668\u5931\u8d25!"), cMyException);
        }
    }

    private String getTriggerName(Schedule schedule) {
        return this.getJobName(schedule) + "[Trigger]";
    }

    protected SimpleTrigger getSimpleTrigger2(Schedule schedule, String string) throws CMyException {
        CMyDateTime cMyDateTime = schedule.getStartTime();
        CMyDateTime cMyDateTime2 = schedule.getEndTime();
        int n = cMyDateTime.getHour();
        int n2 = cMyDateTime.getMinute();
        int n3 = cMyDateTime2.getHour();
        int n4 = cMyDateTime2.getMinute();
        long l = schedule.getParam() * 60 * 1000;
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        java.util.Calendar calendar2 = java.util.Calendar.getInstance();
        calendar2.set(11, n3);
        calendar2.set(12, n4);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        String string2 = string + "_dailyCalendar";
        DailyCalendar dailyCalendar = new DailyCalendar(string2, calendar, calendar2);
        dailyCalendar.setInvertTimeRange(true);
        this.m_oJobScheduler.registerCalendar(string2, (Calendar)dailyCalendar);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string, "DEFAULT");
        simpleTrigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        simpleTrigger.setRepeatInterval(l);
        simpleTrigger.setCalendarName(string2);
        simpleTrigger.setStartTime(calendar.getTime());
        return simpleTrigger;
    }

    protected SimpleTrigger getSimpleTrigger(Schedule schedule, String string) throws CMyException {
        CMyDateTime cMyDateTime = this.computeStartDate(schedule);
        CMyDateTime cMyDateTime2 = schedule.getStartTime();
        CMyDateTime cMyDateTime3 = schedule.getEndTime();
        int n = cMyDateTime.getMonth() - 1;
        int n2 = cMyDateTime.getDay();
        int n3 = cMyDateTime2.getHour();
        int n4 = cMyDateTime2.getMinute();
        int n5 = cMyDateTime3.getHour();
        int n6 = cMyDateTime3.getMinute();
        long l = schedule.getParam() * 60 * 1000;
        SimpleTrigger simpleTrigger = new SimpleTrigger(string, "DEFAULT");
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.set(2, n);
        calendar.set(5, n2);
        calendar.set(11, n3);
        calendar.set(12, n4);
        calendar.set(13, 0);
        calendar.set(14, 0);
        java.util.Calendar calendar2 = java.util.Calendar.getInstance();
        calendar2.set(2, n);
        calendar2.set(5, n2);
        calendar2.set(11, n5);
        calendar2.set(12, n6);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        simpleTrigger.setStartTime(calendar.getTime());
        simpleTrigger.setEndTime(calendar2.getTime());
        simpleTrigger.setRepeatCount(SimpleTrigger.REPEAT_INDEFINITELY);
        simpleTrigger.setRepeatInterval(l);
        return simpleTrigger;
    }

    private CMyDateTime computeStartDate(Schedule schedule) throws CMyException {
        CMyDateTime cMyDateTime = schedule.getLastExeTime();
        CMyDateTime cMyDateTime2 = CMyDateTime.now();
        if (cMyDateTime == null || cMyDateTime.isNull()) {
            return cMyDateTime2;
        }
        if (cMyDateTime2.dateDiff(3, cMyDateTime) == 0L && cMyDateTime2.getDay() == cMyDateTime.getDay()) {
            cMyDateTime2.dateAdd(3, 1);
        }
        return cMyDateTime2;
    }

    private Trigger getCronTrigger(Schedule schedule, String string) throws WCMException {
        CronTrigger cronTrigger = new CronTrigger(string, "DEFAULT");
        try {
            int n = schedule.getExeTime().getMinute();
            int n2 = schedule.getExeTime().getHour();
            String string2 = "0 " + n + " " + n2 + " * * ?";
            cronTrigger.setCronExpression(string2);
            return cronTrigger;
        }
        catch (Exception exception) {
            throw new WCMException(10, I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label7", "\u8ba1\u5212[") + schedule.getName() + "][" + schedule.getId() + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label8", "]\u8bbe\u5b9a\u7684\u65f6\u95f4\u6709\u8bef\uff01"), exception);
        }
    }

    public static Schedule saveSchedule(JobWorkerType jobWorkerType, Schedule schedule, CMSObj cMSObj) throws WCMException {
        String string = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label9", "\u4fdd\u5b58") + cMSObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label10", "\u4e0a\u6307\u5b9a\u7684\u8ba1\u5212");
        if (cMSObj == null || schedule == null) {
            throw new WCMException(string + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label11", "\u6ca1\u6709\u6307\u5b9a\u8ba1\u5212\u6216\u8005\u5bf9\u8c61\uff01"));
        }
        if (schedule.isAddMode()) {
            schedule.setSender(cMSObj);
            schedule.setWorkerType(jobWorkerType.getId());
        }
        schedule.save(ContextHelper.getLoginUser());
        return schedule;
    }

    public static Schedule deleteSchedule(JobWorkerType jobWorkerType, CMSObj cMSObj) throws WCMException {
        String string = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label12", "\u5220\u9664") + cMSObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label10", "\u4e0a\u6307\u5b9a\u7684\u8ba1\u5212");
        if (cMSObj == null) {
            throw new WCMException(string + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label13", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5bf9\u8c61\uff01"));
        }
        Schedule schedule = Schedule.findBySender(jobWorkerType.getId(), cMSObj);
        if (schedule == null) {
            throw new WCMException(string + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label14", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u627e\u5230") + cMSObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label15", "\u4e0a\u8bbe\u5b9a\u7684\u8ba1\u5212\uff01"));
        }
        schedule.delete(ContextHelper.getLoginUser());
        return schedule;
    }

    public static Schedule findSchedule(JobWorkerType jobWorkerType, CMSObj cMSObj) throws WCMException {
        String string = I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label16", "\u83b7\u53d6") + cMSObj + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label17", "\u4e0a\u7684\u8ba1\u5212");
        if (cMSObj == null) {
            throw new WCMException(string + I18NMessage.get(JobScheduleServer.class, "JobScheduleServer.label13", "\u5931\u8d25\u2014\u2014\u6ca1\u6709\u6307\u5b9a\u5bf9\u8c61\uff01"));
        }
        return Schedule.findBySender(jobWorkerType.getId(), cMSObj);
    }

    public static void main(String[] stringArray) {
        try {
            JobScheduleServer jobScheduleServer = new JobScheduleServer();
            jobScheduleServer.startup();
            Message message = new Message();
            message.setTitle("test");
            message.setBody("dfasfadsf");
            message.setReceivers(204, String.valueOf(User.findByName("admin").getId()));
            message.setValidTime(CMyDateTime.now().dateAdd(3, 1));
            message.save(User.findByName("admin"));
            Reminder.createSchedule(message, CMyDateTime.now());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

