/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.Contacts;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class MarkShare
extends CMSObj {
    public static final int OBJ_TYPE = 308;
    public static final String DB_TABLE_NAME = "WCMMARKSHARE";
    public static final String DB_ID_NAME = "SHAREID";
    public static final int MARKSHARE_STATE_ALLUSER = 0;

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 308;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int n) throws WCMException {
        if (n != 303 && n != 307) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label1", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MarkShare.setObjType\uff09"));
        }
        return this.setProperty("OBJTYPE", n);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(MarkShare.class, "MarkShare.label2", "ObjId\u503c\u65e0\u6548(MarkShare.setObjId)"));
        }
        return this.setProperty("OBJID", n);
    }

    public int getViewerType() {
        return this.getPropertyAsInt("VIEWERTYPE", 0);
    }

    public boolean setViewerType(int n) throws WCMException {
        if (n != 204 && n != 201 && n != 203 && n != 304 && n != 305 && n != 0) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label3", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MarkShare.setViewerType\uff09"));
        }
        return this.setProperty("VIEWERTYPE", n);
    }

    public int getViewerId() {
        return this.getPropertyAsInt("VIEWERID", 0);
    }

    public boolean setViewerId(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(MarkShare.class, "MarkShare.label4", "ViewerId\u503c\u65e0\u6548(MarkShare.setViewerId)"));
        }
        return this.setProperty("VIEWERID", n);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("Attribute", string);
    }

    public boolean isValid() throws WCMException {
        Number number = null;
        Number number2 = null;
        Number number3 = null;
        Number number4 = null;
        if (this.isAddMode()) {
            number = (Number)this.getAllProperty().get("OBJTYPE");
            number2 = (Number)this.getAllProperty().get("OBJID");
            number3 = (Number)this.getAllProperty().get("VIEWERTYPE");
            number4 = (Number)this.getAllProperty().get("VIEWERID");
            if (number == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label5", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (number2 == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label6", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (number3 == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label7", "\u5c5e\u6027ViewerType\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (number4 == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label8", "\u5c5e\u6027ViewerId\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MarkShare.class, "MarkShare.label9", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MarkShare.isValid)"));
            }
            number = (Number)this.getNewProperty("OBJTYPE");
            number2 = (Number)this.getNewProperty("OBJID");
            number3 = (Number)this.getNewProperty("VIEWERTYPE");
            number4 = (Number)this.getNewProperty("VIEWERID");
            if (number == null) {
                number = (Number)this.getAllProperty().get("OBJTYPE");
            }
            if (number2 == null) {
                number2 = (Number)this.getAllProperty().get("OBJID");
            }
            if (number3 == null) {
                number3 = (Number)this.getAllProperty().get("VIEWERTYPE");
            }
            if (number4 == null) {
                number4 = (Number)this.getAllProperty().get("VIEWERID");
            }
        }
        if (number != null || number2 != null || number3 != null || number4 != null) {
            String string = "ObjType=" + number + " and ObjId=" + number2 + " and ViewerType=" + number3 + " and ViewerId=" + number4;
            if (!this.isAddMode()) {
                string = string + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string = string + " and CrUser='" + this.getCrUserName() + "'")) {
                throw new WCMException(1108, I18NMessage.get(MarkShare.class, "MarkShare.label10", "\u76f8\u540c\u5171\u4eab\u5df2\u7ecf\u5b58\u5728\uff08MarkShare.isValid\uff09"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public void setViewer(CMSObj cMSObj) throws WCMException {
        int n;
        if (cMSObj == null || !cMSObj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label11", "\u65e0\u6548\u53c2\u6570(MarkShare.setViewer)"));
        }
        if (cMSObj instanceof User) {
            n = 204;
        } else if (cMSObj instanceof Group) {
            n = 201;
        } else if (cMSObj instanceof Role) {
            n = 203;
        } else if (cMSObj instanceof Contact) {
            n = 304;
        } else if (cMSObj instanceof ContactGrp) {
            n = 305;
        } else {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label12", "\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548(MarkShare.setObject)"));
        }
        this.setViewerType(n);
        this.setViewerId(cMSObj.getId());
    }

    public CMSObj getViewer(User user) throws WCMException {
        switch (this.getViewerType()) {
            case 204: {
                return User.findById(this.getViewerId());
            }
            case 203: {
                return Role.findById(this.getViewerId());
            }
            case 201: {
                return Group.findById(this.getViewerId());
            }
            case 304: {
                WCMFilter wCMFilter = new WCMFilter("", "ContactId=" + this.getViewerId(), "");
                Contacts contacts = new Contacts(user, 1, 1);
                Contact contact = null;
                try {
                    contacts.open(wCMFilter);
                    contact = (Contact)(contacts.isEmpty() ? null : contacts.getAt(0));
                    contacts.clear();
                    return contact;
                }
                catch (WCMException wCMException) {
                    throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label13", "\u53d6\u5171\u4eab\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getObject)"), wCMException);
                }
            }
            case 305: {
                WCMFilter wCMFilter = new WCMFilter("", "GroupId=" + this.getViewerId(), "");
                ContactGrps contactGrps = new ContactGrps(user, 1, 1);
                ContactGrp contactGrp = null;
                try {
                    contactGrps.open(wCMFilter);
                    contactGrp = (ContactGrp)(contactGrps.isEmpty() ? null : contactGrps.getAt(0));
                    contactGrps.clear();
                    return contactGrp;
                }
                catch (WCMException wCMException) {
                    throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label13", "\u53d6\u5171\u4eab\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getObject)"), wCMException);
                }
            }
        }
        return null;
    }

    public CMSObj getObject(User user) throws WCMException {
        switch (this.getObjType()) {
            case 303: {
                return this.getBookMark(user);
            }
            case 307: {
                return this.getMarkKind(user);
            }
        }
        throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label14", "\u65e0\u6548\u7684\u5171\u4eab\u5bf9\u8c61\u7c7b\u578b\uff08MarkShare.getObject\uff09"));
    }

    private BookMark getBookMark(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "MARKID=" + this.getObjId(), "");
        BookMarks bookMarks = new BookMarks(user);
        BookMark bookMark = null;
        try {
            bookMarks.open(wCMFilter);
            bookMark = bookMarks.isEmpty() ? null : (BookMark)bookMarks.getAt(0);
            return bookMark;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label15", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4e2d\u7684\u4e66\u7b7e\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getBookMark)"), wCMException);
        }
    }

    private MarkKind getMarkKind(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "KINDID=" + this.getObjId(), "");
        MarkKinds markKinds = new MarkKinds(user);
        MarkKind markKind = null;
        try {
            markKinds.open(wCMFilter);
            markKind = markKinds.isEmpty() ? null : (MarkKind)markKinds.getAt(0);
            return markKind;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label16", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4e2d\u7684\u4e66\u7b7e\u7c7b\u522b\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getMarkKind)"), wCMException);
        }
    }
}

