/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.components.common.bookmark.MarkShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class BookMark
extends CMSObj {
    public static final int OBJ_TYPE = 303;
    public static final String DB_TABLE_NAME = "WCMBOOKMARK";
    public static final String DB_ID_NAME = "MARKID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 303;
    }

    public String getName() {
        return (String)this.getProperty("MNAME");
    }

    public boolean setName(String string) throws WCMException {
        return this.setProperty("MNAME", string);
    }

    public String getLink() {
        return (String)this.getProperty("MLINK");
    }

    public boolean setLink(String string) throws WCMException {
        return this.setProperty("MLINK", string);
    }

    public String getIcon() {
        return (String)this.getProperty("MICON");
    }

    public boolean setIcon(String string) throws WCMException {
        return this.setProperty("MICON", string);
    }

    public int getKindId() {
        return this.getPropertyAsInt("MKIND", 0);
    }

    public MarkKind getKind() throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("wcmMarkKinds", "KindId=" + this.getKind(), "");
        MarkKinds markKinds = new MarkKinds(User.getSystem(), 1, 1);
        MarkKind markKind = null;
        try {
            markKinds.open(wCMFilter);
            markKind = markKinds.isEmpty() ? null : (MarkKind)markKinds.getAt(0);
            markKinds.clear();
            return markKind;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label1", "\u53d6\u4e66\u7b7e\u6240\u5c5e\u7c7b\u522b\u65f6\u51fa\u9519(BookMark.getKind)"), wCMException);
        }
    }

    public boolean setKind(int n) throws WCMException {
        if (n < 0) {
            throw new WCMException(1104, I18NMessage.get(BookMark.class, "BookMark.label2", "\u65e0\u6548\u7684\u4e66\u7b7e\u7c7b\u522b(BookMark.setKind)"));
        }
        return this.setProperty("MKIND", n);
    }

    public boolean setKind(MarkKind markKind) throws WCMException {
        if (markKind == null || !markKind.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(BookMark.class, "BookMark.label3", "\u65e0\u6548\u7684\u6807\u7b7e\u7c7b\u522b\u5bf9\u8c61\uff08BookMark.setKind\uff09"));
        }
        return this.setKind(markKind.getId());
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        Number number = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("MNAME");
            number = (Number)this.getAllProperty().get("MKIND");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(BookMark.class, "BookMark.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(BookMark.isValid)"));
            }
            if (number == null) {
                throw new WCMException(1106, I18NMessage.get(BookMark.class, "BookMark.label5", "\u5c5e\u6027Kind\u6ca1\u6709\u8bbe\u7f6e(BookMark.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(BookMark.class, "BookMark.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(BookMark.isValid)"));
            }
            string = (String)this.getNewProperty("MNAME");
            number = (Number)this.getNewProperty("MKIND");
            if (string != null && number == null) {
                number = (Number)this.getAllProperty().get("MKIND");
            }
            if (number != null && string == null) {
                string = (String)this.getAllProperty().get("MNAME");
            }
        }
        if (string != null || number != null) {
            String string2 = " (CrUser='" + this.getCrUserName() + "') and (MKind=" + number + " ) and (MName='" + CMyString.filterForSQL(string) + "')";
            if (!this.isAddMode()) {
                string2 = string2 + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(string2)) {
                throw new WCMException(1108, I18NMessage.get(BookMark.class, "BookMark.label7", "\u76f8\u540c\u4e66\u7b7e\u5df2\u7ecf\u5b58\u5728\uff08BookMark.isValid\uff09"));
            }
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public MarkShares getMarkShares(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=303 and ObjId=" + this.getId(), "");
        MarkShares markShares = new MarkShares(user);
        try {
            markShares.open(wCMFilter);
            return markShares;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label8", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4fe1\u606f\u65f6\u51fa\u9519(BookMark.getMarkShares)"), wCMException);
        }
    }

    public boolean isShared(User user) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=303 and ObjId=" + this.getId(), "", "ShareId");
        MarkShares markShares = new MarkShares(user, 1, 1);
        try {
            markShares.open(wCMFilter);
            boolean bl = !markShares.isEmpty();
            markShares.clear();
            return bl;
        }
        catch (WCMException wCMException) {
            throw new WCMException(1100, I18NMessage.get(BookMark.class, "BookMark.label9", "\u53d6\u4e66\u7b7e\u662f\u5426\u5171\u4eab\u65f6\u51fa\u9519(BookMark.isShared)"), wCMException);
        }
    }

    public static final BookMark findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (BookMark)BaseObj.findById(BookMark.class, n);
    }

    public static final BookMark createNewInstance() throws WCMException {
        return (BookMark)BaseObj.createNewInstance(BookMark.class);
    }

    public static final BookMark findByKey(Object object) throws WCMException {
        return (BookMark)BaseObj.findByKey(BookMark.class, object);
    }

    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(BookMark.class, "BookMark.label10", "[\u4e66\u7b7e-") + this.getId() + "]";
    }
}

