/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageSendingMapper;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.MsgSendWorker;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;

public class ContactMsgSender {
    public static void send(String string, String string2, String string3, Contact contact) throws WCMException {
        if (string3 == null || string3.length() == 0) {
            throw new WCMException(10, I18NMessage.get(ContactMsgSender.class, "ContactMsgSender.label1", "\u6ca1\u6709\u6307\u5b9a\u53d1\u9001\u7c7b\u578b!"));
        }
        if (contact == null) {
            throw new WCMException(10, I18NMessage.get(ContactMsgSender.class, "ContactMsgSender.label2", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        if (contact.isSystemUser()) {
            ContactMsgSender.sendToSystemUser(string, string2, string3, contact);
        } else {
            ContactMsgSender.sendTo(string, string2, string3, contact);
        }
    }

    private static void sendTo(String string, String string2, String string3, Contact contact) throws WCMException {
        Message message = Message.createNewInstance();
        message.setTitle(string);
        message.setBody(string2);
        message.setCrUser(contact.getCrUser());
        String[] stringArray = CMyString.split(string3, ",");
        ISendWorker iSendWorker = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = MessageSendingMapper.getInstance().getWorker(stringArray[i]);
            if (string4 == null) {
                throw new WCMException(1354, "Unknown message send type: " + stringArray[i]);
            }
            iSendWorker = (ISendWorker)DreamFactory.createObjectById(string4);
            if (iSendWorker instanceof MsgSendWorker) {
                return;
            }
            iSendWorker.send(message, new ContactAdapter(contact));
        }
    }

    private static void sendToSystemUser(String string, String string2, String string3, Contact contact) throws WCMException {
        Message message = Message.createNewInstance();
        message.setTitle(string);
        message.setBody(string2);
        message.setCrUser(contact.getCrUser());
        message.setReceivers(204, contact.getSystemUserId());
        message.setSendTypes(string3);
        MessageServer.send(message);
    }

    private static class ContactAdapter
    extends User {
        private Contact m_contact;

        public ContactAdapter(Contact contact) {
            this.m_contact = contact;
        }

        public String getName() {
            return this.m_contact.getUserName();
        }

        public String getMobile() {
            return this.m_contact.getMobile();
        }

        public String getEmail() {
            return this.m_contact.getEmail();
        }
    }
}

