/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.Contacts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ContactMgr {
    private static final String OBJ_CONTACT = I18NMessage.get(ContactMgr.class, "ContactMgr.label1", "\u8054\u7cfb\u4eba");
    private static final String OBJ_CONTACTGROUP = I18NMessage.get(ContactMgr.class, "ContactMgr.label2", "\u8054\u7cfb\u4eba\u5206\u7ec4");

    public Contact addContactFromSystemUser(User user) throws WCMException {
        this.assertNotNull(user, I18NMessage.get(ContactMgr.class, "ContactMgr.label3", "\u7528\u6237"));
        Contact contact = Contact.createNewInstance();
        contact.setUserName(user.getName());
        contact.setAddress(user.getAddress());
        contact.setCrUser(this.getLoginUser());
        contact.setMobile(user.getMobile());
        contact.setEmail(user.getEmail());
        contact.setTel(user.getTel());
        contact.setNickName(user.getNickName());
        contact.setDesc(I18NMessage.get(ContactMgr.class, "ContactMgr.label4", "\u7cfb\u7edf\u7528\u6237:") + user.getName());
        contact.setAttribute(user.getAttribute());
        contact.save(this.getLoginUser());
        return contact;
    }

    public Contact addContact(Contact contact, ContactGrp contactGrp) throws WCMException {
        this.assertNotNull(contact, OBJ_CONTACT);
        contact.save(this.getLoginUser());
        if (contactGrp != null) {
            contactGrp.addContact(contact, this.getLoginUser());
        }
        return contact;
    }

    public Contact saveContact(Contact contact) throws WCMException {
        return this.addContact(contact, null);
    }

    public void deleteContact(Contact contact) throws WCMException {
        this.assertNotNull(contact, OBJ_CONTACT);
        contact.delete(this.getLoginUser());
        this.syncContactGroupMap(contact);
    }

    public ContactGrp saveContactGroup(ContactGrp contactGrp) throws WCMException {
        this.assertNotNull(contactGrp, OBJ_CONTACTGROUP);
        contactGrp.save(this.getLoginUser());
        return contactGrp;
    }

    public void deleteContactGroup(ContactGrp contactGrp) throws WCMException {
        this.assertNotNull(contactGrp, OBJ_CONTACTGROUP);
        this.deleteChildren(contactGrp);
        this.syncContactGroupMap(contactGrp);
        contactGrp.delete();
    }

    private void deleteChildren(ContactGrp contactGrp) throws WCMException {
        ContactGrps contactGrps = contactGrp.getChildren();
        ContactGrp contactGrp2 = null;
        for (int i = 0; i < contactGrps.size(); ++i) {
            contactGrp2 = (ContactGrp)contactGrps.getAt(i);
            if (contactGrp2 == null) continue;
            this.deleteContactGroup(contactGrp2);
        }
    }

    public ContactGrps getGroups(Contact contact) throws WCMException {
        this.assertNotNull(contact, OBJ_CONTACT);
        String string = "EXISTS (SELECT * FROM WCMContGrpMap WHERE WCMContGrpMap.ContactId=" + contact.getId() + " AND WCMContGrpMap.ContGrpId=WCMContGroup.GroupId)";
        WCMFilter wCMFilter = new WCMFilter("", string, "");
        return this.getContactGroups(wCMFilter);
    }

    public ContactGrps getContactGroups(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("", "CrUser='" + CMyString.filterForSQL(user.getName()) + "'", "");
        wCMFilter2.mergeWith(wCMFilter);
        return ContactGrps.openWCMObjs(user, wCMFilter2);
    }

    public Contacts getContacts(WCMFilter wCMFilter, ContactGrp contactGrp) throws WCMException {
        this.assertNotNull(contactGrp, OBJ_CONTACTGROUP);
        String string = "EXISTS (SELECT * FROM WCMContGrpMap WHERE wcmContGrpMap.ContGrpId=" + contactGrp.getId() + " and wcmContact.ContactId=wcmContGrpMap.ContactId)";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "");
        wCMFilter2.mergeWith(wCMFilter);
        return this.getContacts(wCMFilter2);
    }

    public Contacts getContacts(WCMFilter wCMFilter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter wCMFilter2 = new WCMFilter("WCMCONTACT", "CrUser='" + CMyString.filterForSQL(user.getName()) + "'", "CrTime desc");
        wCMFilter2.mergeWith(wCMFilter);
        return Contacts.openWCMObjs(user, wCMFilter2);
    }

    public void removeContact(Contact contact, ContactGrp contactGrp) throws WCMException {
        this.assertNotNull(contact, OBJ_CONTACT);
        this.assertNotNull(contactGrp, OBJ_CONTACTGROUP);
        contactGrp.removeContact(contact, this.getLoginUser());
    }

    public void changeGroup(Contact contact, ContactGrp contactGrp, ContactGrp contactGrp2) throws WCMException {
        this.removeContact(contact, contactGrp);
        this.addContact(contact, contactGrp2);
    }

    private void assertNotNull(Object object, String string) throws WCMException {
        if (object == null) {
            throw new WCMException(10, I18NMessage.get(ContactMgr.class, "ContactMgr.label5", "\u65e0\u6548\u7684") + string + I18NMessage.get(ContactMgr.class, "ContactMgr.label6", "\u5bf9\u8c61[null]"));
        }
    }

    private void syncContactGroupMap(Contact contact) throws WCMException {
        String string = "DELETE FROM WCMCONTGRPMAP WHERE ContactId=" + contact.getId();
        DBManager.getDBManager().sqlExecuteUpdate(string);
    }

    private void syncContactGroupMap(ContactGrp contactGrp) throws WCMException {
        this.deleteContactIfNecessary(contactGrp);
        String string = "DELETE FROM WCMCONTGRPMAP WHERE ContGrpId=" + contactGrp.getId();
        DBManager.getDBManager().sqlExecuteUpdate(string);
    }

    private void deleteContactIfNecessary(ContactGrp contactGrp) throws WCMException {
        Contacts contacts = this.getContacts(null, contactGrp);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null || this.getGroups(contact).size() != 1) continue;
            contact.delete();
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

