/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class Contact
extends CMSObj {
    public static final int OBJ_TYPE = 304;
    public static final String DB_TABLE_NAME = "WCMCONTACT";
    public static final String DB_ID_NAME = "CONTACTID";

    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    public int getWCMType() {
        return 304;
    }

    public String getUserName() {
        return (String)this.getProperty("USERNAME");
    }

    public boolean setUserName(String string) throws WCMException {
        return this.setProperty("USERNAME", string);
    }

    public String getNickName() {
        return (String)this.getProperty("NICKNAME");
    }

    public boolean setNickName(String string) throws WCMException {
        return this.setProperty("NICKNAME", string);
    }

    public String getDesc() {
        return (String)this.getProperty("CDESC");
    }

    public boolean setDesc(String string) throws WCMException {
        return this.setProperty("CDESC", string);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String string) throws WCMException {
        return this.setProperty("EMAIL", string);
    }

    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    public boolean setAttribute(String string) throws WCMException {
        return this.setProperty("ATTRIBUTE", string);
    }

    public String getMobile() {
        return (String)this.getProperty("MOBILE");
    }

    public boolean setMobile(String string) throws WCMException {
        return this.setProperty("MOBILE", string);
    }

    public String getTel() {
        return (String)this.getProperty("TEL");
    }

    public boolean setTel(String string) throws WCMException {
        return this.setProperty("TEL", string);
    }

    public String getAddress() {
        return (String)this.getProperty("ADDRESS");
    }

    public boolean setAddress(String string) throws WCMException {
        return this.setProperty("ADDRESS", string);
    }

    public boolean isValid() throws WCMException {
        String string = null;
        if (this.isAddMode()) {
            string = (String)this.getAllProperty().get("USERNAME");
            if (string == null) {
                throw new WCMException(1106, I18NMessage.get(Contact.class, "Contact.label1", "\u5c5e\u6027UserName\u6ca1\u6709\u8bbe\u7f6e(Contact.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Contact.class, "Contact.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Contact.isValid)"));
        }
        return true;
    }

    public void insert(User user) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(user);
        }
    }

    public boolean isSystemUser() {
        return User.findByName(this.getUserName()) != null;
    }

    public String getSystemUserId() {
        if (!this.isSystemUser()) {
            throw new UnsupportedOperationException("not a system user");
        }
        int n = User.findByName(this.getUserName()).getId();
        return String.valueOf(n);
    }

    public static final Contact findById(int n) throws WCMException {
        if (n <= 0) {
            return null;
        }
        return (Contact)BaseObj.findById(Contact.class, n);
    }

    public static final Contact createNewInstance() throws WCMException {
        return (Contact)BaseObj.createNewInstance(Contact.class);
    }

    public static final Contact findByKey(Object object) throws WCMException {
        return (Contact)BaseObj.findByKey(Contact.class, object);
    }
}

