/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.comment.domain.NewsComment;
import com.trs.components.comment.publish.helper.CommentParserEntity;
import com.trs.components.comment.publish.helper.CommentParserUtil;
import com.trs.components.common.conjection.persistent.EntryConfig;
import com.trs.components.common.conjection.service.IComponentEntryConfigService;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class XWCMTagParserComment
implements ITagParser {
    private static Logger s_logger = Logger.getLogger(XWCMTagParserComment.class);
    private TagItem m_tagItem = null;
    private String m_sCurrPageEncoding = "UTF-8";
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TagBeanInfo tagBeanInfo = new TagBeanInfo();
            tagBeanInfo.setName("TRS_COMMENT");
            tagBeanInfo.setDesc("TRS_COMMENT");
            tagBeanInfo.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("COUNTER");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("CONTENTTYPE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("IPDISPLAYSTYLE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TOPRANGE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("DISPLAYCOMMENT");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TOPICID");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.INTEGER);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TOPICTITLE");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("ENCODING");
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("FIELD");
            tagBeanAttrInfo.setDesc("\u83b7\u53d6\u7279\u6b8a\u7684\u51e0\u4e2a\u5177\u4f53\u503c");
            tagBeanAttrInfo.setRequired(false);
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanAttrInfo.setEnumValue(new String[]{"APPURL", "VERIFYCODEIMG"});
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("APPURL");
            tagBeanAttrInfo.setDesc("\u6307\u5b9aAPPURL");
            tagBeanAttrInfo.setRequired(false);
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tagBeanInfo.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tagBeanInfo;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        CMSObj cMSObj;
        Object object;
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            return null;
        }
        if (!(iPublishElement.getSubstance() instanceof Document)) {
            throw new WCMException(I18NMessage.get(XWCMTagParserComment.class, "XWCMTagParserComment.label1", "\u5f53\u524d\u7684\u5bf9\u8c61[") + iPublishElement + I18NMessage.get(XWCMTagParserComment.class, "XWCMTagParserComment.label2", "]\u4e0d\u662f\u6587\u6863\u5bf9\u8c61\uff01"));
        }
        String string = publishTagContext.getAttribute("APPURL");
        if (CMyString.isEmpty(string)) {
            string = ConfigServer.getServer().getSysConfigValue("COMMENT_APPURL", "");
        }
        if (CMyString.isEmpty(string)) {
            object = (IComponentEntryConfigService)DreamFactory.createObjectById("IComponentEntryConfigService");
            cMSObj = object.getTypedEntryConfig(4);
            string = ((EntryConfig)cMSObj).getLinkPath();
        }
        if (CMyString.isEmpty(string)) {
            string = publishTagContext.getPathCompass().getRootDomain(publishTagContext.getRoot());
        }
        if (!CMyString.isEmpty((String)(object = publishTagContext.getAttribute("FIELD")))) {
            return this.parseField(string, (String)object);
        }
        cMSObj = (Document)iPublishElement.getSubstance();
        try {
            string = CMyString.setStrEndWith(string, '/');
            if (iPublishElement.getEncoding() != null) {
                this.m_sCurrPageEncoding = iPublishElement.getEncoding();
            }
            string = string + this.parseComment((Document)cMSObj, this.m_tagItem);
        }
        catch (Exception exception) {
            throw new WCMException("Failed to parse the  coment of document[" + cMSObj.getId() + "]!", exception);
        }
        return new String[]{string};
    }

    private String[] parseField(String string, String string2) {
        String[] stringArray = new String[1];
        if ("APPURL".equals(string2.toUpperCase())) {
            stringArray[0] = string;
        } else if ("VERIFYCODEIMG".equals(string2.toUpperCase())) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
            stringArray[0] = string = string + "cn/randCodeGen.jsp";
        }
        return stringArray;
    }

    private String parseComment(Document document, TagItem tagItem) throws WCMException {
        String string = null;
        try {
            String string2;
            NewsComment newsComment = new NewsComment();
            newsComment.setLimit(1);
            CommentParserEntity commentParserEntity = CommentParserUtil.getCommentParserEntity(document, tagItem);
            if (s_logger.isDebugEnabled()) {
                s_logger.info((Object)("Entity is : " + commentParserEntity.toString()));
            }
            newsComment.setNewsId(commentParserEntity.getId());
            newsComment.setNewsTitle(commentParserEntity.getTitle());
            newsComment.setTopicId(commentParserEntity.getTopicId());
            newsComment.setTopicTitle(commentParserEntity.getTopicTitle());
            newsComment.setSiteId(commentParserEntity.getSiteId());
            newsComment.setChannelId(commentParserEntity.getChannelId());
            int n = tagItem.getIntAttribute("COUNTER", 0);
            if (n != 0) {
                string2 = this.getAdditionalData(tagItem, n);
                newsComment.setAdditionalData(string2);
            }
            string2 = newsComment.getDataWithSign();
            string = "comment?newsid=" + commentParserEntity.getId() + "&encoding=" + this.m_sCurrPageEncoding + "&data=" + string2;
            String string3 = tagItem.getAttribute("DISPLAYCOMMENT");
            if (string3 != null) {
                String string4 = this.getIfDisplayCommentParam(string3);
                string = string + string4;
            }
        }
        catch (Exception exception) {
            throw new WCMException("Failed to parse the comment tag!", exception);
        }
        return string;
    }

    private String getIfDisplayCommentParam(String string) throws WCMException {
        if (!(string = string.toLowerCase()).equals("false") && !string.equals("true")) {
            throw new WCMException("invalid attribute value '" + string + "' for DISPLAYCOMMENT of <TRS_COMMENT>!");
        }
        String string2 = string.equals("false") ? "&displaycomment=0" : "";
        return string2;
    }

    private String getAdditionalData(TagItem tagItem, int n) throws WCMException {
        String string = tagItem.getAttribute("CONTENTTYPE");
        String string2 = tagItem.getAttribute("TOPRANGE");
        int n2 = tagItem.getIntAttribute("IPDISPLAYSTYLE", 1);
        if (string == null) {
            string = "JS";
        } else if (!NewsComment.isValidContentType(string)) {
            throw new WCMException("invalid attribute value '" + string + "' for CONTENTTYPE of <TRS_COMMENT>!");
        }
        if (string2 == null) {
            string2 = "TIME";
        } else if (!NewsComment.isValidTopRange(string2)) {
            throw new WCMException("invalid attribute value '" + string2 + "' for TOPRANGE of <TRS_COMMENT>!");
        }
        String string3 = tagItem.getAttribute("ENCODING");
        if (CMyString.isEmpty(string3)) {
            string3 = this.m_sCurrPageEncoding;
        }
        String string4 = n + ";" + string + ";" + string2 + ";" + n2 + ";" + string3;
        return string4;
    }
}

