/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignUtil {
    private Signature m_signat;
    private Signature m_verify;
    private static SignUtil defaultSignat;
    private static SignUtil defaultVerify;
    private static final char[] encode_array;
    private static final byte[] decode_array;

    private SignUtil() {
    }

    public byte[] decodeRadix64(byte[] byArray) {
        int n = byArray.length / 4 * 3;
        if (n == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 46) {
            --n;
            if (byArray[byArray.length - 2] == 46) {
                --n;
            }
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (n = byArray.length; n > 0; n -= 4) {
            byte by = decode_array[byArray[n2++] & 0xFF];
            byte by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (byArray[n2] == 46) {
                return byArray2;
            }
            by = by2;
            by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            if (byArray[n2] == 46) {
                return byArray2;
            }
            by = by2;
            by2 = decode_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
        }
        return byArray2;
    }

    String encodeRadix64(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= 3) {
            byte by;
            byte by2;
            byte by3;
            if (i == 1) {
                by3 = byArray[n++];
                by2 = 0;
                by = 0;
                byArray2[n2++] = (byte)encode_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)encode_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = 46;
                byArray2[n2++] = 46;
                continue;
            }
            if (i == 2) {
                by3 = byArray[n++];
                by2 = byArray[n++];
                by = 0;
                byArray2[n2++] = (byte)encode_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)encode_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = (byte)encode_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                byArray2[n2++] = 46;
                continue;
            }
            by3 = byArray[n++];
            by2 = byArray[n++];
            by = byArray[n++];
            byArray2[n2++] = (byte)encode_array[by3 >>> 2 & 0x3F];
            byArray2[n2++] = (byte)encode_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            byArray2[n2++] = (byte)encode_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
            byArray2[n2++] = (byte)encode_array[by & 0x3F];
        }
        return new String(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SignUtil getSign() throws Exception {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (defaultSignat == null) {
            try {
                SignUtil signUtil = new SignUtil();
                inputStream = signUtil.getClass().getResourceAsStream("/meta-inf/prikey.dat");
                if (inputStream == null) {
                    throw new Exception("miss file \"/meta-inf/prikey.dat\"");
                }
                byteArrayOutputStream = new ByteArrayOutputStream(256);
                int n = 0;
                byte[] byArray = new byte[512];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                Signature signature = Signature.getInstance("DSA");
                signature.initSign(privateKey);
                signUtil.m_signat = signature;
                defaultSignat = signUtil;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return defaultSignat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignUtil getVerify() throws Exception {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (defaultVerify == null) {
            try {
                SignUtil signUtil = new SignUtil();
                inputStream = signUtil.getClass().getResourceAsStream("/meta-inf/pubkey.dat");
                if (inputStream == null) {
                    throw new Exception("miss file \"/meta-inf/pubkey.dat\"");
                }
                byteArrayOutputStream = new ByteArrayOutputStream(256);
                int n = 0;
                byte[] byArray = new byte[512];
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                Signature signature = Signature.getInstance("DSA");
                signature.initVerify(publicKey);
                signUtil.m_verify = signature;
                defaultVerify = signUtil;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return defaultVerify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sign(byte[] byArray) throws Exception {
        Signature signature;
        Signature signature2 = signature = this.m_signat;
        synchronized (signature2) {
            signature.update(byArray);
            return signature.sign();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] byArray, int n) throws Exception {
        Signature signature;
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        Signature signature2 = signature = this.m_verify;
        synchronized (signature2) {
            signature.update(byArray, 0, n2 - 4);
            return signature.verify(byArray2);
        }
    }

    static {
        int n;
        defaultSignat = null;
        defaultVerify = null;
        encode_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decode_array = new byte[256];
        for (n = 0; n < 255; ++n) {
            SignUtil.decode_array[n] = -1;
        }
        for (n = 0; n < encode_array.length; ++n) {
            SignUtil.decode_array[SignUtil.encode_array[n]] = (byte)n;
        }
    }
}

